/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map;

import com.indy.map.ComputedField;
import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.SetDescriptor;
import com.indy.map.ref.RLogicalField;
import com.indy.map.ref.RSourceItem;
import java.util.Comparator;

public interface IDataStore {
    public static String createNewFieldAlias(IContainer container, String name, int number, ILogicalField renamedObject) {
        String _name = name.replaceAll("[^A-Z^a-z^0-9_]", "_");
        _name = number == 1 ? _name : String.valueOf(_name) + "_" + number;
        for (ILogicalField a : container.getLogicalField()) {
            if (renamedObject == a || a.getLabel() == null || !a.getLabel().toString().equals(_name)) continue;
            return IDataStore.createNewFieldAlias(container, name, number + 1, renamedObject);
        }
        return _name;
    }

    public static String createNewComputedFieldAlias(IContainer container, String name, int number, ComputedField renamedObject) {
        String _name = name.replaceAll("[^A-Z^a-z^0-9_]", "_");
        _name = number == 1 ? _name : String.valueOf(_name) + "_" + number;
        for (ComputedField a : container.getComputedField()) {
            if (renamedObject == a || a.getLabel() == null || !a.getLabel().toString().equals(_name)) continue;
            return IDataStore.createNewComputedFieldAlias(container, name, number + 1, renamedObject);
        }
        return _name;
    }

    public static String createNewSetAlias(IContainer container, String name, int number) {
        String _name = name.replaceAll("[^A-Z^a-z^0-9_]", "_");
        _name = number == 1 ? _name : String.valueOf(_name) + "_" + number;
        for (SetDescriptor a : container.getSetDescriptor()) {
            if (a.getLabel() == null || !a.getLabel().toString().startsWith(_name)) continue;
            return IDataStore.createNewSetAlias(container, name, number + 1);
        }
        return _name;
    }

    public static String createNewSetAlias(IContainer container) {
        int current = 65;
        int curNum = 0;
        boolean isOk = false;
        String res = null;
        while (!isOk) {
            String candidate = curNum > 0 ? "" + (char)current + curNum : "" + (char)current;
            isOk = true;
            for (SetDescriptor a : container.getSetDescriptor()) {
                if (a.getLabel() == null || !a.getLabel().toString().toUpperCase().equals(candidate)) continue;
                isOk = false;
                break;
            }
            if (isOk) {
                res = candidate;
                break;
            }
            if ((current = (char)(current + '\u0001')) <= 90) continue;
            current = 65;
            ++curNum;
        }
        return res;
    }

    public String getDelimiterMask();

    public String getDelimiterRule();

    public void setHierarchical(boolean var1);

    public boolean isHierarchical();

    public static class FieldComparator
    implements Comparator<Field> {
        int intMapFirst;
        int intUsedFirst;
        int inverse;
        SortMode type;

        public FieldComparator(int mappedFieldFirst, int usedFieldFirst, int asc, SortMode mode) {
            this.intMapFirst = mappedFieldFirst;
            this.intUsedFirst = usedFieldFirst;
            this.inverse = asc;
            this.type = mode;
        }

        @Override
        public int compare(Field o1, Field o2) {
            if (this.intMapFirst != 0) {
                if (o1.isEnable() && !o2.isEnable()) {
                    return this.intMapFirst * -1;
                }
                if (o2.isEnable() && !o1.isEnable()) {
                    return this.intMapFirst * 1;
                }
            }
            if (this.intUsedFirst != 0) {
                RSourceItem refSrc1 = (RSourceItem)o1.getMapReference();
                RSourceItem refSrc2 = (RSourceItem)o2.getMapReference();
                if (refSrc1 == null) {
                    if (refSrc2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (refSrc2 == null) {
                    return 1;
                }
                if (refSrc1.getUsage().size() > 0 && refSrc2.getUsage().size() == 0) {
                    return this.intUsedFirst * -1;
                }
                if (refSrc2.getUsage().size() > 0 && refSrc1.getUsage().size() == 0) {
                    return this.intUsedFirst * 1;
                }
            }
            if (this.type.equals((Object)SortMode.POSITION)) {
                if (o1 != null && o2 != null) {
                    RLogicalField r1 = (RLogicalField)o1.getMapReference();
                    RLogicalField r2 = (RLogicalField)o2.getMapReference();
                    if (r1 != null && r2 != null && r1.getPosition() != null && r2.getPosition() != null) {
                        return this.inverse * r1.getPosition().compareTo(r2.getPosition());
                    }
                }
            } else if (this.type.equals((Object)SortMode.NAME) && o1 != null && o2 != null && o1.getLabel() != null && o2.getLabel() != null) {
                return this.inverse * o1.getLabel().compareTo(o2.getLabel());
            }
            return 0;
        }

        public static enum SortMode {
            POSITION,
            NAME;

        }
    }
}

