/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum JoinMode implements Enumerator
{
    DEFAULT(0, "Default", "Default"),
    EXPLICIT(1, "Explicit", "Explicit"),
    IMPLICIT(2, "Implicit", "Implicit");

    public static final int DEFAULT_VALUE = 0;
    public static final int EXPLICIT_VALUE = 1;
    public static final int IMPLICIT_VALUE = 2;
    private static final JoinMode[] VALUES_ARRAY;
    public static final List<JoinMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new JoinMode[]{DEFAULT, EXPLICIT, IMPLICIT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static JoinMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            JoinMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static JoinMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            JoinMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static JoinMode get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT;
            }
            case 1: {
                return EXPLICIT;
            }
            case 2: {
                return IMPLICIT;
            }
        }
        return null;
    }

    private JoinMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

