/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MapLocation implements Enumerator
{
    SRC(0, "SRC", "SRC"),
    WRK(1, "WRK", "WRK"),
    TRG(2, "TRG", "TRG");

    public static final int SRC_VALUE = 0;
    public static final int WRK_VALUE = 1;
    public static final int TRG_VALUE = 2;
    private static final MapLocation[] VALUES_ARRAY;
    public static final List<MapLocation> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MapLocation[]{SRC, WRK, TRG};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MapLocation get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MapLocation result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MapLocation getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MapLocation result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MapLocation get(int value) {
        switch (value) {
            case 0: {
                return SRC;
            }
            case 1: {
                return WRK;
            }
            case 2: {
                return TRG;
            }
        }
        return null;
    }

    private MapLocation(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

