/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.api.internal;

import com.indy.map.Clause;
import com.indy.map.DataSet;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.Join;
import com.indy.map.api.IMetaDataInformationsProvider;
import com.indy.map.api.internal.DesignMapAPI;
import com.indy.map.ref.RComputedField;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RUsage;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BuildMapAPI
extends DesignMapAPI {
    HashMap<DataSet, List<Join>> joinsPerDataSet = new HashMap();
    HashMap<Clause, List<IContainer>> containersPerClause = new HashMap();
    HashMap<IContainer, List<IContainer>> srcContainersPerContainer = new HashMap();
    private HashMap<RUsage, UsageInfo> usageMap = new HashMap();
    private HashMap<RSourceItem, Set<RUsage>> sourceMap = new HashMap();

    public BuildMapAPI(IMetaDataInformationsProvider mdHelper) {
        super(mdHelper);
    }

    private Collection<RUsage> getUsage(RSourceItem src) {
        Set<RUsage> s = this.sourceMap.get(src);
        if (s != null) {
            return s;
        }
        s = this.createUsageSource(src);
        this.sourceMap.put(src, s);
        return s;
    }

    private Set<RUsage> createUsageSource(RSourceItem src) {
        HashSet<RUsage> s = new HashSet<RUsage>();
        for (RUsage u : src.getUsage()) {
            if (u instanceof RComputedField) {
                s.addAll(this.getUsage((RComputedField)u));
                continue;
            }
            s.add(u);
        }
        return s;
    }

    private Collection<RSourceItem> getSourceItem(RUsage usage) {
        UsageInfo s = this.usageMap.get(usage);
        if (s != null) {
            return s.getSources();
        }
        s = this.createUsageInfo(usage);
        this.usageMap.put(usage, s);
        return s.getSources();
    }

    private UsageInfo createUsageInfo(RUsage usage) {
        UsageInfo inf = new UsageInfo();
        inf.setInternalExpression(usage.getInternalExpression());
        for (RSourceItem src : usage.getSourceRef()) {
            if (src instanceof RComputedField) {
                inf.sources.addAll(this.getSourceItem((RComputedField)src));
                inf.setInternalExpression(inf.getInternalExpression().replace("${" + ((ILogicalField)((Object)src.getDataModel())).getFullPath() + "}$", this.getInternalExpression((RComputedField)src)));
                continue;
            }
            inf.sources.add(src);
        }
        return inf;
    }

    @Override
    protected String getInternalExpression(RUsage usage) {
        UsageInfo s = this.usageMap.get(usage);
        if (s != null) {
            return s.getInternalExpression();
        }
        s = this.createUsageInfo(usage);
        this.usageMap.put(usage, s);
        return s.getInternalExpression();
    }

    @Override
    public List<IContainer> getInvolvedContainers(Clause clause) {
        List<IContainer> res = this.containersPerClause.get(clause);
        if (res == null) {
            res = super.getInvolvedContainers(clause);
            this.containersPerClause.put(clause, res);
        }
        return res;
    }

    @Override
    public List<Join> getJoins(DataSet ds) {
        List<Join> res = this.joinsPerDataSet.get(ds);
        if (res == null) {
            res = super.getJoins(ds);
            this.joinsPerDataSet.put(ds, res);
        }
        return res;
    }

    @Override
    public List<IContainer> getSrcContainers(IContainer container) {
        List<IContainer> res = this.srcContainersPerContainer.get(container);
        if (res == null) {
            res = super.getSrcContainers(container);
            this.srcContainersPerContainer.put(container, res);
        }
        return res;
    }

    @Override
    protected Collection<RSourceItem> getSourceItems(RUsage usage) {
        UsageInfo s = this.usageMap.get(usage);
        if (s != null) {
            return s.getSources();
        }
        s = this.createUsageInfo(usage);
        this.usageMap.put(usage, s);
        return s.getSources();
    }

    @Override
    public void clearCache() {
        this.containersPerClause.clear();
        this.joinsPerDataSet.clear();
        this.sourceMap.clear();
        this.srcContainersPerContainer.clear();
        this.usageMap.clear();
    }

    private class UsageInfo {
        private String internalExpression;
        private Set<RSourceItem> sources = new HashSet<RSourceItem>();

        private UsageInfo() {
        }

        public String getInternalExpression() {
            if (this.internalExpression == null) {
                return "";
            }
            return this.internalExpression;
        }

        public void setInternalExpression(String internalExpression) {
            this.internalExpression = internalExpression;
        }

        public Set<RSourceItem> getSources() {
            return this.sources;
        }
    }
}

