/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.builder;

import com.indy.map.Map;
import com.indy.map.builder.MetadataAndProcessBuilder;
import com.indy.map.compute.graph.Graph;
import com.indy.map.compute.graph.GraphBuilderFactory;
import com.indy.map.compute.graph.ISortedGraph;
import com.indy.map.messages.Messages;
import com.indy.map.ref.RMap;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IMappingBuilderDelegate;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;

@Component(service={IMappingBuilderDelegate.class})
public class MapBuilder
implements IMappingBuilderDelegate {
    public void prebuildMapping(Resource resource) throws Throwable {
        Map map = null;
        for (EObject o : resource.getContents()) {
            if (o.eContents().isEmpty()) continue;
            map = (Map)o.eContents().get(0);
        }
        if (!((RMap)map.getMapReference()).hasErrors()) {
            MetadataAndProcessBuilder.build(map, false);
        }
    }

    public void buildMapping(Resource resource) throws Exception {
        Map map = null;
        for (EObject o : resource.getContents()) {
            if (o.eContents().isEmpty()) continue;
            map = (Map)o.eContents().get(0);
        }
        if (((RMap)map.getMapReference()).hasErrors()) {
            throw new Exception(Messages.bind((String)Messages.MapBuilder_1, (Object)resource.getURI().toPlatformString(true)));
        }
        MetadataAndProcessBuilder.build(map);
    }

    public boolean canBeBuilt(Resource resource) {
        Map map = null;
        for (EObject o : resource.getContents()) {
            if (o.eContents().isEmpty()) continue;
            map = (Map)o.eContents().get(0);
        }
        return !((RMap)map.getMapReference()).hasErrors();
    }

    public List<String> getPrebuiltFilesPath(URI mappingURI) throws Exception {
        String id = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getSourceId(mappingURI);
        ArrayList<String> res = new ArrayList<String>();
        Bundle bundle = Platform.getBundle((String)"com.indy.gmf.map");
        IPath path = Platform.getStateLocation((Bundle)bundle);
        path = path.append("/tempBuiltFiles");
        res.add(path.append(String.valueOf(id) + ".md").toFile().getAbsolutePath());
        res.add(path.append(String.valueOf(id) + ".proc").toFile().getAbsolutePath());
        File[] fileArray = path.toFile().listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File ff = fileArray[n2];
            if (ff.getName().startsWith(String.valueOf(id) + "-ref-") && ff.getName().endsWith(".md")) {
                res.add(ff.getAbsolutePath());
            }
            ++n2;
        }
        return res;
    }

    public Collection<String> getAllDependancies(URI f) {
        HashSet<String> res = new HashSet<String>();
        try {
            Graph g = GraphBuilderFactory.INSTANCE.getGraphBuilder(GraphBuilderFactory.GraphType.RESOURCE_DEPENDENCY, Collections.singleton(f));
            if (g instanceof ISortedGraph) {
                for (URI uri : ((ISortedGraph)((Object)g)).getAllSortedModelItem()) {
                    String id = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getSourceId(uri);
                    if (id == null) continue;
                    res.add(id);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return res;
    }
}

