/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.builder;

import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.IMetaData;
import com.indy.map.Map;
import com.indy.map.Outliner;
import com.indy.map.Query;
import com.indy.map.QueryField;
import com.indy.map.builder.MetadataAndProcessBuilder;
import com.indy.map.ref.RLogicalField;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.stambia.md.Attribute;
import com.stambia.md.DocumentRoot;
import com.stambia.md.Element;
import com.stambia.md.MdFactory;
import com.stambia.md.MdNode;
import com.stambia.md.MdRootNode;
import com.stambia.md.impl.MdNodeImpl;
import com.stambia.md.util.MdFactoryHelper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;

public class StageMdGenerator {
    private ResourceSet resourceSet;
    private static final String SCHEMA = "com.stambia.rdbms.schema";
    private static final String DATASTORE = "com.stambia.rdbms.datastore";
    private static final String COLUMN = "com.stambia.rdbms.column";

    public StageMdGenerator(ResourceSet rs) {
        this.resourceSet = rs;
    }

    public HashMap<IMetaData, MdNode> generateMdResources(Map map, boolean intoWorkspace) throws Exception {
        HashMap containersByConnections = new HashMap();
        HashMap uriMap = new HashMap();
        map.getContainer().stream().filter(c -> c instanceof Query || c instanceof Outliner).filter(c -> this.isStageWithDataTypeDefined((IContainer)c)).forEach(container -> {
            EObject obj = container.getStagingArea();
            URI u = obj.eIsProxy() ? ((InternalEObject)obj).eProxyURI() : EcoreUtil.getURI((EObject)obj);
            EObject t = (EObject)uriMap.get(u);
            if (t == null) {
                uriMap.put(u, obj);
            } else {
                obj = t;
            }
            ArrayList<IContainer> c = (ArrayList<IContainer>)containersByConnections.get(obj);
            if (c == null) {
                if (obj.eIsProxy()) {
                    obj = map.eResource().getResourceSet().getEObject(((InternalEObject)obj).eProxyURI(), true);
                }
                c = new ArrayList<IContainer>();
                containersByConnections.put((MdNode)obj, c);
            }
            c.add((IContainer)container);
        });
        HashMap<IMetaData, MdNode> res = new HashMap<IMetaData, MdNode>();
        for (MdNode n : containersByConnections.keySet()) {
            Collection containers = (Collection)containersByConnections.get(n);
            String stagingAreaContainerLevelName = null;
            try {
                stagingAreaContainerLevelName = map.getAPI().getMdEvaluator().evaluateStageFieldContainerLevel((IContainer)containers.iterator().next());
            }
            catch (Exception exception) {
                // empty catch block
            }
            HashMap<IMetaData, MdNode> createdMd = null;
            createdMd = stagingAreaContainerLevelName == null || stagingAreaContainerLevelName.isEmpty() ? this._generateMdFileOldRDBMS(intoWorkspace, map, n, containers) : this.generateMdFile(map, n, containers, intoWorkspace);
            res.putAll(createdMd);
        }
        return res;
    }

    private boolean isStageWithDataTypeDefined(IContainer container) {
        for (ILogicalField f : container.getLogicalField()) {
            if (!(f instanceof QueryField) || ((QueryField)f).getMdNode() == null) continue;
            return true;
        }
        return false;
    }

    private HashMap<IMetaData, MdNode> generateMdFile(Map map, MdNode stagingArea, Collection<IContainer> collection, boolean intoWorkspace) throws Exception {
        String stagingAreaContainerLevelName = null;
        try {
            stagingAreaContainerLevelName = map.getAPI().getMdEvaluator().evaluateStageFieldContainerLevel(collection.iterator().next());
        }
        catch (Exception exception) {
            // empty catch block
        }
        AtomicReference<String> stagingAreaFieldLevelName = new AtomicReference<String>();
        try {
            stagingAreaFieldLevelName.set(map.getAPI().getMdEvaluator().evaluateStageFieldLevel(collection.iterator().next()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (stagingAreaFieldLevelName.get() == null) {
            throw new Exception("Missing xPath expression BUILD_STAGE_FIELD_LEVEL on the stageArea " + EcoreUtil.getURI((EObject)stagingArea));
        }
        MdNode subParent = map.getAPI().getMdEvaluator().toSubMdParent((EObject)stagingArea);
        if (subParent != null) {
            stagingArea = subParent;
        }
        String stagingAreaLevelDefType = map.getAPI().getMdEvaluator().getLevelDefType((IMetaData)((Object)collection.iterator().next()));
        HashMap<IMetaData, MdNode> res = new HashMap<IMetaData, MdNode>();
        MdRootNode root = MdFactoryHelper.createMdRootNode((String)stagingAreaLevelDefType);
        root.setSubMd(true);
        ((MdNodeImpl)root).setRef((EObject)stagingArea);
        root.setId(String.valueOf(map.getId()) + "-Stage-" + CacheHelper.extractEltID((EObject)stagingArea));
        root.setSubstituteContainer(stagingArea.eContainer());
        root.setName(CacheHelper.extractEltName((EObject)stagingArea));
        for (IContainer q : collection) {
            MdNode store = MdFactoryHelper.createMdNode((String)stagingAreaContainerLevelName);
            root.getNode().add((Object)store);
            this.normalizeId((Element)store, q.getId());
            store.setName(q.getAlias().toString());
            res.put((IMetaData)((Object)q), store);
            q.getLogicalField().stream().filter(f -> f instanceof QueryField).map(f -> (QueryField)f).forEach(f -> {
                MdNode mdNode2 = res.put((IMetaData)f, this.duplicateMdField((QueryField)f, store, (String)stagingAreaFieldLevelName.get()));
            });
        }
        this.saveMd(root, stagingArea, map, intoWorkspace);
        return res;
    }

    private void saveMd(MdRootNode rootNode, MdNode stagingArea, Map map, boolean intoWorkspace) {
        URI mapURI = map.eResource().getURI();
        StringBuffer buf = new StringBuffer();
        URI mdURI = null;
        if (!intoWorkspace) {
            mdURI = URI.createPlatformPluginURI((String)("com.indy.gmf.map/" + map.getId() + "-ref-" + stagingArea.getId() + ".md"), (boolean)true);
        } else {
            int i = 1;
            while (i < mapURI.segmentCount() - 1) {
                buf.append("/");
                buf.append(URI.decode((String)mapURI.segment(i)));
                if (i == 1) {
                    buf.append("/indy.build");
                }
                ++i;
            }
            buf.append("/" + map.getName() + "-ref-" + stagingArea.getId() + ".md");
            mdURI = URI.createPlatformResourceURI((String)buf.toString(), (boolean)true);
        }
        buf.append("/" + map.getName() + "-ref-" + CacheHelper.extractEltID((EObject)stagingArea) + ".md");
        if (!intoWorkspace) {
            this.resourceSet.setURIConverter((URIConverter)new MetadataAndProcessBuilder.TemporaryFolderOutputURIConverter(this.resourceSet.getURIConverter()));
        }
        Resource r = this.resourceSet.createResource(mdURI);
        ((XMLResource)r).setEncoding("UTF-8");
        DocumentRoot docRoot = MdFactory.eINSTANCE.createDocumentRoot();
        docRoot.setNode(rootNode);
        r.getContents().add((Object)docRoot);
        try {
            HashMap<String, String> opts = new HashMap<String, String>();
            opts.put("ENCODING", "UTF-8");
            r.save(new HashMap());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private MdNode duplicateMdField(QueryField f, MdNode store, String createdMdDefType) {
        MdNode n = f.getMdNode();
        MdNode field = MdFactoryHelper.createMdNode((String)createdMdDefType);
        field.setName(f.getName().toString());
        field.setDefType(createdMdDefType);
        this.normalizeId((Element)field, f.getId());
        if (n != null) {
            for (Attribute a : n.getAttribute()) {
                Attribute _a = MdFactory.eINSTANCE.createAttribute();
                _a.setValue(a.getValue());
                _a.getValues().addAll((Collection)a.getValues());
                _a.setRef(a.getRef());
                _a.getRefs().addAll((Collection)a.getRefs());
                _a.getValueEntry().putAll(_a.getValueEntry());
                _a.setDefType(String.valueOf(createdMdDefType) + "." + a.getTechProperty().getCode());
                this.normalizeId((Element)_a, String.valueOf(field.getId()) + "/" + _a.getDefType());
                field.getAttribute().add((Object)_a);
            }
        }
        store.getNode().add((Object)field);
        return field;
    }

    private MdNode createMdField(MdNode parentMdNode, QueryField f) {
        MdNode field = MdFactoryHelper.createMdNode((String)COLUMN);
        this.normalizeId((Element)field, f.getId());
        parentMdNode.getNode().add((Object)field);
        field.setName(f.getName().toString());
        this.createAttribute(field, "name", f.getName().toString());
        if (f.getMdNode() != null) {
            this.createAttribute(field, "size", ((RLogicalField)f.getMapReference()).getPrecision());
            this.createAttribute(field, "digits", ((RLogicalField)f.getMapReference()).getSize());
            this.createAttribute(field, "type", ((RLogicalField)f.getMapReference()).getType());
        }
        this.createAttribute(field, "nullable", "false");
        this.createAttribute(field, "autoIncrement", "false");
        this.createAttribute(field, "autoGenerated", "false");
        return field;
    }

    private HashMap<IMetaData, MdNode> _generateMdFileOldRDBMS(boolean intoWorkspace, Map map, MdNode stagingArea, Collection<IContainer> collection) {
        HashMap<IMetaData, MdNode> res = new HashMap<IMetaData, MdNode>();
        MdRootNode root = MdFactoryHelper.createMdRootNode((String)SCHEMA);
        MdNode subParent = map.getAPI().getMdEvaluator().toSubMdParent((EObject)stagingArea);
        if (subParent != null) {
            stagingArea = subParent;
        }
        ((MdNodeImpl)root).setRef((EObject)stagingArea);
        root.setSubMd(true);
        root.setId(String.valueOf(map.getId()) + "-Stage-" + CacheHelper.extractEltID((EObject)stagingArea));
        root.setSubstituteContainer(stagingArea.eContainer());
        root.setName(CacheHelper.extractEltName((EObject)stagingArea));
        for (IContainer q : collection) {
            MdNode store = MdFactoryHelper.createMdNode((String)DATASTORE);
            root.getNode().add((Object)store);
            this.normalizeId((Element)store, q.getId());
            store.setName(q.getAlias().toString());
            this.createAttribute(store, "name", q.getAlias().toString());
            this.createAttribute(store, "type", "TABLE");
            res.put((IMetaData)((Object)q), store);
            q.getLogicalField().stream().filter(f -> f instanceof QueryField).map(f -> (QueryField)f).forEach(f -> {
                MdNode mdNode2 = res.put((IMetaData)f, this.createMdField(store, (QueryField)f));
            });
        }
        this.saveMd(root, stagingArea, map, intoWorkspace);
        return res;
    }

    private void createAttribute(MdNode n, String code, String value) {
        Attribute _a = MdFactory.eINSTANCE.createAttribute();
        _a.setDefType(String.valueOf(n.getDefType()) + "." + code);
        this.normalizeId((Element)_a, String.valueOf(n.getId()) + "/" + code);
        _a.setValue(value);
        n.getAttribute().add((Object)_a);
    }

    private void normalizeId(Element e, String baseId) {
        try {
            e.setId(UUID.nameUUIDFromBytes(baseId.getBytes("UTF-8")).toString());
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
    }
}

