/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.builder.internal;

import com.indy.map.ILogicalField;
import com.indy.map.ref.RComputedField;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RUsage;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class RefRelationHelper {
    private HashMap<RUsage, UsageInfo> usageMap = new HashMap();
    private HashMap<RSourceItem, Set<RUsage>> sourceMap = new HashMap();

    public Collection<RUsage> getUsage(RSourceItem src) {
        Set<RUsage> s = this.sourceMap.get(src);
        if (s != null) {
            return s;
        }
        s = this.createUsageSource(src);
        this.sourceMap.put(src, s);
        return s;
    }

    private Set<RUsage> createUsageSource(RSourceItem src) {
        HashSet<RUsage> s = new HashSet<RUsage>();
        for (RUsage u : src.getUsage()) {
            if (u instanceof RComputedField) {
                s.addAll(this.getUsage((RComputedField)u));
                continue;
            }
            s.add(u);
        }
        return s;
    }

    public Collection<RSourceItem> getSourceItem(RUsage usage) {
        UsageInfo s = this.usageMap.get(usage);
        if (s != null) {
            return s.getSources();
        }
        s = this.createUsageInfo(usage);
        this.usageMap.put(usage, s);
        return s.getSources();
    }

    private UsageInfo createUsageInfo(RUsage usage) {
        UsageInfo inf = new UsageInfo();
        inf.setInternalExpression(usage.getInternalExpression());
        for (RSourceItem src : usage.getSourceRef()) {
            if (src instanceof RComputedField) {
                inf.sources.addAll(this.getSourceItem((RComputedField)src));
                inf.setInternalExpression(inf.getInternalExpression().replace("${" + ((ILogicalField)((Object)src.getDataModel())).getFullPath() + "}$", this.getInternalExpression((RComputedField)src)));
                continue;
            }
            inf.sources.add(src);
        }
        return inf;
    }

    public String getInternalExpression(RUsage usage) {
        UsageInfo s = this.usageMap.get(usage);
        if (s != null) {
            return s.getInternalExpression();
        }
        s = this.createUsageInfo(usage);
        this.usageMap.put(usage, s);
        return s.getInternalExpression();
    }

    private class UsageInfo {
        private String internalExpression;
        private Set<RSourceItem> sources = new HashSet<RSourceItem>();

        private UsageInfo() {
        }

        public String getInternalExpression() {
            if (this.internalExpression == null) {
                return "";
            }
            return this.internalExpression;
        }

        public void setInternalExpression(String internalExpression) {
            this.internalExpression = internalExpression;
        }

        public Set<RSourceItem> getSources() {
            return this.sources;
        }
    }
}

