/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.compute;

import com.indy.map.DataSet;
import com.indy.map.IContainer;
import com.indy.map.IReferencable;
import com.indy.map.Join;
import com.indy.map.JoinLocation;
import com.indy.map.Map;
import com.indy.map.Template;
import com.indy.map.api.IMapAPI;
import com.indy.map.compute.graph.Edge;
import com.indy.map.compute.graph.GraphBuilderFactory;
import com.indy.map.compute.graph.Vertice;
import com.indy.map.compute.graph.builder.FlowGraphBuilder;
import com.indy.map.ref.RContainer;
import com.indy.map.ref.RLoadSet;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RSourceSet;
import com.indy.map.ref.RTargetSet;
import com.indy.map.ref.RefFactory;
import com.indy.map.util.IMapResource;
import com.indy.map.util.InheritanceHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class Computer {
    public static final Computer INSTANCE = new Computer();
    private volatile boolean computing = false;

    private Computer() {
    }

    private HashMap<IContainer, RLoadSet> computeLoadSet(IMapAPI api, DataSet ds) {
        FlowGraphBuilder.BidiGraph g = (FlowGraphBuilder.BidiGraph)GraphBuilderFactory.INSTANCE.getGraphBuilder(GraphBuilderFactory.GraphType.BIDI, null);
        for (IContainer c : ds.getContainer()) {
            g.createVertice(c);
        }
        for (Join j : api.getJoins(ds)) {
            if (j.eContainer() == null || j.getLocation() != JoinLocation.SRC) continue;
            List l = api.getInvolvedContainers(j);
            for (IContainer c : l) {
                Vertice v1 = g.getVertice(c);
                if (v1 == null) continue;
                for (IContainer c2 : l) {
                    Vertice v2;
                    if (c2 == c || (v2 = g.getVertice(c2)) == null) continue;
                    g.createEdge(v1, v2);
                }
            }
        }
        ArrayList<List<Edge>> paths = new ArrayList<List<Edge>>();
        this.getPaths(new ArrayList<Edge>(g.getEdges()), new ArrayList<Edge>(), paths);
        HashMap<IContainer, RLoadSet> res = new HashMap<IContainer, RLoadSet>();
        for (List l : paths) {
            RLoadSet load = RefFactory.eINSTANCE.createRLoadSet();
            for (Edge e : l) {
                IContainer c = (IContainer)g.getModelObject(e.getStart());
                if (res.get(c) == null) {
                    res.put(c, load);
                }
                if (res.get(c = (IContainer)g.getModelObject(e.getEnd())) != null) continue;
                res.put(c, load);
            }
        }
        for (IContainer c : ds.getContainer()) {
            if (res.get(c) != null) continue;
            res.put(c, RefFactory.eINSTANCE.createRLoadSet());
        }
        return res;
    }

    private void getPaths(List<Edge> availableEdges, List<Edge> path, List<List<Edge>> all) {
        if (!availableEdges.isEmpty()) {
            HashSet<Vertice> points = new HashSet<Vertice>();
            if (path.isEmpty()) {
                Edge current = availableEdges.remove(0);
                path.add(current);
            }
            for (Edge e : path) {
                points.add(e.getEnd());
                points.add(e.getStart());
            }
            Edge candidate = null;
            for (Edge e : availableEdges) {
                if (!points.contains(e.getEnd()) && !points.contains(e.getStart())) continue;
                candidate = e;
                break;
            }
            if (candidate == null) {
                all.add(path);
                this.getPaths(availableEdges, new ArrayList<Edge>(), all);
            } else {
                path.add(candidate);
                availableEdges.remove(candidate);
                this.getPaths(availableEdges, path, all);
            }
        } else {
            all.add(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compute(Map map) {
        if (((IMapResource)map.eResource()).isLoading()) {
            return;
        }
        this.computing = true;
        RMap refMap = (RMap)map.getMapReference();
        IMapAPI api = map.getAPI();
        RMap rMap = refMap;
        synchronized (rMap) {
            this.destroySourceAndTargetSet(refMap);
            List<IContainer> targetContainer = this.getAllTarget(map);
            for (IContainer c : targetContainer) {
                Iterator<Object> sourceSet = RefFactory.eINSTANCE.createRSourceSet();
                for (IContainer src : c.getSrcContainers()) {
                    if (sourceSet.getDataSet().contains((Object)src.getDataset())) continue;
                    Iterator curDs = src.getDataset();
                    for (DataSet ds : InheritanceHelper.getDataSetHierarchy(curDs)) {
                        if (sourceSet.getDataSet().contains((Object)ds)) continue;
                        sourceSet.getDataSet().add((Object)ds);
                    }
                }
                HashSet<DataSet> requiredByOpertaor = new HashSet<DataSet>();
                for (DataSet ds : sourceSet.getDataSet()) {
                    for (DataSet d : ds.getFilteringOperatorRequirement()) {
                        requiredByOpertaor.add(d);
                    }
                }
                for (DataSet d : requiredByOpertaor) {
                    if (sourceSet.getDataSet().contains((Object)d)) continue;
                    sourceSet.getDataSet().add((Object)d);
                }
                for (DataSet ds : requiredByOpertaor) {
                    if (sourceSet.getDataSet().contains((Object)ds)) continue;
                    sourceSet.getDataSet().add((Object)ds);
                }
                RTargetSet ts = RefFactory.eINSTANCE.createRTargetSet();
                ts.getContainer().add((Object)((RContainer)((IReferencable)((Object)c)).getMapReference()));
                sourceSet.setTargetSet(ts);
                ts.setSourceSet((RSourceSet)((Object)sourceSet));
                refMap.getSourceSetRef().add(sourceSet);
                refMap.getTargetSetRef().add((Object)ts);
            }
            HashMap<IContainer, RLoadSet> loadMap = new HashMap<IContainer, RLoadSet>();
            for (DataSet ds : map.getDataSet()) {
                loadMap.putAll(this.computeLoadSet(api, ds));
            }
            for (IContainer c : map.getContainer()) {
                if (loadMap.get(c) != null) continue;
                loadMap.put(c, RefFactory.eINSTANCE.createRLoadSet());
            }
            for (IContainer c : loadMap.keySet()) {
                RLoadSet l = (RLoadSet)loadMap.get(c);
                l.getContainer().add((Object)c);
            }
            ArrayList<RLoadSet> existingLoads = new ArrayList<RLoadSet>((Collection<RLoadSet>)refMap.getLoadSet());
            ArrayList<RLoadSet> toRemove = new ArrayList<RLoadSet>();
            ArrayList<RLoadSet> newLoads = new ArrayList<RLoadSet>(new HashSet(loadMap.values()));
            Iterator it = existingLoads.iterator();
            while (it.hasNext()) {
                RLoadSet curLoad = (RLoadSet)it.next();
                List<RLoadSet> matchingNewLoads = this.findMatchingLoad(curLoad, newLoads);
                if (matchingNewLoads.isEmpty()) {
                    it.remove();
                    toRemove.add(curLoad);
                    continue;
                }
                Iterator i = curLoad.getContainer().iterator();
                while (i.hasNext()) {
                    boolean removed = false;
                    IContainer c = (IContainer)i.next();
                    if (matchingNewLoads.get(0).getContainer().contains((Object)c)) {
                        matchingNewLoads.get(0).getContainer().remove((Object)c);
                    } else {
                        i.remove();
                        removed = true;
                    }
                    if (removed || c.eContainer() == map) continue;
                    i.remove();
                }
                curLoad.getContainer().addAll(matchingNewLoads.get(0).getContainer());
                newLoads.remove(matchingNewLoads.get(0));
                Template currentTemplate = null;
                int i2 = 1;
                while (i2 < matchingNewLoads.size()) {
                    if (currentTemplate == null) {
                        for (Template tpl : map.getTemplate()) {
                            if (api.getLoadSet(tpl) != curLoad) continue;
                            currentTemplate = tpl;
                            break;
                        }
                    }
                    if (currentTemplate != null) {
                        matchingNewLoads.get(i2).addTemplateHint(currentTemplate);
                    }
                    ++i2;
                }
            }
            refMap.getLoadSet().addAll(newLoads);
            it = refMap.getLoadSet().iterator();
            while (it.hasNext()) {
                RLoadSet l = (RLoadSet)it.next();
                if (!l.getContainer().isEmpty()) continue;
                it.remove();
                toRemove.add(l);
            }
            refMap.getLoadSet().removeAll(toRemove);
            refMap.eNotify((Notification)new ENotificationImpl((InternalEObject)refMap, 9000, null, null, (Object)refMap));
            this.computing = false;
        }
    }

    private List<RLoadSet> findMatchingLoad(RLoadSet toFind, List<RLoadSet> candidates) {
        HashSet<RLoadSet> res = new HashSet<RLoadSet>();
        for (RLoadSet l : candidates) {
            boolean match = false;
            for (IContainer c : toFind.getContainer()) {
                if (!l.getContainer().contains((Object)c)) continue;
                match = true;
                break;
            }
            if (!match) continue;
            res.add(l);
        }
        return new ArrayList<RLoadSet>(res);
    }

    private void destroySourceAndTargetSet(RMap refMap) {
        for (RSourceSet rs : refMap.getSourceSetRef()) {
            rs.setTargetSet(null);
            rs.getDataSet().clear();
        }
        refMap.getSourceSetRef().clear();
        for (RTargetSet ts : refMap.getTargetSetRef()) {
            ts.getContainer().clear();
            ts.setSourceSet(null);
        }
        refMap.getTargetSetRef().clear();
    }

    private List<IContainer> getAllTarget(Map map) {
        ArrayList<IContainer> l = new ArrayList<IContainer>();
        for (IContainer c : map.getContainer()) {
            boolean added = false;
            if (c.getSetDescriptor().isEmpty()) continue;
            l.add(c);
        }
        return l;
    }
}

