/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.compute.validator;

import com.indy.map.DataSet;
import com.indy.map.Map;
import com.indy.map.compute.graph.GraphBuilderFactory;
import com.indy.map.compute.validator.AbstractGraphValidator;
import com.indy.map.compute.validator.ILinkValidator;
import com.indy.map.messages.Messages;
import org.eclipse.core.runtime.Assert;

public class DataSetOperatorValidator
extends AbstractGraphValidator
implements ILinkValidator {
    public static DataSetOperatorValidator INSTANCE = new DataSetOperatorValidator();

    public ILinkValidator.ValidationStatus canCreateLink(DataSet filterDataSet, DataSet filteredDataSet) {
        Assert.isTrue((filterDataSet != null ? 1 : 0) != 0);
        Assert.isTrue((filteredDataSet != null ? 1 : 0) != 0);
        if (filterDataSet == filteredDataSet) {
            return ILinkValidator.ValidationStatus.createErrorStatus(Messages.DataSetOperatorValidator_0);
        }
        if (filterDataSet.getContainer().size() > 1) {
            return ILinkValidator.ValidationStatus.createErrorStatus(Messages.DataSetOperatorValidator_1);
        }
        if (!filterDataSet.getParent().isEmpty()) {
            return ILinkValidator.ValidationStatus.createErrorStatus(Messages.DataSetOperatorValidator_2);
        }
        if (filterDataSet.getFilter().size() > 0) {
            return ILinkValidator.ValidationStatus.createErrorStatus(Messages.DataSetOperatorValidator_3);
        }
        for (DataSet ds : filteredDataSet.getFiltering()) {
            if (ds.getFilteredBy().isEmpty()) continue;
            return ILinkValidator.ValidationStatus.createErrorStatus(Messages.DataSetOperatorValidator_4);
        }
        Map mapModel = (Map)filterDataSet.eContainer();
        try {
            if (this.hasPath(filterDataSet, filteredDataSet, mapModel, GraphBuilderFactory.GraphType.DATASET_FILTER)) {
                return ILinkValidator.ValidationStatus.createErrorStatus(Messages.DataSetOperatorValidator_5);
            }
            if (this.hasPath(filterDataSet, filteredDataSet, mapModel, GraphBuilderFactory.GraphType.DATASET_OPERATOR)) {
                return ILinkValidator.ValidationStatus.createErrorStatus(Messages.DataSetOperatorValidator_6);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ILinkValidator.ValidationStatus.createErrorStatus(ex.getMessage());
        }
        return ILinkValidator.ValidationStatus.createOkStatus();
    }
}

