/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.compute.validator;

import com.indy.map.DataSet;
import com.indy.map.Expression;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.Map;
import com.indy.map.compute.graph.Graph;
import com.indy.map.compute.graph.GraphBuilderFactory;
import com.indy.map.compute.graph.Vertice;
import com.indy.map.compute.graph.tools.LoopDetector;
import com.indy.map.compute.validator.ILinkValidator;
import com.indy.map.messages.Messages;
import com.indy.map.ref.RExpression;
import com.indy.map.ref.RLogicalField;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RSourceSet;
import com.indy.map.ref.RTargetSet;
import com.indy.map.util.InheritanceHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;

public class JoinValidator
implements ILinkValidator {
    public static JoinValidator INSTANCE = new JoinValidator();

    private JoinValidator() {
    }

    private Set<RTargetSet> getTargets(Map map, IContainer c, List retainer) {
        HashSet<RTargetSet> l = new HashSet<RTargetSet>();
        retainer.add(c);
        for (RTargetSet ts : ((RMap)map.getMapReference()).getTargetSetRef()) {
            if (!ts.getSourceSet().getDataSet().contains((Object)c.getDataset())) continue;
            l.add(ts);
            for (IContainer _c : ts.getContainerModel()) {
                for (IContainer cc : _c.getDataset().getContainer()) {
                    if (retainer.contains(cc)) continue;
                    l.addAll(this.getTargets(map, cc, retainer));
                }
            }
        }
        return l;
    }

    private boolean checkBaseRule(Map map, IContainer src, IContainer trg) {
        Set<RTargetSet> targets = this.getTargets(map, src, new ArrayList());
        for (RTargetSet t : targets) {
            for (IContainer c : t.getContainerModel()) {
                for (DataSet ds : InheritanceHelper.getDataSetLegacy(c.getDataset())) {
                    if (!ds.getContainer().contains((Object)trg)) continue;
                    return false;
                }
            }
        }
        Set<RTargetSet> l = this.getTargets(map, trg, new ArrayList());
        if (!(targets.size() == l.size() && targets.containsAll(l) || Collections.disjoint(targets, l) || src.getDataset().getParent().contains((Object)trg.getDataset()) || trg.getDataset().getParent().contains((Object)src.getDataset()))) {
            return false;
        }
        if (targets.isEmpty()) {
            for (RTargetSet t : l) {
                for (IContainer c : t.getContainerModel()) {
                    for (DataSet ds : InheritanceHelper.getDataSetLegacy(c.getDataset())) {
                        if (!ds.getContainer().contains((Object)src)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public ILinkValidator.ValidationStatus canCreateLink(EObject source, EObject target) {
        Assert.isTrue((boolean)(source instanceof IContainer));
        Assert.isTrue((boolean)(target instanceof IContainer));
        IContainer cSource = (IContainer)source;
        IContainer cTarget = (IContainer)target;
        if (cSource == cTarget) {
            return ILinkValidator.ValidationStatus.createOkStatus();
        }
        if (!this.checkBaseRule((Map)cSource.eContainer(), cSource, cTarget) || !this.checkBaseRule((Map)cSource.eContainer(), cSource, cTarget)) {
            return ILinkValidator.ValidationStatus.createErrorStatus(Messages.JoinValidator_0);
        }
        if (!cSource.getDataset().getFiltering().isEmpty() || !cTarget.getDataset().getFiltering().isEmpty()) {
            return ILinkValidator.ValidationStatus.createErrorStatus(Messages.JoinValidator_1);
        }
        if (!((Map)cSource.eContainer()).hasJoin(cSource, cTarget) && InheritanceHelper.haveSharedAncestor(cSource.getDataset(), cTarget.getDataset())) {
            return ILinkValidator.ValidationStatus.createErrorStatus(Messages.JoinValidator_2);
        }
        for (IContainer c : cTarget.getDataset().getContainer()) {
            if (!this.isMapped(c, cSource.getDataset()) || c.getDataset().getParent().contains((Object)cSource.getDataset())) continue;
            return ILinkValidator.ValidationStatus.createErrorStatus(Messages.JoinValidator_3);
        }
        for (IContainer c : cSource.getDataset().getContainer()) {
            if (!this.isMapped(c, cTarget.getDataset()) || c.getDataset().getParent().contains((Object)cTarget.getDataset())) continue;
            return ILinkValidator.ValidationStatus.createErrorStatus(Messages.JoinValidator_4);
        }
        if (!this.validateSourceSet(cSource, cTarget)) {
            return ILinkValidator.ValidationStatus.createErrorStatus(Messages.JoinValidator_5);
        }
        if (!this.validateAlimOrder(cSource, cTarget) || !this.validateAlimOrder(cTarget, cSource)) {
            return ILinkValidator.ValidationStatus.createErrorStatus(Messages.JoinValidator_6);
        }
        cTarget.getDataset();
        cSource.getDataset();
        for (DataSet ds : cSource.getDataset().getFilteringOperatorRequirement()) {
            if (!ds.getContainer().contains((Object)cTarget)) continue;
            return ILinkValidator.ValidationStatus.createErrorStatus(Messages.bind((String)Messages.JoinValidator_7, (Object)cTarget.getAlias(), (Object)cSource));
        }
        for (DataSet ds : cTarget.getDataset().getFilteringOperatorRequirement()) {
            if (!ds.getContainer().contains((Object)cSource)) continue;
            return ILinkValidator.ValidationStatus.createErrorStatus(Messages.bind((String)Messages.JoinValidator_10, (Object)cSource.getAlias(), (Object)cTarget));
        }
        if (cSource.getDataset() != cTarget.getDataset() && !Collections.disjoint(cSource.getDataset().getFilteringOperatorRequirement(), cTarget.getDataset().getFilteringOperatorRequirement())) {
            return ILinkValidator.ValidationStatus.createErrorStatus(Messages.bind((String)Messages.JoinValidator_13, (Object)cSource.getAlias(), (Object)cTarget));
        }
        return ILinkValidator.ValidationStatus.createOkStatus();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateAlimOrder(IContainer source, IContainer target) {
        try {
            RSourceSet inputSourceSet = null;
            RTargetSet rset = ((RMap)((Map)target.eContainer()).getMapReference()).getTargetSetRef(target);
            if (rset != null) {
                inputSourceSet = rset.getSourceSet();
            }
            if (inputSourceSet != null) {
                if (inputSourceSet.getDataSet().contains((Object)target.getDataset())) {
                    return false;
                }
                for (DataSet ds : inputSourceSet.getDataSet()) {
                    for (IContainer c : ds.getContainer()) {
                        if (c == source) {
                            return false;
                        }
                        if (this.validateAlimOrder(source, c)) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        catch (StackOverflowError e) {
            return false;
        }
    }

    private boolean hasTargetLoop(IContainer cSource, IContainer cTarget) {
        Graph graph = GraphBuilderFactory.INSTANCE.getGraphBuilder(GraphBuilderFactory.GraphType.TARGETSET_JOIN, cSource.eContainer());
        Vertice v1 = graph.createVertice(cSource);
        Vertice v2 = graph.createVertice(cTarget);
        graph.dump();
        LoopDetector detectore = new LoopDetector(graph);
        return detectore.hasLoop_undirected(v1, v2);
    }

    private boolean validateSourceSet(IContainer cSource, IContainer cTarget) {
        return true;
    }

    private boolean isMapped(IContainer container, DataSet dataSet) {
        List<DataSet> hierarchy = InheritanceHelper.getDataSetLegacy(dataSet);
        for (ILogicalField f : container.getLogicalField()) {
            for (Expression ex : f.getExpression()) {
                for (RSourceItem it : ((RExpression)ex.getMapReference()).getSourceRef()) {
                    if (!(it instanceof RLogicalField) || !hierarchy.contains(((IContainer)it.getDataModel().eContainer()).getDataset())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

