/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.compute.validator;

import com.indy.map.DataSet;
import com.indy.map.IContainer;
import com.indy.map.Join;
import com.indy.map.Map;
import com.indy.map.compute.graph.Graph;
import com.indy.map.compute.graph.GraphBuilderFactory;
import com.indy.map.compute.graph.Vertice;
import com.indy.map.compute.graph.tools.LoopDetector;
import com.indy.map.compute.validator.ILinkValidator;
import com.indy.map.messages.Messages;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RTargetSet;
import com.indy.map.util.InheritanceHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;

public class MappingValidator {
    public static MappingValidator INSTANCE = new MappingValidator();

    private MappingValidator() {
    }

    public ILinkValidator.ValidationStatus canCreateLink(EObject source, EObject target) {
        RTargetSet trgTrgSet;
        Assert.isTrue((boolean)(source instanceof IContainer));
        Assert.isTrue((boolean)(target instanceof IContainer));
        IContainer cSource = (IContainer)source;
        IContainer cTarget = (IContainer)target;
        if (cSource == cTarget) {
            return ILinkValidator.ValidationStatus.createErrorStatus(Messages.MappingValidator_0);
        }
        if (cSource.getDataset() == null || cTarget.getDataset() == null) {
            StringBuffer b = new StringBuffer();
            if (cSource.getDataset() == null) {
                b.append("\n" + Messages.bind((String)Messages.MappingValidator_2, (Object)cSource.getAlias()));
            }
            if (cTarget.getDataset() == null) {
                b.append("\n" + Messages.bind((String)Messages.MappingValidator_4, (Object)cTarget.getAlias()));
            }
            return ILinkValidator.ValidationStatus.createErrorStatus(Messages.bind((String)Messages.MappingValidator_5, (Object[])new Object[]{cTarget.getAlias(), cSource.getAlias(), b.toString()}));
        }
        if (this.isJoined(cSource, cTarget)) {
            return ILinkValidator.ValidationStatus.createErrorStatus(Messages.bind((String)Messages.MappingValidator_8, (Object)cSource.getAlias(), (Object)cTarget.getAlias()));
        }
        if (this.linkedByAncestors(cSource, cTarget)) {
            return ILinkValidator.ValidationStatus.createErrorStatus(Messages.bind((String)Messages.MappingValidator_11, (Object)cTarget.getAlias(), (Object)cSource.getAlias()));
        }
        if (this.mappingLoop(cSource, cTarget)) {
            return ILinkValidator.ValidationStatus.createErrorStatus(Messages.bind((String)Messages.MappingValidator_14, (Object)cTarget.getAlias(), (Object)cSource.getAlias()));
        }
        Map map = (Map)cSource.eContainer();
        RTargetSet srcTrgSet = ((RMap)map.getMapReference()).getTargetSetRef(cSource);
        if (srcTrgSet != null) {
            for (DataSet ds : srcTrgSet.getSourceSet().getDataSet()) {
                if (!ds.getContainer().contains((Object)cTarget)) continue;
                return ILinkValidator.ValidationStatus.createErrorStatus(Messages.bind((String)Messages.MappingValidator_17, (Object)cSource.getAlias(), (Object)cTarget.getAlias()));
            }
        }
        if ((trgTrgSet = ((RMap)map.getMapReference()).getTargetSetRef(cTarget)) != null) {
            for (DataSet incomingDs : trgTrgSet.getSourceSet().getDataSet()) {
                for (IContainer incomindContainer : incomingDs.getContainer()) {
                    RTargetSet ts = ((RMap)map.getMapReference()).getTargetSetRef(incomindContainer);
                    if (ts == null || !ts.getSourceSet().contains(cSource)) continue;
                    return ILinkValidator.ValidationStatus.createErrorStatus(Messages.bind((String)Messages.MappingValidator_20, (Object)incomindContainer.getAlias(), (Object)cSource.getAlias()));
                }
            }
            if (!Collections.disjoint(trgTrgSet.getSourceSet().getRequiredDataSet(), InheritanceHelper.getDataSetHierarchy(((IContainer)source).getDataset()))) {
                return ILinkValidator.ValidationStatus.createErrorStatus(Messages.bind((String)Messages.MappingValidator_23, (Object)((IContainer)source).getAlias()));
            }
        }
        for (DataSet d : ((IContainer)source).getDataset().getFilteringOperatorRequirement()) {
            if (!d.getContainer().contains((Object)target)) continue;
            return ILinkValidator.ValidationStatus.createErrorStatus(Messages.bind((String)Messages.MappingValidator_25, (Object)cSource.getAlias(), (Object)cTarget.getAlias()));
        }
        srcTrgSet = ((RMap)map.getMapReference()).getTargetSetRef(cSource);
        if (srcTrgSet != null && trgTrgSet != null) {
            for (DataSet incomingDs : srcTrgSet.getSourceSet().getDataSet()) {
                if (!trgTrgSet.getSourceSet().getDataSet().contains((Object)incomingDs)) continue;
                return ILinkValidator.ValidationStatus.createErrorStatus(Messages.bind((String)Messages.MappingValidator_28, (Object)cSource.getAlias(), (Object)cTarget.getAlias()));
            }
        }
        for (DataSet ds : ((IContainer)target).getDataset().getFilteringOperatorRequirement()) {
            if (!ds.getContainer().contains((Object)source)) continue;
            return ILinkValidator.ValidationStatus.createErrorStatus(Messages.bind((String)Messages.MappingValidator_31, (Object)cSource.getAlias(), (Object)cTarget.getAlias()));
        }
        return ILinkValidator.ValidationStatus.createOkStatus();
    }

    private boolean mappingLoop(IContainer cSource, IContainer cTarget) {
        Graph graph = GraphBuilderFactory.INSTANCE.getGraphBuilder(GraphBuilderFactory.GraphType.TARGETSET_JOIN, cSource.eContainer());
        Vertice vS = graph.getVertice(cSource);
        Vertice vT = graph.getVertice(cTarget);
        graph.createEdge(vS, vT);
        LoopDetector l = new LoopDetector(graph);
        return vS != null && vT != null && l.hasLoop_Tarjan();
    }

    private boolean isJoined(IContainer cSource, IContainer cTarget) {
        Map map = (Map)cSource.eContainer();
        for (Join j : map.getJoin()) {
            List l = j.getInvolvedContainers();
            if (l.contains(cSource) && l.contains(cTarget)) {
                return true;
            }
            if (l.contains(cSource)) {
                for (IContainer c : l) {
                    if (!InheritanceHelper.getDataSetHierarchy(c.getDataset()).contains(cTarget.getDataset())) continue;
                    return true;
                }
                continue;
            }
            if (!l.contains(cTarget)) continue;
            for (IContainer c : l) {
                if (!InheritanceHelper.getDataSetHierarchy(c.getDataset()).contains(cSource.getDataset())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean linkedByAncestors(IContainer cSource, IContainer cTarget) {
        ArrayList<DataSet> incomingDataSet = new ArrayList<DataSet>();
        for (IContainer _c : cTarget.getDataset().getContainer()) {
            for (IContainer c : _c.getSrcContainers()) {
                if (incomingDataSet.contains(c.getDataset())) continue;
                incomingDataSet.add(c.getDataset());
            }
        }
        List<DataSet> ancestors = InheritanceHelper.getDataSetHierarchy(cSource.getDataset());
        Map map = (Map)cSource.eContainer();
        for (Join j : map.getJoin(cTarget)) {
            for (IContainer c : j.getInvolvedContainers()) {
                if (!ancestors.contains(c.getDataset())) continue;
                return true;
            }
        }
        return false;
    }
}

