/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.custom.commands;

import com.indy.gmf.proc.ActionProcess;
import com.indy.map.DataSet;
import com.indy.map.Datastore;
import com.indy.map.IContainer;
import com.indy.map.IMetaData;
import com.indy.map.Outliner;
import com.indy.map.Query;
import com.indy.map.Template;
import com.indy.map.api.IMetaDataInformationsProvider;
import com.indy.map.compute.graph.builder.FlowGraphBuilder;
import com.indy.map.custom.commands.CriteriaBuilder;
import com.indy.map.custom.commands.TemplateInfo;
import com.indy.map.custom.commands.UpdateInstanceCommand;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;

class CriteriaGenerator {
    private static final String PREFIX_SRC = "src";
    private static final String PREFIX_TRG = "trg";
    private Map<IContainer, CriteriaBuilder> onRefCriteriaBuilder = new HashMap<IContainer, CriteriaBuilder>();
    private Map<IContainer, CriteriaBuilder> onStageCriteriaBuilder = new HashMap<IContainer, CriteriaBuilder>();
    private Map<IContainer, Set<String>> srcProducts = new HashMap<IContainer, Set<String>>();
    private Map<IContainer, Set<String>> srcTechs = new HashMap<IContainer, Set<String>>();
    private Map<IContainer, Boolean> trgWkspCapability = new HashMap<IContainer, Boolean>();
    private Map<IContainer, Boolean> trgHasLoad = new HashMap<IContainer, Boolean>();
    private UpdateInstanceCommand cmd;

    CriteriaGenerator(UpdateInstanceCommand cmd) {
        this.cmd = cmd;
    }

    public Boolean hasWorkspaceCapability(IContainer cTarget) {
        return this.trgWkspCapability.get(cTarget);
    }

    protected boolean hasLoad(FlowGraphBuilder.TargetSet ts, IContainer target) {
        boolean b;
        Boolean v;
        Boolean res = this.trgHasLoad.get(target);
        if (res != null) {
            return res;
        }
        Boolean curVal = this.hasWorkspaceCapability(target);
        if (curVal == null) {
            curVal = false;
        }
        if (!curVal.booleanValue() && target.hasStagingArea() && (v = Boolean.valueOf(this.onStageCriteriaBuilder.get(target).checkCriteriaValue(CriteriaBuilder.Criteria.WORKSPACE_CAPABILITY, "true"))) == Boolean.TRUE) {
            curVal = v;
        }
        if (!(b = curVal.booleanValue()) && target.getTag().contains((Object)new QName("FORCE_LOAD"))) {
            b = true;
        }
        if (b && target.getTag().contains((Object)new QName("NO_LOAD"))) {
            b = false;
        }
        if (b) {
            for (Template i : this.cmd.getMap().getTemplate()) {
                if (!i.getName().startsWith("I")) continue;
                ArrayList<String> tsContainerIds = new ArrayList<String>();
                for (IContainer c : ts.getContainers()) {
                    tsContainerIds.add(c.getId());
                }
                if (!(i.getProcess() instanceof ActionProcess) || !i.getTargetId().isEmpty() && (!i.getTargetId().containsAll(tsContainerIds) || !tsContainerIds.containsAll((Collection<?>)i.getTargetId())) || UpdateInstanceCommand.checkTemplateSupportLoad(i, ts)) continue;
                this.setWorkspaceCapability(target, false);
                return false;
            }
        }
        this.setWorkspaceCapability(target, b);
        this.trgHasLoad.put(target, b);
        return b;
    }

    public void computeCriteria(IContainer cTarget) {
        this.onRefCriteriaBuilder.put(cTarget, new CriteriaBuilder(IMetaDataInformationsProvider.EvaluationLocation.ON_REF).extractBuiltInCriterias(cTarget));
        boolean refHasWkspCapability = this.onRefCriteriaBuilder.get(cTarget).checkCriteriaValue(CriteriaBuilder.Criteria.WORKSPACE_CAPABILITY, Boolean.TRUE.toString());
        this.setWorkspaceCapability(cTarget, refHasWkspCapability);
        if (cTarget.hasStagingArea()) {
            this.onStageCriteriaBuilder.put(cTarget, new CriteriaBuilder(IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING).extractBuiltInCriterias(cTarget));
            boolean stageHasWkspCapability = this.onStageCriteriaBuilder.get(cTarget).checkCriteriaValue(CriteriaBuilder.Criteria.WORKSPACE_CAPABILITY, Boolean.TRUE.toString());
            if (stageHasWkspCapability) {
                this.onRefCriteriaBuilder.get(cTarget).setCriteria(CriteriaBuilder.Criteria.WORKSPACE_CAPABILITY, Boolean.TRUE.toString());
            }
        } else {
            this.onStageCriteriaBuilder.put(cTarget, this.onRefCriteriaBuilder.get(cTarget));
        }
    }

    private void setWorkspaceCapability(IContainer target, boolean b) {
        this.trgWkspCapability.put(target, b);
    }

    public void addSourceProduct(IContainer target, String product) {
        this.srcProducts.putIfAbsent(target, new HashSet());
        this.srcProducts.get(target).add(product);
    }

    public void addSourceTech(IContainer target, String tech) {
        this.srcTechs.putIfAbsent(target, new HashSet());
        this.srcTechs.get(target).add(tech);
    }

    private RTemplate.Type getIntegrationType(IContainer target) {
        if (target instanceof Query) {
            return RTemplate.Type.STAGING;
        }
        if (target instanceof Datastore) {
            return RTemplate.Type.INTEGRATION;
        }
        if (target instanceof Outliner) {
            return RTemplate.Type.SERDE;
        }
        return null;
    }

    public String getIntegrationTemplateCriteria(FlowGraphBuilder.TargetSet ts, IContainer target) {
        List<DataSet> dsInputs;
        String type = this.getIntegrationType(target).getTemplateType();
        CriteriaBuilder trgRefBuilder = this.onRefCriteriaBuilder.get(target);
        CriteriaBuilder srcBuilder = null;
        if (target.hasStagingArea()) {
            srcBuilder = this.onStageCriteriaBuilder.get(target);
        } else if (!this.hasLoad(ts, target) && !(dsInputs = this.cmd.getFlowNavigator().getDataSetInputs(ts)).isEmpty()) {
            IContainer _c = (IContainer)dsInputs.get(0).getContainer().get(0);
            srcBuilder = new CriteriaBuilder(IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
            srcBuilder.extractBuiltInCriterias(_c);
            srcBuilder.setCriteria(CriteriaBuilder.Criteria.NO_LOAD, Boolean.TRUE.toString());
        }
        if (srcBuilder != null) {
            srcBuilder.setCriteria(CriteriaBuilder.Criteria.PRODUCT_LIST, this.srcProducts.getOrDefault(target, Collections.EMPTY_SET).stream().collect(Collectors.joining("|")));
            srcBuilder.setCriteria(CriteriaBuilder.Criteria.TECH_LIST, this.srcTechs.getOrDefault(target, Collections.EMPTY_SET).stream().collect(Collectors.joining("|")));
        }
        String res = String.format("type=%s;%s;%s", type, trgRefBuilder.generate(PREFIX_TRG), srcBuilder == null ? "" : srcBuilder.generate(PREFIX_SRC));
        return res;
    }

    public String getCheckTemplateCriteria(IContainer target) {
        String res = String.format("type=%s;%s", RTemplate.Type.REJECT.getTemplateType(), this.onRefCriteriaBuilder.get(target).generate(PREFIX_TRG));
        return res;
    }

    public String getLoadTemplateCriteria(IContainer target, TemplateInfo instance) {
        boolean srcIsTarget = false;
        RMap refMap = (RMap)this.cmd.getMap().getMapReference();
        CriteriaBuilder srcBuilder = null;
        boolean j = false;
        for (IContainer md : instance.getRef()) {
            if (!srcIsTarget && refMap != null && refMap.getTargetSetRef(md) != null) {
                srcIsTarget = true;
            }
            if (srcBuilder != null) continue;
            srcBuilder = new CriteriaBuilder(IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
            if (!(md instanceof IMetaData) || ((IMetaData)((Object)md)).basicGetRef() == null) continue;
            srcBuilder.extractBuiltInCriterias(md);
        }
        if (srcIsTarget) {
            srcBuilder.setCriteria(CriteriaBuilder.Criteria.IS_TARGET, Boolean.TRUE.toString());
        }
        String trgCriteria = this.onStageCriteriaBuilder.get(target).generate(PREFIX_TRG);
        String res = String.format("type=%s;%s", RTemplate.Type.LOAD.getTemplateType(), trgCriteria);
        if (srcBuilder != null) {
            res = String.format("%s;%s", res, srcBuilder.generate(PREFIX_SRC));
        }
        return res;
    }
}

