/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.custom.commands;

import com.indy.map.Clause;
import com.indy.map.ComputedField;
import com.indy.map.Datastore;
import com.indy.map.Expression;
import com.indy.map.IReferencable;
import com.indy.map.Map;
import com.indy.map.MapModelItem;
import com.indy.map.MapPackage;
import com.indy.map.Template;
import com.indy.map.ref.RItem;
import com.indy.map.util.synchro.IRefItemUpdater;
import com.indy.map.util.synchro.IRefUpdaterProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class RefreshAllRefCommand
extends RecordingCommand {
    private Map map;
    private List<EObject> list;

    public RefreshAllRefCommand(TransactionalEditingDomain domain, Map map) {
        super(domain);
        this.map = map;
    }

    public RefreshAllRefCommand(TransactionalEditingDomain domain, List<EObject> objectToNotify) {
        super(domain);
        this.list = objectToNotify;
    }

    protected void doExecute() {
        IRefItemUpdater<RItem> updater;
        RItem ref;
        ArrayList<EObject> copy = new ArrayList<EObject>();
        ArrayList<Datastore> datastores = new ArrayList<Datastore>();
        if (this.map != null) {
            TreeIterator it = this.map.eAllContents();
            while (it.hasNext()) {
                MapModelItem tf;
                EObject eObject = (EObject)it.next();
                if (eObject instanceof Expression) {
                    tf = (Expression)eObject;
                    if (tf.getExpression() == null || tf.getExpression().isEmpty()) continue;
                    copy.add(tf);
                    continue;
                }
                if (eObject instanceof Clause) {
                    tf = (Clause)eObject;
                    if (tf.getExpression() == null || tf.getExpression().isEmpty()) continue;
                    copy.add(tf);
                    continue;
                }
                if (eObject instanceof Template) {
                    it.prune();
                    continue;
                }
                if (!(eObject instanceof Datastore)) continue;
                datastores.add((Datastore)eObject);
            }
        } else if (this.list != null) {
            copy.addAll(this.list);
        }
        CompoundCommand cc = new CompoundCommand();
        for (Datastore datastore : datastores) {
            ref = (RItem)datastore.getMapReference();
            updater = null;
            if (ref != null) {
                updater = IRefUpdaterProvider.INSTANCE.getUpdater(ref);
            }
            if (updater == null) continue;
            try {
                updater.updateAll(ref);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (EObject eObject : copy) {
            ref = (RItem)((IReferencable)eObject).getMapReference();
            updater = null;
            if (ref != null) {
                updater = IRefUpdaterProvider.INSTANCE.getUpdater(ref);
            }
            if (updater == null) continue;
            if (eObject instanceof Expression) {
                try {
                    updater.update(ref, (EStructuralFeature)MapPackage.eINSTANCE.getExpression_Expression());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (eObject instanceof ComputedField) {
                try {
                    updater.update(ref, (EStructuralFeature)MapPackage.eINSTANCE.getComputedField_Formula());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!(eObject instanceof Clause)) continue;
            try {
                Command c = updater.updateAndDomainCommand(ref, (EStructuralFeature)MapPackage.eINSTANCE.getClause_Expression());
                if (c != null) {
                    cc.append(c);
                }
                updater.update(ref, (EStructuralFeature)MapPackage.eINSTANCE.getClause_Expression());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!cc.isEmpty()) {
            TransactionUtil.getEditingDomain((EObject)this.map).getCommandStack().execute((Command)cc);
        }
    }
}

