/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.custom.commands;

import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.Map;
import com.indy.map.MapPackage;
import com.indy.map.Outliner;
import com.indy.map.custom.commands.FieldUpdaterUtils;
import com.indy.map.impl.custom.CustomMapFactoryImpl;
import com.indy.map.ref.RField;
import com.indy.map.util.IMapResource;
import com.indy.map.util.synchro.impl.listeners.DataSetUpdater;
import com.stambia.md.MdNode;
import com.stambia.md.MdPackage;
import com.stambia.tech.Level;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class UpdateOutlinerFieldsCommand
extends RecordingCommand {
    private Outliner outliner;
    private boolean semanticModelUpdated = false;
    private boolean isDirty = false;
    private Map mapModel;

    public UpdateOutlinerFieldsCommand(TransactionalEditingDomain domain, Outliner outliner) {
        super(domain);
        this.outliner = outliner;
        this.mapModel = (Map)outliner.eContainer();
    }

    protected boolean isUsed(Field field) {
        return FieldUpdaterUtils.isUsed(field);
    }

    protected void doExecute() {
        MdNode mdNodeRef = (MdNode)this.outliner.getOutputFieldsReference();
        if (mdNodeRef == null || mdNodeRef.getLevel() == null) {
            return;
        }
        IMapResource resource = (IMapResource)this.outliner.eResource();
        boolean isSynchronizing = resource.getReferenceSynchronizer().isIniting();
        boolean isUkDefined = false;
        this.outliner.getMapReference();
        HashMap<String, Field> unMappedOrInexistantField = new HashMap<String, Field>();
        for (Field field : this.outliner.getOutputField()) {
            if (!FieldUpdaterUtils.isMapped(field) && !this.isUsed(field)) {
                unMappedOrInexistantField.put(((RField)field.getMapReference()).getFullName(), field);
            } else if (!EcoreUtil.isAncestor((EObject)mdNodeRef, (EObject)field.getRef())) {
                unMappedOrInexistantField.put(((RField)field.getMapReference()).getFullName(), field);
            }
            if (!field.isUpdateKey()) continue;
            isUkDefined = true;
        }
        ArrayList<MdNode> nodes = new ArrayList<MdNode>();
        if (FieldUpdaterUtils.addAsChildren(mdNodeRef)) {
            nodes.add(mdNodeRef);
        }
        FieldUpdaterUtils.Position position = new FieldUpdaterUtils.Position();
        HashMap<EObject, Field> fields = new HashMap<EObject, Field>(this.outliner.getOutputField().size());
        ArrayList<Field> noRefFields = new ArrayList<Field>();
        for (Field f : this.outliner.getOutputField()) {
            if (f.getRef() != null) {
                fields.put(f.getRef(), f);
                continue;
            }
            noRefFields.add(f);
        }
        HashMap<Field, BigInteger> fieldPositions = new HashMap<Field, BigInteger>();
        for (Object tmp : nodes) {
            MdNode c = (MdNode)tmp;
            if (!FieldUpdaterUtils.addAsChildren(c)) continue;
            position.increment();
            this.addField(fieldPositions, c, null, position, fields, noRefFields, unMappedOrInexistantField, isUkDefined, true, nodes.size() == 1);
        }
        List<EObject> toRemove = null;
        Collection<Field> _fields = null;
        toRemove = this.handleDeletionAndProxies(unMappedOrInexistantField.values());
        _fields = fields.values();
        for (Field f : this.outliner.getOutputField()) {
            if (f.getDepth() >= 1 || f.isExpand()) continue;
            f.setExpand(true);
        }
        this.handleSynchronization(isSynchronizing, _fields, toRemove, fieldPositions);
        if (this.isDirty) {
            ((IMapResource)this.outliner.eResource()).setDirtyOnLoad();
        }
    }

    private void addField(HashMap<Field, BigInteger> newFieldPositions, MdNode mdNode2, Field parentField, FieldUpdaterUtils.Position position, HashMap<EObject, Field> fields, List<Field> noRefFields, java.util.Map<String, Field> unMappedOrInexistantField, boolean isUkDefined, boolean isRoot, boolean isUnique) {
        try {
            if (position == null) {
                position = new FieldUpdaterUtils.Position();
            } else {
                position.increment();
            }
            ArrayList<Field> allFields = new ArrayList<Field>(fields.values());
            allFields.addAll(noRefFields);
            if (FieldUpdaterUtils.addAsChildren(mdNode2)) {
                Field _Field;
                Field field = fields.get(mdNode2);
                if (field == null) {
                    for (Field field2 : noRefFields) {
                        _Field = field2;
                        if (_Field.getRef() != mdNode2) continue;
                        field = _Field;
                        break;
                    }
                }
                if (field == null) {
                    for (Field field3 : allFields) {
                        _Field = field3;
                        if (_Field.getParent() != parentField && !FieldUpdaterUtils.compareName(_Field.getParent(), parentField) || (mdNode2.getName() == null || _Field.getName() == null || !mdNode2.getName().toUpperCase().equals(_Field.getName().toUpperCase()) && (!isRoot || !isUnique || _Field.getChildren().isEmpty() || _Field.getParent() != null)) && (mdNode2.getName() != null || mdNode2.getLevel() == null || mdNode2.getLevel().getDisplayName() == null || _Field.getName() == null || !mdNode2.getLevel().getDisplayName().toUpperCase().equals(_Field.getName().toUpperCase()))) continue;
                        if (mdNode2.getLevel() != null && _Field.getRef() instanceof MdNode) {
                            String defType = mdNode2.getLevel().getCode();
                            Level l = ((MdNode)_Field.getRef()).getLevel();
                            if (l != null && !l.getCode().equals(defType)) continue;
                        }
                        field = _Field;
                        field.setRef((EObject)mdNode2);
                        this.semanticModelUpdated = true;
                        this.detectIsDirty(field);
                        break;
                    }
                }
                if (field != null) {
                    position.increment();
                    newFieldPositions.put(field, BigInteger.valueOf(position.value));
                    RField rField = (RField)field.getMapReference();
                    if (rField != null) {
                        unMappedOrInexistantField.remove(rField.getFullName());
                    }
                    this.updateField(field, mdNode2, parentField, isUkDefined);
                } else {
                    position.increment();
                    field = this.updateField(field, mdNode2, parentField, isUkDefined);
                    if (field.getRef() != null) {
                        fields.put(field.getRef(), field);
                    } else {
                        noRefFields.add(field);
                    }
                    newFieldPositions.put(field, BigInteger.valueOf(position.value));
                }
                parentField = field;
            }
            ArrayList<MdNode> nodes = new ArrayList<MdNode>();
            FieldUpdaterUtils.getMappingChildren(mdNode2, nodes);
            for (Field field : nodes) {
                position.increment();
                this.addField(newFieldPositions, (MdNode)field, parentField, position, fields, noRefFields, unMappedOrInexistantField, isUkDefined, false, false);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    private void detectIsDirty(Field field) {
        if (!this.isDirty && field.eResource() != null) {
            boolean isDirty = false;
            if (this.mapModel.getHint() != null && this.mapModel.getHint().getUsedField().contains((Object)field)) {
                isDirty = true;
            } else {
                for (Expression e : field.getExpression()) {
                    if (e.getExpression() == null || e.getExpression().isEmpty()) continue;
                    isDirty = true;
                    break;
                }
            }
            if (isDirty) {
                this.isDirty = true;
            }
        }
    }

    private Field updateField(Field field, MdNode mdNode2, Field parentField, boolean isUkDefined) {
        boolean isNewField = false;
        if (field == null) {
            field = CustomMapFactoryImpl.eINSTANCE.createField();
            isNewField = true;
            String newName = null;
            try {
                newName = mdNode2.evaluateXpathExpressionCached("INTERNAL_MAPPING_OBJECT_NAME", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (newName == null && (newName = mdNode2.getName()) == null) {
                newName = mdNode2.getLevel().getDisplayName();
            }
            field.setName(newName);
            field.setRef((EObject)mdNode2);
            this.semanticModelUpdated = true;
        } else if (field.getRef() != mdNode2) {
            field.setRef((EObject)mdNode2);
            this.semanticModelUpdated = true;
            this.detectIsDirty(field);
        }
        if (field != null && field.getParent() != parentField) {
            field.setParent(parentField);
            this.semanticModelUpdated = true;
            this.detectIsDirty(field);
        }
        if (isNewField || !isUkDefined && !field.eIsSet((EStructuralFeature)MapPackage.eINSTANCE.getField_UpdateKey())) {
            boolean isUpdateKey = false;
            try {
                String str = mdNode2.evaluateXpathExpressionCached("INTERNAL_USE_AS_KEY", null);
                isUpdateKey = str != null && str.equals("true");
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
            if (isUpdateKey != field.isUpdateKey()) {
                field.setUpdateKey(isUpdateKey);
                this.semanticModelUpdated = true;
                this.detectIsDirty(field);
            }
        }
        return field;
    }

    private List<EObject> handleDeletionAndProxies(Collection<Field> fields) {
        MdNode mdNodeRef = (MdNode)this.outliner.getOutputFieldsReference();
        ArrayList<EObject> toRemove = new ArrayList<EObject>();
        for (Field field : fields) {
            boolean shouldResetProxy;
            if (field.isExtraStatic()) continue;
            if (!FieldUpdaterUtils.isMapped(field) && !this.isUsed(field)) {
                if (!FieldUpdaterUtils.mappedDescendant(field)) {
                    toRemove.add(field);
                    continue;
                }
                if (field.isExpand()) continue;
                field.setExpand(true);
                continue;
            }
            MdNode cur = field.getRef() == null || field.getRef().eIsProxy() ? null : (MdNode)field.getRef();
            while (cur != null && cur.eContainer() instanceof MdNode) {
                if (cur.getId().equals(mdNodeRef.getId())) break;
                cur = (MdNode)cur.eContainer();
            }
            boolean bl = shouldResetProxy = field.getRef() != null && (cur == null || cur.eIsProxy() || !cur.getId().equals(mdNodeRef.getId()));
            if (!shouldResetProxy || field.getRef().eIsProxy()) continue;
            URI uri = EcoreUtil.getURI((EObject)field.getRef());
            String fragment = uri.fragment();
            URI newURI = uri.trimFragment().appendFragment(String.valueOf(((MdNode)field.getRef().eContainer()).getId()) + "_MISS?" + fragment.substring(fragment.indexOf("?") + 1));
            EClass ec = MdPackage.eINSTANCE.getMdNode();
            InternalEObject proxy = (InternalEObject)ec.getEPackage().getEFactoryInstance().create(ec);
            proxy.eSetProxyURI(newURI);
            field.setRef((EObject)proxy);
        }
        return toRemove;
    }

    private void handleSynchronization(boolean isSynchronizing, Collection<Field> fields, Collection<EObject> toRemove, HashMap<Field, BigInteger> fieldPositions) {
        if (isSynchronizing) {
            IMapResource resource = (IMapResource)this.outliner.eResource();
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.outliner);
            for (Field f : fields) {
                if (f.eContainer() == null) {
                    this.semanticModelUpdated = true;
                    resource.getReferenceSynchronizer().appendPostponedCommand((Command)new AddCommand((EditingDomain)domain, (EObject)this.outliner, (EStructuralFeature)MapPackage.eINSTANCE.getOutliner_OutputField(), (Object)f));
                    resource.getReferenceSynchronizer().appendPostponedCommand((Command)new FieldUpdaterUtils.SetFieldPositionCommand(f, fieldPositions.get(f)));
                    continue;
                }
                ((RField)f.getMapReference()).setPosition(fieldPositions.get(f));
            }
            for (EObject o : toRemove) {
                if (!(o instanceof Field)) continue;
                if (((Field)o).getParent() != null) {
                    resource.getReferenceSynchronizer().appendPostponedCommand((Command)new SetCommand((EditingDomain)domain, o, (EStructuralFeature)MapPackage.eINSTANCE.getField_Parent(), null));
                }
                resource.getReferenceSynchronizer().appendPostponedCommand((Command)new DataSetUpdater.SecureRemoveCommand(domain, this.outliner, (EStructuralFeature)MapPackage.eINSTANCE.getOutliner_OutputField(), o));
                this.semanticModelUpdated = true;
            }
            if (this.semanticModelUpdated) {
                resource.getReferenceSynchronizer().appendPostponedCommand((Command)new IdentityCommand());
            }
        } else {
            ArrayList<Field> addedFields = new ArrayList<Field>();
            for (Field f : fields) {
                BigInteger pos;
                if (f.eContainer() == null) {
                    this.outliner.getOutputField().add((Object)f);
                    addedFields.add(f);
                }
                if ((pos = fieldPositions.get(f)) == null) continue;
                ((RField)f.getMapReference()).setPosition(pos);
            }
            if (this.mapModel.hasRefMapUpdated()) {
                for (EObject o : toRemove) {
                    if (!(o instanceof Field)) continue;
                    if (((Field)o).getParent() != null) {
                        ((Field)o).getParent().getChildren().remove(o);
                        ((Field)o).setParent(null);
                    }
                    this.outliner.getOutputField().remove((Object)o);
                }
            }
        }
    }
}

