/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.extension;

import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.IMetaData;
import com.indy.map.Map;
import com.indy.map.MapPackage;
import com.indy.map.Template;
import com.indy.map.extension.IExtensionInjector;
import com.indy.map.extension.TemplateInjectionTracker;
import com.semarchy.xdi.designer.core.capabilities.ICapability;
import com.semarchy.xdi.designer.core.capabilities.IMapModelExtension;
import com.semarchy.xdi.designer.core.capabilities.IMapModelExtensionDefinitionProvider;
import com.stambia.md.MdNode;
import com.stambia.tech.Level;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.NotificationFilter;

public abstract class AbstractTemplateInjector
implements IExtensionInjector<Template, Map> {
    private ICapability capability;
    private TemplateInjectionTracker tracker;
    private List<IMapModelExtension> extensions = new ArrayList<IMapModelExtension>();
    private WeakReference<Map> context = new WeakReference<Object>(null);

    public AbstractTemplateInjector(ICapability capability, IMapModelExtensionDefinitionProvider extensionProvider) {
        this.capability = capability;
        this.extensions.addAll(extensionProvider.getExtensionDefinition());
        this.tracker = this.createTracker();
    }

    public ICapability getCapability() {
        return this.capability;
    }

    public TemplateInjectionTracker getTracker() {
        return this.tracker;
    }

    protected boolean validateLevels(IMapModelExtension extension, IMetaData c) {
        Level l;
        EObject ref;
        if (c != null && (ref = c.getRef()) instanceof MdNode && (l = ((MdNode)ref).getLevel()) != null) {
            String[] stringArray = extension.getLvlCodes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.equals(l.getCode())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected boolean validateTarget(EObject targetObject, IMapModelExtension extension) {
        Class targetClass = null;
        switch (extension.getTargetObjectType()) {
            case CONTAINER: {
                targetClass = IContainer.class;
                break;
            }
            case FIELD: {
                targetClass = ILogicalField.class;
            }
        }
        if (targetClass.isInstance(targetObject)) {
            if (targetObject instanceof IMetaData) {
                if (this.validateLevels(extension, (IMetaData)targetObject)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<IExtensionInjector.IInjectionDescription> createInjectionDescription(Template tpl) {
        ArrayList<IExtensionInjector.IInjectionDescription> res = new ArrayList<IExtensionInjector.IInjectionDescription>();
        for (EObject o : this.getModelObjectToModify(tpl, (EObject)this.getContext())) {
            res.addAll(this.createInjectionDescription(tpl, o));
        }
        return res;
    }

    @Override
    public Collection<IExtensionInjector.IInjectionDescription> createWithdrawDescription(Template tpl) {
        ArrayList<IExtensionInjector.IInjectionDescription> res = new ArrayList<IExtensionInjector.IInjectionDescription>();
        for (EObject o : this.getModelObjectToModify(tpl, (EObject)this.getContext())) {
            res.addAll(this.createWithdrawDescription(tpl, o));
        }
        return res;
    }

    protected NotificationFilter createStructuralTrackerFilter() {
        NotificationFilter f = null;
        for (IMapModelExtension ext : this.extensions) {
            NotificationFilter featuresFilter = null;
            switch (ext.getTargetObjectType()) {
                case CONTAINER: {
                    featuresFilter = NotificationFilter.createFeatureFilter((EStructuralFeature)MapPackage.eINSTANCE.getMap_Query()).or(NotificationFilter.createFeatureFilter((EStructuralFeature)MapPackage.eINSTANCE.getMap_Datastore())).or(NotificationFilter.createFeatureFilter((EStructuralFeature)MapPackage.eINSTANCE.getMap_Outliner()));
                    break;
                }
                case FIELD: {
                    featuresFilter = NotificationFilter.createFeatureFilter((EStructuralFeature)MapPackage.eINSTANCE.getDatastore_Field()).or(NotificationFilter.createFeatureFilter((EStructuralFeature)MapPackage.eINSTANCE.getQuery_Field())).or(NotificationFilter.createFeatureFilter((EStructuralFeature)MapPackage.eINSTANCE.getOutliner_Field())).or(NotificationFilter.createFeatureFilter((EStructuralFeature)MapPackage.eINSTANCE.getOutliner_OutputField()));
                }
            }
            if (featuresFilter == null) continue;
            f = f == null ? featuresFilter : f.or(featuresFilter);
        }
        return f;
    }

    protected TemplateInjectionTracker createTracker() {
        LvlNotificationFilter filter = new LvlNotificationFilter();
        NotificationFilter featuresFilter = this.createStructuralTrackerFilter();
        return new TemplateInjectionTracker(this, filter.and(featuresFilter));
    }

    @Override
    public Collection<EObject> getModelObjectToModify(Template trigger, EObject context) {
        IContainer c;
        HashSet<EObject> containers = new HashSet<EObject>();
        for (String s : trigger.getTargetId()) {
            c = ((Map)context).getContainer(s);
            if (c == null) continue;
            containers.add(c);
        }
        if (trigger.getName().startsWith("L")) {
            for (String s : trigger.getSourceId()) {
                c = ((Map)context).getContainer(s);
                if (c == null) continue;
                containers.add(c);
            }
        } else {
            for (Template t : ((Map)context).getTemplate()) {
                if (t == trigger || !t.getName().startsWith("L") || Collections.disjoint(t.getTargetId(), trigger.getTargetId())) continue;
                containers.addAll(this.getModelObjectToModify(t, context));
            }
        }
        return containers;
    }

    public void setContext(Map mapModel) {
        this.context = new WeakReference<Map>(mapModel);
    }

    protected Map getContext() {
        return (Map)this.context.get();
    }

    class LvlNotificationFilter
    extends NotificationFilter.Custom {
        LvlNotificationFilter() {
        }

        public boolean matches(Notification notification) {
            ArrayList<Object> l = new ArrayList<Object>();
            if (notification.getEventType() == 3) {
                l.add(notification.getNewValue());
            } else if (notification.getEventType() == 5) {
                l.addAll((Collection)notification.getNewValue());
            }
            for (Object e : l) {
                Level lvl;
                EObject ref;
                if (!(e instanceof IMetaData) || !((ref = ((IMetaData)e).getRef()) instanceof MdNode) || (lvl = ((MdNode)ref).getLevel()) == null) continue;
                for (IMapModelExtension ext : AbstractTemplateInjector.this.extensions) {
                    if (!AbstractTemplateInjector.this.validateTarget((EObject)e, ext)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

