/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.extension;

import com.indy.gmf.proc.ActionProcess;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.ItemProperty;
import com.indy.map.Map;
import com.indy.map.MapModelItem;
import com.indy.map.Template;
import com.indy.map.custom.commands.PropertyInjectionCommand;
import com.indy.map.extension.AbstractTemplateInjector;
import com.indy.map.extension.CapabilityInjectorFactory;
import com.indy.map.extension.IExtensionInjector;
import com.semarchy.xdi.designer.core.capabilities.ICapability;
import com.semarchy.xdi.designer.core.capabilities.ICapabilityProvider;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class ModelExtensionHelper {
    private Registry registry = new Registry();
    public static final ModelExtensionHelper INSTANCE = new ModelExtensionHelper();

    public Registry getRegistry() {
        return this.registry;
    }

    public Command createRebuildItemPropertiesFromTemplateProcessCommand(Map mapModel) {
        AbstractTemplateInjector injector;
        Collection l;
        HashMap<ItemProperty, MapModelItem> orhpansReplacement = new HashMap<ItemProperty, MapModelItem>();
        HashMap tplTargets = new HashMap();
        for (Template t : mapModel.getTemplate()) {
            IContainer c;
            ArrayList<IContainer> l2 = new ArrayList<IContainer>();
            for (String s : t.getSourceId()) {
                c = mapModel.getContainer(s);
                if (l2.contains(c)) continue;
                l2.add(c);
            }
            for (String s : t.getTargetId()) {
                c = mapModel.getContainer(s);
                if (l2.contains(c)) continue;
                l2.add(c);
            }
            if (!t.getName().startsWith("L")) {
                for (Object tt2 : mapModel.getTemplate()) {
                    if (tt2 == t || !tt2.getName().startsWith("L")) continue;
                    for (String s : tt2.getSourceId()) {
                        IContainer c2 = mapModel.getContainer(s);
                        if (l2.contains(c2)) continue;
                        l2.add(c2);
                    }
                }
            }
            tplTargets.put(t, l2);
        }
        HashMap existingOwner = new HashMap();
        ArrayList<ItemProperty> toDelete = new ArrayList<ItemProperty>();
        for (IContainer c : mapModel.getContainer()) {
            ArrayList<Template> l3 = new ArrayList<Template>();
            for (ItemProperty p : c.getOldProperty()) {
                if (p.getTriggerRef().eContainer() != null) continue;
                toDelete.add(p);
            }
            for (ItemProperty p : c.getProperty()) {
                if (p.getTriggerRef().eContainer() == null || p.getDescriptor() == null) {
                    toDelete.add(p);
                    Template t = mapModel.getTemplate(((Template)p.getTriggerRef()).getName());
                    if (t == null || l3.contains(t)) continue;
                    l3.add(t);
                    continue;
                }
                if (l3.contains(p.getTriggerRef())) continue;
                l3.add((Template)p.getTriggerRef());
            }
            for (ILogicalField f : c.getLogicalField()) {
                for (ItemProperty p : ((MapModelItem)((Object)f)).getOldProperty()) {
                    if (p.getTriggerRef().eContainer() != null) continue;
                    toDelete.add(p);
                }
                for (ItemProperty p : ((MapModelItem)((Object)f)).getProperty()) {
                    if (p.getTriggerRef() == null) {
                        toDelete.add(p);
                        continue;
                    }
                    if (p.getTriggerRef().eContainer() == null || p.getDescriptor() == null) {
                        toDelete.add(p);
                        Template t = mapModel.getTemplate(((Template)p.getTriggerRef()).getName());
                        if (t == null || l3.contains(t)) continue;
                        l3.add(t);
                        continue;
                    }
                    if (l3.contains(p.getTriggerRef())) continue;
                    l3.add((Template)p.getTriggerRef());
                }
            }
            existingOwner.put(c, l3);
        }
        ArrayList<IExtensionInjector.IInjectionDescription> propertyInjectionDescriptions = new ArrayList<IExtensionInjector.IInjectionDescription>();
        for (IContainer c : existingOwner.keySet()) {
            for (Template t : (Collection)existingOwner.get(c)) {
                l = (Collection)tplTargets.get(t);
                if (l != null && l.contains(c) || (injector = this.findPropertyInjector(t)) == null) continue;
                try {
                    injector.setContext(mapModel);
                    propertyInjectionDescriptions.addAll(injector.createWithdrawDescription(t, c));
                }
                finally {
                    injector.setContext(null);
                }
            }
        }
        for (Template t : tplTargets.keySet()) {
            for (IContainer c : (Collection)tplTargets.get(t)) {
                l = (Collection)existingOwner.get(c);
                if (l != null && l.contains(t) || (injector = this.findPropertyInjector(t)) == null) continue;
                try {
                    injector.setContext(mapModel);
                    propertyInjectionDescriptions.addAll(injector.createInjectionDescription(t, c));
                }
                finally {
                    injector.setContext(null);
                }
            }
        }
        for (ItemProperty p : toDelete) {
            if (!(p.getTriggerRef() instanceof Template)) continue;
            orhpansReplacement.put(p, mapModel.getTemplate(((Template)p.getTriggerRef()).getName()));
        }
        if (!propertyInjectionDescriptions.isEmpty() || !orhpansReplacement.isEmpty()) {
            return new PropertyInjectionCommand(TransactionUtil.getEditingDomain((EObject)mapModel), propertyInjectionDescriptions, orhpansReplacement);
        }
        return null;
    }

    private AbstractTemplateInjector findPropertyInjector(Template tpl) {
        ICapability c;
        EObject process = tpl.getProcess();
        if (process instanceof ICapabilityProvider && (c = ((ICapabilityProvider)process).getCapability("template-mapping-extension", "createProperty")) != null) {
            return this.registry.getOrCreatePropertyInjector((ActionProcess)process, TransactionUtil.getEditingDomain((EObject)tpl));
        }
        return null;
    }

    public class Registry {
        private java.util.Map<RegistryKey, AbstractTemplateInjector> propertyInjectors = Collections.synchronizedMap(new HashMap());

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AbstractTemplateInjector getPropertyInjector(ActionProcess process) {
            RegistryKey kk = new RegistryKey(process);
            java.util.Map<RegistryKey, AbstractTemplateInjector> map = this.propertyInjectors;
            synchronized (map) {
                for (RegistryKey k : this.propertyInjectors.keySet()) {
                    if (!k.equals(kk)) continue;
                    return this.propertyInjectors.get(k);
                }
            }
            return null;
        }

        public AbstractTemplateInjector getOrCreatePropertyInjector(ActionProcess process, TransactionalEditingDomain contextEditingDomain) {
            if (!process.eIsProxy()) {
                AbstractTemplateInjector i = this.getPropertyInjector(process);
                if (i == null) {
                    RegistryKey key = new RegistryKey(process);
                    String triggerInfo = "#" + key.eltID + "?fileId=" + key.fileID + "?";
                    i = CapabilityInjectorFactory.createInjector(triggerInfo, key.c);
                    if (i != null) {
                        this.propertyInjectors.put(key, i);
                        i.getTracker().register(contextEditingDomain);
                    }
                }
                return i;
            }
            return this.getPropertyInjector(process);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroyPropertyInjector(EObject oldProc) {
            RegistryKey k = new RegistryKey(oldProc);
            java.util.Map<RegistryKey, AbstractTemplateInjector> map = this.propertyInjectors;
            synchronized (map) {
                for (RegistryKey key : this.propertyInjectors.keySet()) {
                    if (!key.equals(k)) continue;
                    AbstractTemplateInjector i = this.propertyInjectors.remove(key);
                    i.getTracker().unregister();
                    break;
                }
            }
        }
    }

    private class RegistryKey {
        String fileID;
        String eltID;
        ICapability c;

        public RegistryKey(ActionProcess process) {
            this.eltID = CacheHelper.extractEltID((EObject)process);
            this.fileID = CacheHelper.extractFileID((EObject)process);
            this.c = process.getCapability("template-mapping-extension", "createProperty");
        }

        public RegistryKey(EObject process) {
            this.eltID = CacheHelper.extractEltID((EObject)process);
            this.fileID = CacheHelper.extractFileID((EObject)process);
        }

        public boolean equals(Object obj) {
            if (obj instanceof RegistryKey) {
                return this.fileID.equals(((RegistryKey)obj).fileID) && this.eltID.equals(((RegistryKey)obj).eltID);
            }
            return false;
        }
    }
}

