/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.helpers.internal;

import com.indy.map.AdditionalProperty;
import com.indy.map.Clause;
import com.indy.map.IContainer;
import com.indy.map.MapModelItem;
import com.indy.map.helpers.IMapModelPropertyHandler;
import com.indy.map.helpers.internal.AbstractPropertyHandler;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;

public class DiagramPropertyHandler
extends AbstractPropertyHandler
implements IMapModelPropertyHandler {
    public static final String DIAGRAM_NODE_LOCATION = "node.location";
    public static final String DIAGRAM_NODE_SIZE = "node.size";

    @Override
    public Command getCommand(AdditionalProperty prop) {
        if (DIAGRAM_NODE_LOCATION.equals(prop.getName())) {
            return this.createNodeLocationCommand(prop);
        }
        if (DIAGRAM_NODE_SIZE.equals(prop.getName())) {
            return this.createNodeSizeCommand(prop);
        }
        return null;
    }

    private Command createNodeSizeCommand(AdditionalProperty prop) {
        TransactionalEditingDomain editDomain = this.getEditingDomain(prop);
        MapModelItem item = this.getMapModelItem(prop);
        Assert.isTrue((item instanceof IContainer || item instanceof Clause ? 1 : 0) != 0);
        Assert.isNotNull((Object)prop.getValue());
        String pValue = prop.getValue().trim();
        String[] coords = pValue.replace("{", "").replace("}", "").split(";");
        Assert.isTrue((coords.length == 2 ? 1 : 0) != 0);
        URI mapDiagramUri = URIUtils.getDiagramURI((URI)prop.eResource().getURI());
        Resource diagramResource = prop.eResource().getResourceSet().getResource(mapDiagramUri, false);
        Map crossRef = EcoreUtil.CrossReferencer.find(Collections.singleton(diagramResource));
        Node node = null;
        for (EObject o : crossRef.keySet()) {
            if (o != prop.eContainer()) continue;
            for (EStructuralFeature.Setting s : (Collection)crossRef.get(o)) {
                if (s.getEStructuralFeature() != NotationPackage.eINSTANCE.getView_Element() || !(s.getEObject() instanceof Node) || s.getEObject().eResource() != diagramResource) continue;
                node = (Node)s.getEObject();
                break;
            }
            if (node != null) break;
        }
        Integer x = Integer.parseInt(coords[0]);
        Integer y = Integer.parseInt(coords[1]);
        if (node != null) {
            Bounds b;
            if (node.getLayoutConstraint() == null) {
                b = NotationFactory.eINSTANCE.createBounds();
                if (x != null && x != -1) {
                    b.setWidth(x.intValue());
                }
                if (y != null && y != -1) {
                    b.setHeight(y.intValue());
                }
                return new SetCommand((EditingDomain)editDomain, (EObject)b, (EStructuralFeature)NotationPackage.eINSTANCE.getNode_LayoutConstraint(), (Object)b);
            }
            b = (Bounds)node.getLayoutConstraint();
            CompoundCommand cc = new CompoundCommand();
            if (x != null && x != -1) {
                cc.append((Command)new SetCommand((EditingDomain)editDomain, (EObject)b, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width(), (Object)x));
            }
            if (y != null && y != -1) {
                cc.append((Command)new SetCommand((EditingDomain)editDomain, (EObject)b, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height(), (Object)y));
            }
            return cc;
        }
        return null;
    }

    private Command createNodeLocationCommand(AdditionalProperty prop) {
        TransactionalEditingDomain editDomain = this.getEditingDomain(prop);
        MapModelItem item = this.getMapModelItem(prop);
        Assert.isTrue((item instanceof IContainer || item instanceof Clause ? 1 : 0) != 0);
        Assert.isNotNull((Object)prop.getValue());
        String pValue = prop.getValue().trim();
        String[] coords = pValue.replace("{", "").replace("}", "").split(";");
        Assert.isTrue((coords.length == 2 ? 1 : 0) != 0);
        URI mapDiagramUri = URIUtils.getDiagramURI((URI)prop.eResource().getURI());
        Resource diagramResource = prop.eResource().getResourceSet().getResource(mapDiagramUri, false);
        Map crossRef = EcoreUtil.CrossReferencer.find(Collections.singleton(diagramResource));
        Node node = null;
        for (EObject o : crossRef.keySet()) {
            if (o != prop.eContainer()) continue;
            for (EStructuralFeature.Setting s : (Collection)crossRef.get(o)) {
                if (s.getEStructuralFeature() != NotationPackage.eINSTANCE.getView_Element() || !(s.getEObject() instanceof Node) || s.getEObject().eResource() != diagramResource) continue;
                node = (Node)s.getEObject();
                break;
            }
            if (node != null) break;
        }
        Integer x = Integer.parseInt(coords[0]);
        Integer y = Integer.parseInt(coords[1]);
        if (node != null) {
            Bounds b;
            if (node.getLayoutConstraint() == null) {
                b = NotationFactory.eINSTANCE.createBounds();
                b.setX(x.intValue());
                b.setY(y.intValue());
                return new SetCommand((EditingDomain)editDomain, (EObject)b, (EStructuralFeature)NotationPackage.eINSTANCE.getNode_LayoutConstraint(), (Object)b);
            }
            b = (Bounds)node.getLayoutConstraint();
            CompoundCommand cc = new CompoundCommand();
            cc.append((Command)new SetCommand((EditingDomain)editDomain, (EObject)b, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (Object)x));
            cc.append((Command)new SetCommand((EditingDomain)editDomain, (EObject)b, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), (Object)y));
            return cc;
        }
        return null;
    }
}

