/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.impl.custom;

import com.indy.map.AdditionalProperty;
import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.Hint;
import com.indy.map.IContainer;
import com.indy.map.IExpression;
import com.indy.map.ILogicalField;
import com.indy.map.IMapModelItem;
import com.indy.map.ItemProperty;
import com.indy.map.Map;
import com.indy.map.MapModelItem;
import com.indy.map.MapPackage;
import com.indy.map.SetDescriptor;
import com.indy.map.api.IMapAPI;
import com.indy.map.impl.custom.MapModelItemHelper;
import com.indy.map.impl.custom.Messages;
import com.indy.map.ref.RField;
import com.indy.map.util.IMapResource;
import com.indy.map.util.custom.CustomMapResourceImpl;
import com.indy.map.util.synchro.IMapReferencesSynchronizer;
import com.indy.map.util.synchro.updaters.impl.FieldUpdater;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;

public class FieldImpl
extends com.indy.map.impl.FieldImpl {
    private IMapModelItem mapModelItemDelegate = new MapModelItemHelper(this);
    private List<Field> children = new ArrayList<Field>();
    private boolean fullAliasIsSet = false;
    private EContentAdapter cachingAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            Field f;
            super.notifyChanged(notification);
            if (notification.getFeature() == MapPackage.eINSTANCE.getExpression_Expression()) {
                Field f2 = (Field)((Expression)notification.getNotifier()).eContainer();
                if (f2.getParent() != null) {
                    ((FieldImpl)f2.getParent()).updateChildMappedState(f2);
                }
            } else if (notification.getFeature() == MapPackage.eINSTANCE.getField_Expression()) {
                Field f3 = (Field)notification.getNotifier();
                if (f3.getParent() != null) {
                    ((FieldImpl)f3.getParent()).updateChildMappedState(f3);
                }
            } else if (notification.getFeature() == MapPackage.eINSTANCE.getField_Parent() && (f = (Field)notification.getNotifier()).getParent() != null) {
                ((FieldImpl)f.getParent()).updateChildMappedState(f);
            }
        }
    };
    String objectMask;
    static final String INTERNAL_OBJECT_MASK = "INTERNAL_OBJECT_MASK";
    private HashMap<Field, Boolean> cachedMappedChild = new HashMap();
    private Boolean hasChildMapped = null;

    @Override
    public AdditionalProperty getAdditionalProperty(String category, String name) {
        return this.mapModelItemDelegate.getAdditionalProperty(category, name);
    }

    @Override
    public ItemProperty getProperty(String propertyCode, EObject triggerObject) {
        return this.mapModelItemDelegate.getProperty(propertyCode, triggerObject);
    }

    @Override
    public IMapAPI getAPI() {
        return this.mapModelItemDelegate.getAPI();
    }

    @Override
    public List<AdditionalProperty> getAdditionalProperty(String category) {
        return this.mapModelItemDelegate.getAdditionalProperty(category);
    }

    protected FieldImpl() {
        this.eAdapters().add((Object)this.cachingAdapter);
    }

    @Override
    public String getFullAlias() {
        if (this.fullAlias == null) {
            this.fullAlias = FieldUpdater.getFullAlias(this);
        }
        return this.fullAlias;
    }

    @Override
    public void setFullAlias(String newFullAlias) {
        String oldFullAlias = this.fullAlias;
        this.fullAliasIsSet = newFullAlias != null;
        this.fullAlias = newFullAlias;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldFullAlias, (Object)this.fullAlias));
        }
    }

    @Override
    public void setParent(Field newParent) {
        if (newParent == this) {
            throw new RuntimeException(Messages.FieldImpl_0);
        }
        Field oldParent = this.parent;
        this.parent = newParent;
        if (newParent != null) {
            ((FieldImpl)newParent).getChildren().add(this);
        } else if (oldParent != null) {
            ((FieldImpl)oldParent).getChildren().remove(this);
        }
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, (Object)oldParent, (Object)this.parent));
        }
    }

    @Override
    public List<Field> getChildren() {
        return this.children;
    }

    @Override
    public EObject getRef() {
        if (this.ref != null && this.ref.eIsProxy()) {
            InternalEObject oldRef = (InternalEObject)this.ref;
            this.ref = this.eResolveProxy(oldRef);
            if (this.ref != oldRef) {
                if (!this.fullAliasIsSet) {
                    this.fullAlias = null;
                }
                if (this.eNotificationRequired()) {
                    this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 16, (Object)oldRef, (Object)this.ref));
                }
            }
        }
        return this.ref;
    }

    @Override
    public String getName() {
        if (this.name == null && this.basicGetRef() != null) {
            this.name = this.getAPI().getMdEvaluator().evaluateName(this);
        }
        return this.name;
    }

    @Override
    public RField getMapReference() {
        if (this.eResource() == null) {
            return null;
        }
        IMapReferencesSynchronizer synchronizer = ((IMapResource)this.eResource()).getReferenceSynchronizer();
        return synchronizer.getReference(this);
    }

    @Override
    public boolean isParent() {
        return !this.getChildren().isEmpty();
    }

    @Override
    public int getDepth() {
        Field parent = this.getParent();
        if (parent != null) {
            return 1 + parent.getDepth();
        }
        return 0;
    }

    @Override
    public String getFullPath() {
        String shortName;
        String container = null;
        if (this.eContainer instanceof IContainer) {
            container = ((IContainer)this.eContainer).getAlias() + ".";
        }
        if ((shortName = this.getFullAlias()) == null) {
            String string = shortName = this.getMapReference() == null ? null : this.getMapReference().getFullName();
        }
        if (shortName == null) {
            shortName = this.getName();
        }
        return String.valueOf(container) + shortName;
    }

    @Override
    public Expression getExpression(SetDescriptor desc) {
        for (Expression ex : this.getExpression()) {
            if (ex.getSetDescriptorRef() != desc) continue;
            return ex;
        }
        return null;
    }

    @Override
    public String getLabel() {
        return this.getName();
    }

    @Override
    public boolean isMapped() {
        for (Expression ex : this.getExpression()) {
            if (ex.getExpression() == null || ex.getExpression().trim().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public IExpression.MappingMode getMappingMode() {
        Enum cur = null;
        for (Expression ex : this.getExpression()) {
            if (cur != null && cur.ordinal() >= ex.getMappingMode().ordinal()) continue;
            cur = ex.getMappingMode();
        }
        return cur;
    }

    private void updateChildMappedState(Field child) {
        try {
            if (child.isMapped() || ((FieldImpl)child).hasChildMapped == Boolean.TRUE) {
                if (this.hasChildMapped != Boolean.TRUE) {
                    this.cachedMappedChild.put(child, true);
                    this.hasChildMapped = true;
                    Field cur = this;
                    Field f = this.getParent();
                    while (f != null) {
                        ((FieldImpl)f).cachedMappedChild.put(cur, true);
                        ((FieldImpl)f).hasChildMapped = true;
                        cur = f;
                        f = f.getParent();
                    }
                }
            } else {
                Boolean oldValue = this.cachedMappedChild.get(child);
                this.cachedMappedChild.put(child, false);
                if (oldValue != Boolean.FALSE) {
                    this.recomputeHasChildMapped();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void recomputeHasChildMapped() {
        try {
            boolean val = false;
            for (Field f : this.getChildren()) {
                Boolean b = this.cachedMappedChild.get(f);
                if (b != null) {
                    boolean bl = val = b != false || val;
                }
                if (val) break;
            }
            Boolean old = this.hasChildMapped;
            this.hasChildMapped = val;
            if (old != this.hasChildMapped && this.getParent() != null) {
                ((FieldImpl)this.getParent()).cachedMappedChild.put(this, this.hasChildMapped);
                if (!this.hasChildMapped.booleanValue() && ((FieldImpl)this.getParent() == null || ((FieldImpl)this.getParent()).hasChildMapped.booleanValue())) {
                    ((FieldImpl)this.getParent()).recomputeHasChildMapped();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasMappedChild() {
        if (this.hasChildMapped == null) {
            this.refreshChildMapped();
        }
        return this.hasChildMapped;
    }

    private void refreshChildMapped() {
        try {
            Boolean oldValue = this.hasChildMapped;
            this.hasChildMapped = false;
            for (Field f : this.cachedMappedChild.keySet()) {
                if (!Boolean.TRUE.equals(this.cachedMappedChild.get(f))) continue;
                this.hasChildMapped = true;
                break;
            }
            if (this.hasChildMapped != oldValue && this.getParent() != null) {
                ((FieldImpl)this.getParent()).refreshChildMapped();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasParentCollapse() {
        if (this.getParent() == null) {
            return false;
        }
        if (!this.getParent().isExpand()) {
            return true;
        }
        return this.getParent().hasParentCollapse();
    }

    @Override
    public boolean isStageable() {
        return this.getAPI().getMdEvaluator().evaluateStageable(this);
    }

    @Override
    public boolean isToCache() {
        if (this.isMapped()) {
            return this.isEnable();
        }
        return this.hasUsage();
    }

    private boolean hasUsage() {
        if (this.eResource() == null) {
            return false;
        }
        boolean needRefModel = true;
        try {
            String internalVersion = ((Map)this.eContainer().eContainer()).getInternalVersion();
            needRefModel = !"8".equals(internalVersion);
        }
        catch (Exception internalVersion) {
            // empty catch block
        }
        if (needRefModel) {
            ResourceSet rs = this.eResource().getResourceSet();
            if (Boolean.TRUE == rs.getLoadOptions().get("com.indy.gmf.map.LOAD_OPTION_NO_MAP_REF_SYNC")) {
                Resource resource = this.eResource();
                if (resource instanceof CustomMapResourceImpl) {
                    return ((CustomMapResourceImpl)this.eResource()).hasUsage(this);
                }
                throw new RuntimeException(String.format(Messages.FieldImpl_1, resource.getClass(), CustomMapResourceImpl.class.getName()));
            }
            throw new RuntimeException(Messages.FieldImpl_4);
        }
        Hint hint = ((Map)this.eContainer().eContainer()).getHint();
        return hint != null && hint.getUsedField().contains((Object)this);
    }

    @Override
    public boolean elementHasNoId() {
        return false;
    }

    @Override
    public List<ILogicalField> getDescendants() {
        ArrayList<ILogicalField> l = new ArrayList<ILogicalField>();
        for (ILogicalField iLogicalField : this.getChildren()) {
            l.add(iLogicalField);
            l.addAll(iLogicalField.getDescendants());
        }
        return l;
    }

    @Override
    public List<Field> getAncestors() {
        ArrayList<Field> l = new ArrayList<Field>();
        if (this.getParent() != null) {
            l.add(this.getParent());
            l.addAll(this.getParent().getAncestors());
        }
        return l;
    }

    @Override
    public boolean _isFullAliasSet() {
        return this.fullAliasIsSet;
    }

    @Override
    public boolean isExtraStatic() {
        return (this.getFlag() & 2) != 0;
    }

    @Override
    public void setExtraStatic() {
        this.setFlag(this.getFlag() | 2);
    }

    @Override
    public String getMetaTypeName() {
        return MapModelItem.class.getName();
    }
}

