/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.ref;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RExpressionStatus implements Enumerator
{
    VALID(0, "VALID", "VALID"),
    WARNING(1, "WARNING", "WARNING"),
    ERROR(2, "ERROR", "ERROR");

    public static final int VALID_VALUE = 0;
    public static final int WARNING_VALUE = 1;
    public static final int ERROR_VALUE = 2;
    private static final RExpressionStatus[] VALUES_ARRAY;
    public static final List<RExpressionStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RExpressionStatus[]{VALID, WARNING, ERROR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RExpressionStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RExpressionStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RExpressionStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RExpressionStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RExpressionStatus get(int value) {
        switch (value) {
            case 0: {
                return VALID;
            }
            case 1: {
                return WARNING;
            }
            case 2: {
                return ERROR;
            }
        }
        return null;
    }

    private RExpressionStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

