/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.ref.impl;

import com.indy.map.DataSet;
import com.indy.map.IContainer;
import com.indy.map.Operator;
import com.indy.map.ref.RSourceSet;
import com.indy.map.ref.RTargetSet;
import com.indy.map.ref.RefPackage;
import com.indy.map.ref.impl.RItemImpl;
import com.indy.map.util.InheritanceHelper;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;

public class RSourceSetImpl
extends RItemImpl
implements RSourceSet {
    protected EList<DataSet> dataSet;
    protected RTargetSet targetSet;

    protected RSourceSetImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return RefPackage.Literals.RSOURCE_SET;
    }

    @Override
    public EList<DataSet> getDataSet() {
        if (this.dataSet == null) {
            this.dataSet = new EObjectResolvingEList(DataSet.class, (InternalEObject)this, 3);
        }
        return this.dataSet;
    }

    @Override
    public RTargetSet getTargetSet() {
        return this.targetSet;
    }

    public NotificationChain basicSetTargetSet(RTargetSet newTargetSet, NotificationChain msgs) {
        RTargetSet oldTargetSet = this.targetSet;
        this.targetSet = newTargetSet;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldTargetSet, (Object)newTargetSet);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setTargetSet(RTargetSet newTargetSet) {
        if (newTargetSet != this.targetSet) {
            NotificationChain msgs = null;
            if (this.targetSet != null) {
                msgs = ((InternalEObject)this.targetSet).eInverseRemove((InternalEObject)this, 5, RTargetSet.class, msgs);
            }
            if (newTargetSet != null) {
                msgs = ((InternalEObject)newTargetSet).eInverseAdd((InternalEObject)this, 5, RTargetSet.class, msgs);
            }
            if ((msgs = this.basicSetTargetSet(newTargetSet, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)newTargetSet, (Object)newTargetSet));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                if (this.targetSet != null) {
                    msgs = ((InternalEObject)this.targetSet).eInverseRemove((InternalEObject)this, 5, RTargetSet.class, msgs);
                }
                return this.basicSetTargetSet((RTargetSet)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return this.basicSetTargetSet(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getDataSet();
            }
            case 4: {
                return this.getTargetSet();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.getDataSet().clear();
                this.getDataSet().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setTargetSet((RTargetSet)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.getDataSet().clear();
                return;
            }
            case 4: {
                this.setTargetSet(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return this.dataSet != null && !this.dataSet.isEmpty();
            }
            case 4: {
                return this.targetSet != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public boolean contains(IContainer container) {
        for (DataSet ds : this.getDataSet()) {
            if (!ds.getContainer().contains((Object)container)) continue;
            return true;
        }
        return false;
    }

    private Collection<DataSet> getRequiredDataSet(DataSet dataset) {
        HashSet<DataSet> res = new HashSet<DataSet>();
        for (Operator op : dataset.getOperator()) {
            if (!res.add(op.getFilteringDataSet())) continue;
            for (DataSet ds : InheritanceHelper.getDataSetHierarchy(op.getFilteringDataSet())) {
                res.add(ds);
                res.addAll(this.getRequiredDataSet(ds));
            }
        }
        return res;
    }

    @Override
    public Collection<DataSet> getRequiredDataSet() {
        HashSet<DataSet> res = new HashSet<DataSet>();
        for (DataSet ds : this.getDataSet()) {
            res.addAll(ds.getFilteringOperatorRequirement());
        }
        return res;
    }
}

