/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.udf.parser;

import com.indy.map.udf.parser.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Tokenizer {
    private String toParse;
    private StringBuffer buffer;
    private int currentPosition = -1;
    private List<Token> tokens = new ArrayList<Token>();

    public void tokenize(String str) {
        this.buffer = new StringBuffer();
        this.toParse = str;
        this.currentPosition = 0;
        while (this.currentPosition < str.length()) {
            char c = str.charAt(this.currentPosition);
            switch (c) {
                case '-': {
                    if (this.checkLastChar('-')) {
                        this.readUntil("\n");
                        --this.currentPosition;
                        this.buffer = new StringBuffer();
                        break;
                    }
                    if (this.buffer.length() > 0) {
                        this.tokens.add(new Token(this.buffer.toString(), Token.TYPE.TEXT));
                    }
                    this.buffer = new StringBuffer();
                    this.buffer.append(c);
                    break;
                }
                case '*': {
                    if (this.checkLastChar('/')) {
                        this.readUntil("*/");
                        --this.currentPosition;
                        this.buffer = new StringBuffer();
                        break;
                    }
                    if (this.buffer.length() > 0) {
                        this.tokens.add(new Token(this.buffer.toString(), Token.TYPE.TEXT));
                    }
                    this.tokens.add(new Token("*", Token.TYPE.OPERATOR));
                    this.buffer = new StringBuffer();
                    break;
                }
                case '\'': {
                    if (this.checkLastChar('\\')) {
                        this.buffer.append(c);
                        break;
                    }
                    this.buffer.append(c);
                    ++this.currentPosition;
                    this.buffer.append(this.readUntil("'"));
                    this.tokens.add(new Token(this.buffer.toString(), Token.TYPE.STRING));
                    this.buffer = new StringBuffer();
                    --this.currentPosition;
                    break;
                }
                case ',': {
                    if (this.buffer.length() > 0) {
                        this.tokens.add(new Token(this.buffer.toString(), Token.TYPE.TEXT));
                    }
                    this.tokens.add(new Token(",", Token.TYPE.SEPARATOR));
                    this.buffer = new StringBuffer();
                    break;
                }
                case ':': {
                    if (this.checkLastChar(':')) {
                        String pefix = this.buffer.substring(0, this.buffer.length() - 1);
                        this.buffer.append(this.readUntil("(", false));
                        if (this.buffer.charAt(this.buffer.length() - 1) == '(') {
                            String functionName = this.buffer.substring(pefix.length() + 2, this.buffer.length() - 1);
                            this.tokens.add(new Token(String.valueOf(pefix) + "::" + functionName, Token.TYPE.C_FUNCTION));
                            --this.currentPosition;
                            this.tokens.add(new Token("(", Token.TYPE.PARENTHESIS_START));
                            this.buffer = new StringBuffer();
                            break;
                        }
                        --this.currentPosition;
                        this.tokens.add(new Token(this.buffer.toString(), Token.TYPE.TEXT));
                        this.buffer = new StringBuffer();
                        break;
                    }
                    this.buffer.append(c);
                    break;
                }
                case '(': {
                    if (this.buffer.length() > 0) {
                        this.tokens.add(new Token(this.buffer.toString(), Token.TYPE.FUNCTION));
                    }
                    this.tokens.add(new Token("(", Token.TYPE.PARENTHESIS_START));
                    this.buffer = new StringBuffer();
                    break;
                }
                case ')': {
                    if (this.buffer.length() > 0) {
                        this.tokens.add(new Token(this.buffer.toString(), Token.TYPE.TEXT));
                    }
                    this.tokens.add(new Token(")", Token.TYPE.PARENTHESIS_END));
                    this.buffer = new StringBuffer();
                    break;
                }
                case '{': {
                    if (this.checkLastChar('#')) {
                        this.buffer.append(this.readUntil("}#"));
                        this.tokens.add(new Token(this.buffer.toString(), Token.TYPE.IDENTIFIED_COLUMN));
                        --this.currentPosition;
                        this.buffer = new StringBuffer();
                        break;
                    }
                    this.buffer.append(c);
                    break;
                }
                case '%': 
                case '+': 
                case '/': {
                    if (this.buffer.length() > 0) {
                        this.tokens.add(new Token(this.buffer.toString(), Token.TYPE.TEXT));
                    }
                    this.tokens.add(new Token(String.valueOf(c), Token.TYPE.OPERATOR));
                    this.buffer = new StringBuffer();
                    break;
                }
                case '!': {
                    if (this.buffer.length() > 0) {
                        this.tokens.add(new Token(this.buffer.toString(), Token.TYPE.TEXT));
                    }
                    this.buffer = new StringBuffer();
                    this.buffer.append(c);
                    break;
                }
                case '=': {
                    if (this.checkLastChar('!') || this.checkLastChar('<') || this.checkLastChar('>')) {
                        this.buffer.append(c);
                        this.tokens.add(new Token(this.buffer.toString(), Token.TYPE.OPERATOR));
                    } else if (this.buffer.length() > 0) {
                        this.tokens.add(new Token(this.buffer.toString(), Token.TYPE.TEXT));
                    }
                    this.buffer = new StringBuffer();
                    this.buffer.append(c);
                    break;
                }
                case '<': {
                    if (this.checkLastChar('!')) {
                        this.buffer.append(c);
                        this.tokens.add(new Token(this.buffer.toString(), Token.TYPE.OPERATOR));
                        break;
                    }
                    if (this.buffer.length() > 0) {
                        this.tokens.add(new Token(this.buffer.toString(), Token.TYPE.TEXT));
                    }
                    this.buffer = new StringBuffer();
                    this.buffer.append(c);
                    break;
                }
                case '>': {
                    if (this.checkLastChar('<') || this.checkLastChar('!')) {
                        this.buffer.append(c);
                        this.tokens.add(new Token(this.buffer.toString(), Token.TYPE.OPERATOR));
                        this.buffer = new StringBuffer();
                    } else {
                        if (this.buffer.length() > 0) {
                            this.tokens.add(new Token(this.buffer.toString(), Token.TYPE.TEXT));
                        }
                        this.buffer = new StringBuffer();
                        this.buffer.append(c);
                    }
                }
                default: {
                    if (this.checkLastChar('<') || this.checkLastChar('>') || this.checkLastChar('=') || this.checkLastChar('+') || this.checkLastChar('-') || this.checkLastChar('*') || this.checkLastChar('/') || this.checkLastChar('%')) {
                        this.tokens.add(new Token(this.buffer.toString(), Token.TYPE.OPERATOR));
                        this.buffer = new StringBuffer();
                    }
                    if (Character.isWhitespace(c)) {
                        if (this.buffer.length() <= 0) break;
                        this.tokens.add(new Token(this.buffer.toString(), Token.TYPE.TEXT));
                        this.buffer = new StringBuffer();
                        break;
                    }
                    this.buffer.append(c);
                }
            }
            ++this.currentPosition;
        }
        if (this.buffer.length() > 0) {
            this.tokens.add(new Token(this.buffer.toString(), Token.TYPE.TEXT));
            this.buffer = new StringBuffer();
        }
    }

    private String readUntil(String string) {
        return this.readUntil(string, true);
    }

    private String readUntil(String string, boolean allowSpace) {
        StringBuffer buf = new StringBuffer();
        int prev = 0;
        while (this.currentPosition < this.toParse.length()) {
            char c = this.toParse.charAt(this.currentPosition++);
            if (!allowSpace && Character.isWhitespace(c)) {
                return buf.toString();
            }
            buf.append(c);
            if (prev != 92 && buf.toString().endsWith(string)) {
                return buf.toString();
            }
            prev = c;
        }
        return buf.toString();
    }

    private boolean checkLastChar(char value) {
        return this.buffer.length() > 0 && this.buffer.charAt(this.buffer.length() - 1) == value;
    }

    public static void main(String[] args) {
        Tokenizer t = new Tokenizer();
        t.tokenize("(1 )  + concat('t',1) + 1--ddd\n - a(udf::toto(x,3,#{pppp}# + '('),'tutu') -7");
        for (Token k : t.tokens) {
            System.out.println(String.valueOf(k.getVal()) + "  ---> " + (Object)((Object)k.getType()));
        }
    }

    public Collection<? extends Token> getToken() {
        return this.tokens;
    }
}

