/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.udf.parser;

import com.indy.xsl.sqlparser.ExpressionParser;
import java.util.HashMap;

public class UDFParser {
    HashMap<String, Integer> tokens = new HashMap();

    public HashMap<String, Integer> getFunctionParameterCount() {
        return this.tokens;
    }

    public boolean parse(String expression) {
        this.tokens.clear();
        ExpressionParser parser = new ExpressionParser();
        ExpressionParser.ExpressionTree ast = parser.createExpressionTree(expression);
        if (parser.containsUDF()) {
            Visitor v = new Visitor();
            v.accept(ast);
        }
        return true;
    }

    class Visitor {
        Visitor() {
        }

        void accept(ExpressionParser.ExpressionTree t) {
            this.visit(t);
        }

        void visit(ExpressionParser.ExpressionTree t) {
            String fName;
            if (t.getType() == ExpressionParser.Type.Udf && !(fName = t.getToken().getValue()).startsWith("md::") && !fName.startsWith("user::")) {
                int i = 0;
                for (ExpressionParser.ExpressionTree c : t.getChildren()) {
                    if (c.getType() != ExpressionParser.Type.Parameter) continue;
                    ++i;
                }
                UDFParser.this.tokens.put(fName, i);
            }
            for (ExpressionParser.ExpressionTree c : t.getChildren()) {
                this.visit(c);
            }
        }
    }
}

