/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.util.synchro.impl.builders;

import com.indy.map.Map;
import com.indy.map.Template;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RProblem;
import com.indy.map.ref.RTemplate;
import com.indy.map.ref.RefFactory;
import com.indy.map.util.IMapResource;
import com.indy.map.util.synchro.IReferenceBuilder;

public class TemplateReferenceBuilder
implements IReferenceBuilder<RTemplate, Template> {
    @Override
    public RTemplate createReference(Template designObject) {
        RProblem p;
        RTemplate ref = RefFactory.eINSTANCE.createRTemplate();
        ref.setDataModel(designObject);
        boolean incrementErrorCounter = false;
        if (designObject.getProcess() == null) {
            p = RefFactory.eINSTANCE.createRProblem();
            p.setCode(RProblem.ERROR_TEMPLATE_NO_PROCESS);
            ref.getProblem().add((Object)p);
            incrementErrorCounter = true;
        } else if (designObject.getProcess().eIsProxy()) {
            p = RefFactory.eINSTANCE.createRProblem();
            p.setCode(RProblem.ERROR_TEMPLATE_PROXY_PROCESS);
            ref.getProblem().add((Object)p);
            incrementErrorCounter = true;
        }
        Map modelContainer = (Map)designObject.eContainer();
        RMap refContainer = ((IMapResource)modelContainer.eResource()).getReferenceSynchronizer().getReference(modelContainer);
        refContainer.getTemplateRef().add((Object)ref);
        if (incrementErrorCounter) {
            modelContainer.incrementErrorCounter();
        }
        return ref;
    }
}

