/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.util.synchro.impl.listeners;

import com.indy.map.DataSet;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.Join;
import com.indy.map.Map;
import com.indy.map.MapFactory;
import com.indy.map.MapPackage;
import com.indy.map.Operator;
import com.indy.map.compute.validator.DataSetInheritanceValidator;
import com.indy.map.geometry.path.DataSetDivider;
import com.indy.map.geometry.path.DisjointDetector;
import com.indy.map.messages.Messages;
import com.indy.map.ref.RClause;
import com.indy.map.ref.RComputedField;
import com.indy.map.ref.RContainer;
import com.indy.map.ref.RLogicalField;
import com.indy.map.ref.RSourceItem;
import com.indy.map.util.InheritanceHelper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class DataSetUpdater {
    public static final DataSetUpdater INSTANCE = new DataSetUpdater();
    private boolean enabledDataSetMergeOnJoinCreation = true;

    public static EStructuralFeature getIContainer_DataSetFeature(IContainer container) {
        if (container.eClass() == MapPackage.eINSTANCE.getDatastore()) {
            return container.eClass().getEStructuralFeature(17);
        }
        return container.eClass().getEStructuralFeature(12);
    }

    private DataSetUpdater() {
    }

    public void setEnabledDataSetMergeOnJoinCreation(boolean enabled) {
        this.enabledDataSetMergeOnJoinCreation = enabled;
    }

    public Command deletedContainer(IContainer container) {
        CompoundCommand cc = new CompoundCommand();
        if (container.getDataset() != null && container.getDataset().getContainer().size() == 1) {
            TransactionalEditingDomain editDomain = TransactionUtil.getEditingDomain((EObject)container.getDataset());
            EStructuralFeature feature = null;
            feature = container.eClass() == MapPackage.eINSTANCE.getDatastore() ? container.eClass().getEStructuralFeature(17) : container.eClass().getEStructuralFeature(12);
            cc.append((Command)new SetCommand((EditingDomain)editDomain, (EObject)container, feature, null));
            if (container.getDataset() != null && container.getDataset().getContainer().size() == 1) {
                cc.append((Command)new DeleteCommand((EditingDomain)editDomain, Collections.singleton(container.getDataset())));
            }
            return cc;
        }
        return null;
    }

    public Command createdContainer(IContainer container) {
        CompoundCommand cc = new CompoundCommand();
        TransactionalEditingDomain editDomain = TransactionUtil.getEditingDomain((EObject)container);
        CompoundCommand fixJoinsCmd = new CompoundCommand(Messages.DataSetUpdater_0);
        ArrayList<DataSet> dataSetCandidates = new ArrayList<DataSet>();
        DataSet containersDataset = null;
        Map map = (Map)container.eContainer();
        for (Join join : map.getJoin()) {
            if (!join.getInvolvedContainers().contains(container)) continue;
            for (IContainer c : join.getInvolvedContainers()) {
                if (c == container || c.getDataset() == null || dataSetCandidates.contains(c.getDataset())) continue;
                dataSetCandidates.add(c.getDataset());
            }
            if (join.getLeft() == null) {
                fixJoinsCmd.append((Command)new SetCommand((EditingDomain)editDomain, (EObject)join, (EStructuralFeature)MapPackage.eINSTANCE.getJoin_Left(), (Object)container));
            }
            if (join.getRight() != null) continue;
            fixJoinsCmd.append((Command)new SetCommand((EditingDomain)editDomain, (EObject)join, (EStructuralFeature)MapPackage.eINSTANCE.getJoin_Right(), (Object)container));
        }
        if (dataSetCandidates.isEmpty()) {
            containersDataset = MapFactory.eINSTANCE.createDataSet();
            cc.append((Command)new CreateChildCommand((EditingDomain)editDomain, container.eContainer(), (EStructuralFeature)MapPackage.eINSTANCE.getMap_DataSet(), (Object)containersDataset, null));
        } else if (dataSetCandidates.size() == 1) {
            containersDataset = (DataSet)dataSetCandidates.get(0);
        } else {
            containersDataset = (DataSet)dataSetCandidates.get(0);
            int i = 1;
            while (i < dataSetCandidates.size()) {
                cc.append(this.mergeDataSet((DataSet)dataSetCandidates.get(i), containersDataset));
                ++i;
            }
        }
        cc.append((Command)new AddCommand((EditingDomain)editDomain, (EObject)containersDataset, (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Container(), (Object)container));
        cc.append((Command)new SetCommand((EditingDomain)editDomain, (EObject)container, DataSetUpdater.getIContainer_DataSetFeature(container), (Object)containersDataset));
        if (!fixJoinsCmd.isEmpty()) {
            cc.append((Command)fixJoinsCmd);
        }
        return cc;
    }

    public Command removedSourceRef(Join join, RSourceItem oldItem) {
        TransactionalEditingDomain domain;
        List<DataSetDivider.Division> l;
        IContainer container;
        block9: {
            block8: {
                container = (IContainer)oldItem.getDataModel().eContainer();
                if (container == null && oldItem.eContainer() != null) {
                    container = (IContainer)((RContainer)oldItem.eContainer()).getDataModel();
                }
                if (container != join.getLeft() && container != join.getRight() && container.eContainer() != null) break block8;
                return null;
            }
            l = DisjointDetector.INSTANCE.getAllDisjointSets(container);
            domain = TransactionUtil.getEditingDomain((EObject)join);
            if (l.size() > 1) break block9;
            return null;
        }
        try {
            DataSetDivider.Division refDiv = null;
            for (DataSetDivider.Division d : l) {
                if (refDiv != null && refDiv.getWeight() >= d.getWeight()) continue;
                refDiv = d;
            }
            CompoundCommand cc = new CompoundCommand();
            for (DataSetDivider.Division d : l) {
                if (d == refDiv) continue;
                cc.append((Command)new RemoveCommand((EditingDomain)domain, (EObject)container.getDataset(), (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Container(), d.getContainers()));
                DataSet dataset = MapFactory.eINSTANCE.createDataSet();
                cc.append((Command)new AddCommand((EditingDomain)domain, join.eContainer(), (EStructuralFeature)MapPackage.eINSTANCE.getMap_DataSet(), (Object)dataset));
                cc.append((Command)new AddCommand((EditingDomain)domain, (EObject)dataset, (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Container(), d.getContainers()));
                for (IContainer c : d.getContainers()) {
                    cc.append((Command)new SetCommand((EditingDomain)domain, (EObject)c, DataSetUpdater.getIContainer_DataSetFeature(c), (Object)dataset));
                }
            }
            return cc;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return UnexecutableCommand.INSTANCE;
        }
    }

    public Command addedSourceRef(Join dataModel, RSourceItem newValue) {
        if (!this.enabledDataSetMergeOnJoinCreation) {
            return null;
        }
        IContainer container = (IContainer)newValue.getDataModel().eContainer();
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)container);
        DataSet currentDataSet = null;
        if (dataModel.getLeft() != null || dataModel.getRight() != null) {
            try {
                currentDataSet = dataModel.getLeft().getDataset();
                if (currentDataSet == null) {
                    currentDataSet = dataModel.getRight().getDataset();
                }
            }
            catch (NullPointerException ex) {
                try {
                    currentDataSet = dataModel.getRight().getDataset();
                }
                catch (NullPointerException e) {
                    return null;
                }
            }
        }
        if (currentDataSet == null) {
            return null;
        }
        if (dataModel.getLeft() != null && dataModel.getLeft().getDataset() != null && dataModel.getLeft() != container && InheritanceHelper.haveSharedAncestor(dataModel.getLeft().getDataset(), container.getDataset())) {
            return null;
        }
        if (dataModel.getRight() != null && dataModel.getRight().getDataset() != null && dataModel.getRight() != container && InheritanceHelper.haveSharedAncestor(dataModel.getRight().getDataset(), container.getDataset())) {
            return null;
        }
        if (container.getDataset() != null && container.getDataset() != currentDataSet) {
            CompoundCommand cc = new CompoundCommand();
            for (IContainer c : container.getDataset().getContainer()) {
                cc.append((Command)new SecureRemoveCommand(domain, container.getDataset(), (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Container(), c));
                cc.append((Command)new AddCommand((EditingDomain)domain, (EObject)currentDataSet, (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Container(), (Object)c));
                cc.append((Command)new SetCommand((EditingDomain)domain, (EObject)c, DataSetUpdater.getIContainer_DataSetFeature(container), (Object)currentDataSet));
            }
            for (DataSet p : container.getDataset().getParent()) {
                cc.append((Command)new SecureRemoveCommand(domain, container.getDataset(), (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Parent(), p));
                cc.append((Command)new AddCommand((EditingDomain)domain, (EObject)currentDataSet, (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Parent(), (Object)p));
            }
            for (DataSet p : container.getDataset().getChild()) {
                cc.append((Command)new SecureRemoveCommand(domain, container.getDataset(), (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Parent(), p));
                cc.append((Command)new AddCommand((EditingDomain)domain, (EObject)currentDataSet, (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Parent(), (Object)p));
            }
            cc.append((Command)new SecureRemoveCommand(domain, container.getDataset().eContainer(), (EStructuralFeature)MapPackage.eINSTANCE.getMap_DataSet(), container.getDataset()));
            if (!cc.isEmpty()) {
                return cc;
            }
        } else if (container.getDataset() != null && container.getDataset() == currentDataSet && newValue instanceof RComputedField) {
            for (RSourceItem src : ((RComputedField)newValue).getRealSourceRef()) {
                IContainer c2;
                if (!(src instanceof RLogicalField) || (c2 = (IContainer)src.getDataModel().eContainer()).getDataset() == currentDataSet) continue;
                if (InheritanceHelper.haveSharedAncestor(c2.getDataset(), currentDataSet)) {
                    return null;
                }
                CompoundCommand cc = new CompoundCommand();
                cc.append((Command)new SecureRemoveCommand(domain, c2.getDataset(), (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Container(), c2));
                cc.append((Command)new AddCommand((EditingDomain)domain, (EObject)currentDataSet, (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Container(), (Object)c2));
                cc.append((Command)new SetCommand((EditingDomain)domain, (EObject)c2, DataSetUpdater.getIContainer_DataSetFeature(container), (Object)currentDataSet));
                for (DataSet p : c2.getDataset().getParent()) {
                    cc.append((Command)new SecureRemoveCommand(domain, c2.getDataset(), (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Parent(), p));
                    cc.append((Command)new AddCommand((EditingDomain)domain, (EObject)currentDataSet, (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Parent(), (Object)p));
                }
                for (DataSet p : c2.getDataset().getChild()) {
                    cc.append((Command)new SecureRemoveCommand(domain, c2.getDataset(), (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Parent(), p));
                    cc.append((Command)new AddCommand((EditingDomain)domain, (EObject)currentDataSet, (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Parent(), (Object)p));
                }
                if (cc.isEmpty()) continue;
                return cc;
            }
        }
        return null;
    }

    public Command addedJoin(Join join) {
        if (!this.enabledDataSetMergeOnJoinCreation) {
            return null;
        }
        if (join.getLeft() == null || join.getRight() == null) {
            return null;
        }
        if (join.getLeft().getDataset() == join.getRight().getDataset()) {
            return null;
        }
        DataSet toDestroy = null;
        DataSet toUpdate = null;
        if (join.getLeft().getDataset() != null && join.getRight().getDataset() != null) {
            if (join.getLeft().getDataset().getContainer().size() > join.getRight().getDataset().getContainer().size()) {
                toDestroy = join.getRight().getDataset();
                toUpdate = join.getLeft().getDataset();
            } else {
                toUpdate = join.getRight().getDataset();
                toDestroy = join.getLeft().getDataset();
            }
        } else {
            return null;
        }
        if (DataSetInheritanceValidator.INSTANCE.canMerge(toDestroy, toDestroy).isError()) {
            return null;
        }
        Command c = this.mergeDataSet(toDestroy, toUpdate);
        ArrayList<DataSet> toMerge = new ArrayList<DataSet>();
        for (RSourceItem i : ((RClause)join.getMapReference()).getRealSourceRef()) {
            DataSet ds;
            if (!(i.getDataModel() instanceof ILogicalField) || (ds = ((IContainer)i.getDataModel().eContainer()).getDataset()) == toDestroy || InheritanceHelper.getDataSetHierarchy(toUpdate).contains(ds) || toMerge.contains(ds)) continue;
            toMerge.add(ds);
        }
        if (toMerge.isEmpty()) {
            return c;
        }
        CompoundCommand cc = new CompoundCommand();
        cc.append(c);
        for (DataSet ds : toMerge) {
            cc.append(this.mergeDataSet(ds, toUpdate));
        }
        return cc;
    }

    protected Command mergeDataSet(DataSet toDestroy, DataSet toUpdate) {
        TransactionalEditingDomain editDomain = TransactionUtil.getEditingDomain((EObject)toUpdate);
        CompoundCommand cc = new CompoundCommand(Messages.DataSetUpdater_1);
        for (IContainer c : toDestroy.getContainer()) {
            cc.append((Command)new RemoveCommand((EditingDomain)editDomain, (EObject)toDestroy, (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Container(), (Object)c));
            cc.append((Command)new AddCommand((EditingDomain)editDomain, (EObject)toUpdate, (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Container(), (Object)c));
            cc.append((Command)new SetCommand((EditingDomain)editDomain, (EObject)c, DataSetUpdater.getIContainer_DataSetFeature(c), (Object)toUpdate));
        }
        cc.append((Command)new RemoveCommand((EditingDomain)editDomain, toDestroy.eContainer(), (EStructuralFeature)MapPackage.eINSTANCE.getMap_DataSet(), (Object)toDestroy));
        for (Operator op : toDestroy.getOperator()) {
            cc.append((Command)new SetCommand((EditingDomain)editDomain, (EObject)op, (EStructuralFeature)MapPackage.eINSTANCE.getOperator_FilteredDataSet(), (Object)toUpdate));
        }
        for (Operator op : toDestroy.getTargetingOperator()) {
            cc.append((Command)new SetCommand((EditingDomain)editDomain, (EObject)op, (EStructuralFeature)MapPackage.eINSTANCE.getOperator_FilteringDataSet(), (Object)toUpdate));
        }
        for (DataSet ds : toDestroy.getFilteredBy()) {
            cc.append((Command)new RemoveCommand((EditingDomain)editDomain, (EObject)toDestroy, (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_FilteredBy(), (Object)ds));
            cc.append((Command)new AddCommand((EditingDomain)editDomain, (EObject)toUpdate, (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_FilteredBy(), (Object)ds));
        }
        for (DataSet ds : toDestroy.getFiltering()) {
            cc.append((Command)new RemoveCommand((EditingDomain)editDomain, (EObject)toDestroy, (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Filtering(), (Object)ds));
            cc.append((Command)new AddCommand((EditingDomain)editDomain, (EObject)toUpdate, (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Filtering(), (Object)ds));
        }
        for (DataSet p : toDestroy.getParent()) {
            if (toUpdate.getParent().contains((Object)p)) continue;
            cc.append((Command)new RemoveCommand((EditingDomain)editDomain, (EObject)toDestroy, (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Parent(), (Object)p));
            cc.append((Command)new AddCommand((EditingDomain)editDomain, (EObject)toUpdate, (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Parent(), (Object)p));
        }
        for (DataSet p : toDestroy.getChild()) {
            if (toUpdate.getChild().contains((Object)p)) continue;
            cc.append((Command)new RemoveCommand((EditingDomain)editDomain, (EObject)toDestroy, (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Child(), (Object)p));
            cc.append((Command)new AddCommand((EditingDomain)editDomain, (EObject)toUpdate, (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Child(), (Object)p));
        }
        return cc;
    }

    public Command createSplitDataSetCommand(DataSet formerDataset, DataSetDivider.Division[] divisions) {
        DataSetDivider.Division toKeep = null;
        DataSetDivider.Division[] divisionArray = divisions;
        int n = divisions.length;
        int n2 = 0;
        while (n2 < n) {
            DataSetDivider.Division d = divisionArray[n2];
            if (toKeep == null) {
                toKeep = d;
            } else if (d.getWeight() > toKeep.getWeight()) {
                toKeep = d;
            }
            ++n2;
        }
        CompoundCommand cc = new CompoundCommand(Messages.DataSetUpdater_2);
        TransactionalEditingDomain editDomain = TransactionUtil.getEditingDomain((EObject)formerDataset);
        ArrayList operatorHandled_filtered = new ArrayList();
        ArrayList operatorHandled_filtering = new ArrayList();
        HashMap<DataSetDivider.Division, DataSet> divisionsDataSet = new HashMap<DataSetDivider.Division, DataSet>();
        DataSetDivider.Division[] divisionArray2 = divisions;
        int n3 = divisions.length;
        int n4 = 0;
        while (n4 < n3) {
            DataSetDivider.Division d = divisionArray2[n4];
            if (d != toKeep) {
                Join j;
                for (IContainer c : d.getContainers()) {
                    cc.append((Command)new SecureRemoveCommand(editDomain, formerDataset, (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Container(), c));
                }
                DataSet newDataset = MapFactory.eINSTANCE.createDataSet();
                divisionsDataSet.put(d, newDataset);
                cc.append((Command)new AddCommand((EditingDomain)editDomain, formerDataset.eContainer(), (EStructuralFeature)MapPackage.eINSTANCE.getMap_DataSet(), (Object)newDataset));
                for (IContainer c : d.getContainers()) {
                    cc.append((Command)new AddCommand((EditingDomain)editDomain, (EObject)newDataset, (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Container(), (Object)c));
                }
                for (IContainer c : d.getContainers()) {
                    cc.append((Command)new SetCommand((EditingDomain)editDomain, (EObject)c, DataSetUpdater.getIContainer_DataSetFeature(c), (Object)newDataset));
                }
                for (DataSet ds : formerDataset.getParent()) {
                    j = formerDataset.getJoin4Parent(ds);
                    if (j == null || !(d.getContainers().contains(j.getLeft()) ^ d.getContainers().contains(j.getRight()))) continue;
                    cc.append((Command)new SecureRemoveCommand(editDomain, formerDataset, (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Parent(), ds));
                    cc.append((Command)new AddCommand((EditingDomain)editDomain, (EObject)newDataset, (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Parent(), (Object)ds));
                }
                for (DataSet ds : formerDataset.getChild()) {
                    j = formerDataset.getJoin4Child(ds);
                    if (j == null || !(d.getContainers().contains(j.getLeft()) ^ d.getContainers().contains(j.getRight()))) continue;
                    cc.append((Command)new SecureRemoveCommand(editDomain, formerDataset, (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Child(), ds));
                    cc.append((Command)new AddCommand((EditingDomain)editDomain, (EObject)newDataset, (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Child(), (Object)ds));
                }
            }
            ++n4;
        }
        return cc;
    }

    public Command deletedJoin(Join join) {
        DataSet rightDataset;
        DataSet formerDataset = null;
        DataSet leftDataset = join.getLeft() == null ? null : join.getLeft().getDataset();
        DataSet dataSet = rightDataset = join.getRight() == null ? null : join.getRight().getDataset();
        if (leftDataset != rightDataset) {
            return null;
        }
        formerDataset = leftDataset;
        if (formerDataset == null) {
            return null;
        }
        DataSetDivider.Division[] divisions = DataSetDivider.INSTANCE.divide(formerDataset, join);
        if (divisions == null) {
            return null;
        }
        return this.createSplitDataSetCommand(formerDataset, divisions);
    }

    public Command updatedJoin(Join notifier) {
        return null;
    }

    public Command emptiedDataSet(DataSet ds) {
        TransactionalEditingDomain editDomain = TransactionUtil.getEditingDomain((EObject)ds);
        if (editDomain != null && ds.getContainer().isEmpty()) {
            CompoundCommand cc = new CompoundCommand(Messages.DataSetUpdater_3);
            for (DataSet parent : ds.getParent()) {
                cc.append((Command)new RemoveCommand((EditingDomain)editDomain, (EObject)parent, (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Child(), Collections.singleton(ds)));
            }
            for (DataSet child : ds.getChild()) {
                cc.append((Command)new RemoveCommand((EditingDomain)editDomain, (EObject)ds, (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_Child(), (Object)child));
            }
            if (ds.eContainer() != null) {
                cc.append((Command)new RemoveCommand((EditingDomain)editDomain, ds.eContainer(), (EStructuralFeature)MapPackage.eINSTANCE.getMap_DataSet(), Collections.singleton(ds)){

                    public void doExecute() {
                        Iterator it = this.collection.iterator();
                        while (it.hasNext()) {
                            Object o = it.next();
                            if (!(o instanceof EObject) || ((EObject)o).eContainer() != null) continue;
                            it.remove();
                        }
                        super.doExecute();
                    }
                });
            }
            return cc;
        }
        return null;
    }

    public Command addedOperator(Operator operator) {
        TransactionalEditingDomain editDomain = TransactionUtil.getEditingDomain((EObject)operator);
        if (operator.getFilteredDataSet() != null && operator.getFilteringDataSet() != null && !operator.getFilteredDataSet().getFilteredBy().contains((Object)operator.getFilteringDataSet())) {
            return new AddCommand((EditingDomain)editDomain, (EObject)operator.getFilteredDataSet(), (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_FilteredBy(), (Object)operator.getFilteringDataSet());
        }
        return null;
    }

    public Command deletedOperator(Map map) {
        TransactionalEditingDomain editDomain = TransactionUtil.getEditingDomain((EObject)map);
        CompoundCommand cc = new CompoundCommand();
        for (DataSet ds : map.getDataSet()) {
            if (ds.getFilteredBy().isEmpty()) continue;
            ArrayList<DataSet> filteringDataSets = new ArrayList<DataSet>();
            for (Operator op : ds.getOperator()) {
                filteringDataSets.add(op.getFilteringDataSet());
            }
            ArrayList<DataSet> currentFilters = new ArrayList<DataSet>((Collection<DataSet>)ds.getFilteredBy());
            currentFilters.removeAll(filteringDataSets);
            if (currentFilters.isEmpty()) continue;
            cc.append((Command)new RemoveCommand((EditingDomain)editDomain, (EObject)ds, (EStructuralFeature)MapPackage.eINSTANCE.getDataSet_FilteredBy(), currentFilters));
        }
        if (!cc.isEmpty()) {
            return cc;
        }
        return null;
    }

    public static class SecureRemoveCommand
    extends RecordingCommand {
        private WeakReference<EObject> containerRef;
        private WeakReference<EObject> toRemoveRef;
        private EStructuralFeature feature;

        public SecureRemoveCommand(TransactionalEditingDomain domain, EObject container, EStructuralFeature feature, EObject toRemove) {
            super(domain);
            this.containerRef = new WeakReference<EObject>(container);
            this.toRemoveRef = new WeakReference<EObject>(toRemove);
            this.feature = feature;
        }

        public void dispose() {
            this.containerRef = null;
            this.toRemoveRef = null;
            this.feature = null;
            super.dispose();
        }

        protected void doExecute() {
            EObject container = (EObject)this.containerRef.get();
            EObject toRemove = (EObject)this.toRemoveRef.get();
            if (container == null) {
                return;
            }
            Object value = container.eGet(this.feature);
            if (value instanceof Collection) {
                ((Collection)value).removeAll(Collections.singleton(toRemove));
            }
        }
    }
}

