/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.util.synchro.updaters.impl;

import com.indy.gmf.proc.ActionProcess;
import com.indy.map.AdditionalProperty;
import com.indy.map.Datastore;
import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.ItemProperty;
import com.indy.map.Map;
import com.indy.map.MapFactory;
import com.indy.map.MapModelItem;
import com.indy.map.MapPackage;
import com.indy.map.Outliner;
import com.indy.map.Parameter;
import com.indy.map.Template;
import com.indy.map.UDFRef;
import com.indy.map.compute.Computer;
import com.indy.map.custom.commands.UpdateDatastoreCommand;
import com.indy.map.custom.commands.UpdateOutlinerFieldsCommand;
import com.indy.map.extension.ModelExtensionHelper;
import com.indy.map.ref.RClause;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RTemplate;
import com.indy.map.ref.RUDFRef;
import com.indy.map.util.IMapResource;
import com.indy.map.util.synchro.IRefItemUpdater;
import com.indy.map.util.synchro.IRefUpdaterProvider;
import com.indy.map.util.synchro.impl.MapReferencesSynchronizerImpl;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class MapUpdater
implements IRefItemUpdater<RMap> {
    @Override
    public void updateAll(RMap refItem) throws Exception {
        Map map = (Map)refItem.getDataModel();
        map.setRefMapUpdated(false);
        IMapResource resource = (IMapResource)map.eResource();
        if (resource != null && resource.isLoaded() && !resource.isLoading() && !resource.getReferenceSynchronizer().isIniting()) {
            Object toCreate;
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)map);
            CompoundCommand cc = new CompoundCommand();
            for (IContainer d : map.getDatastore()) {
                cc.append((Command)new UpdateDatastoreCommand(editingDomain, (Datastore)d){

                    @Override
                    public boolean isUsed(Field srcField) {
                        return true;
                    }
                });
            }
            for (IContainer d : map.getOutliner()) {
                cc.append((Command)new UpdateOutlinerFieldsCommand(editingDomain, (Outliner)d){

                    @Override
                    protected boolean isUsed(Field field) {
                        return true;
                    }
                });
            }
            for (MapModelItem t : map.getTemplate()) {
                toCreate = new ArrayList();
                if (t.getProcess() instanceof ActionProcess && !t.getProcess().eIsProxy()) {
                    for (com.indy.gmf.proc.Parameter p : ((ActionProcess)t.getProcess()).getParameter()) {
                        Parameter mapP;
                        if (!p.isDefaultValueForced() || (mapP = t.getParameter(p.getName())) != null) continue;
                        mapP = MapFactory.eINSTANCE.createParameter();
                        mapP.setName(p.getName());
                        mapP.setValue(p.getValue());
                        toCreate.add(mapP);
                    }
                }
                if (toCreate.isEmpty()) continue;
                cc.append((Command)new AddCommand((EditingDomain)TransactionUtil.getEditingDomain((EObject)map), (EObject)t, (EStructuralFeature)MapPackage.eINSTANCE.getTemplate_Parameter(), (Collection)toCreate));
            }
            for (MapModelItem t : map.getJoin()) {
                toCreate = (RClause)t.getMapReference();
            }
            for (MapModelItem t : map.getFilter()) {
                toCreate = (RClause)t.getMapReference();
            }
            if (resource.autoUpgradeModel()) {
                ((MapReferencesSynchronizerImpl)resource.getReferenceSynchronizer()).disableListeners(editingDomain);
                editingDomain.getCommandStack().execute((Command)cc);
                ((MapReferencesSynchronizerImpl)resource.getReferenceSynchronizer()).enableListeners(editingDomain);
            }
            Computer.INSTANCE.compute(map);
            for (MapModelItem t : new ArrayList<Template>((Collection<Template>)map.getTemplate())) {
                RTemplate ref = (RTemplate)t.getMapReference();
                IRefItemUpdater<RTemplate> updater = IRefUpdaterProvider.INSTANCE.getUpdater(ref);
                if (updater == null) continue;
                updater.updateAll(ref);
            }
            map.setRefMapUpdated(true);
            if (resource.autoUpgradeModel()) {
                cc = new CompoundCommand();
                for (IContainer d : map.getDatastore()) {
                    cc.append((Command)new UpdateDatastoreCommand(editingDomain, (Datastore)d));
                }
                for (IContainer d : map.getOutliner()) {
                    cc.append((Command)new UpdateOutlinerFieldsCommand(editingDomain, (Outliner)d));
                }
                ((MapReferencesSynchronizerImpl)resource.getReferenceSynchronizer()).disableListeners(editingDomain);
                editingDomain.getCommandStack().execute((Command)cc);
                ((MapReferencesSynchronizerImpl)resource.getReferenceSynchronizer()).enableListeners(editingDomain);
            }
            cc = new CompoundCommand();
            for (IContainer c : map.getContainer()) {
                for (ItemProperty p : c.getProperty()) {
                    Command _c = this.checkCreatedProperty((EditingDomain)editingDomain, p);
                    if (_c == null) continue;
                    cc.append(_c);
                }
                for (ILogicalField f : c.getAllLogicalField()) {
                    if (!(f instanceof MapModelItem)) continue;
                    for (ItemProperty p : ((MapModelItem)((Object)f)).getProperty()) {
                        Command _c = this.checkCreatedProperty((EditingDomain)editingDomain, p);
                        if (_c == null) continue;
                        cc.append(_c);
                    }
                }
            }
            Command cmd = ModelExtensionHelper.INSTANCE.createRebuildItemPropertiesFromTemplateProcessCommand(map);
            if (cmd != null) {
                cc.append(cmd);
            }
            ArrayList<UDFRef> toRemove = new ArrayList<UDFRef>();
            for (UDFRef r : map.getUdfRef()) {
                if (!((RUDFRef)r.getMapReference()).getUsage().isEmpty()) continue;
                toRemove.add(r);
            }
            if (!toRemove.isEmpty()) {
                cc.append((Command)new RemoveCommand((EditingDomain)editingDomain, (EObject)map, (EStructuralFeature)MapPackage.eINSTANCE.getMap_UdfRef(), toRemove));
            }
            editingDomain.getCommandStack().execute((Command)cc);
        }
    }

    private Command checkCreatedProperty(EditingDomain domain, ItemProperty p) {
        if (p.getDescriptor() == null) {
            for (AdditionalProperty ap : p.getAdditionalProperty("template-mapping-extension")) {
                if (!ap.getName().equals("createProperty")) continue;
                return new RemoveCommand(domain, p.eContainer(), (EStructuralFeature)MapPackage.eINSTANCE.getMapModelItem_Property(), (Object)p);
            }
        }
        return null;
    }

    @Override
    public void update(RMap refItem, EStructuralFeature feature) throws Exception {
    }

    @Override
    public Command updateAndDomainCommand(RMap refItem, EStructuralFeature feature) {
        return null;
    }
}

