/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.util.synchro.updaters.impl;

import com.indy.map.MapPackage;
import com.indy.map.QueryField;
import com.indy.map.ref.RLogicalField;
import com.indy.map.util.synchro.IRefItemUpdater;
import com.stambia.md.Attribute;
import com.stambia.md.MdNode;
import com.stambia.tech.Level;
import com.stambia.tech.MappingInfo;
import com.stambia.tech.XpathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EStructuralFeature;

public class QueryFieldUpdater
implements IRefItemUpdater<RLogicalField> {
    @Override
    public void updateAll(RLogicalField refItem) {
        this.update(refItem, (EStructuralFeature)MapPackage.eINSTANCE.getQueryField_MdNode());
    }

    @Override
    public void update(RLogicalField refItem, EStructuralFeature feature) {
        if (MapPackage.eINSTANCE.getQueryField_MdNode().equals(feature)) {
            MdNode o;
            MdNode mdNode = o = ((QueryField)refItem.getDataModel()).getMdNode();
            this.updateType(refItem, mdNode);
            this.updatePrecision(refItem, mdNode);
            this.updateSize(refItem, mdNode);
        }
    }

    private void updateType(RLogicalField refItem, MdNode mdNode) {
        String val;
        String newValue = val = mdNode == null ? null : QueryFieldUpdater.evaluateMappingInfo(mdNode, MappingInfo.TYPE);
        String oldValue = refItem.getType();
        if (newValue != null && oldValue != null) {
            if (!newValue.equals(oldValue)) {
                refItem.setType(newValue);
            }
        } else if (oldValue != null) {
            refItem.setType(null);
        } else if (newValue != null) {
            refItem.setType(newValue);
        }
    }

    private void updatePrecision(RLogicalField refItem, MdNode mdNode) {
        String val;
        String newValue = val = mdNode == null ? null : QueryFieldUpdater.evaluateMappingInfo(mdNode, MappingInfo.PRECISION);
        String oldValue = refItem.getPrecision();
        if (newValue != null && oldValue != null) {
            if (!newValue.equals(oldValue)) {
                refItem.setPrecision(newValue);
            }
        } else if (oldValue != null) {
            refItem.setPrecision(null);
        } else if (newValue != null) {
            refItem.setPrecision(newValue);
        }
    }

    private void updateSize(RLogicalField refItem, MdNode mdNode) {
        String val;
        String newValue = val = mdNode == null ? null : QueryFieldUpdater.evaluateMappingInfo(mdNode, MappingInfo.SIZE);
        String oldValue = refItem.getSize();
        if (newValue != null && oldValue != null) {
            if (!newValue.equals(oldValue)) {
                refItem.setSize(newValue);
            }
        } else if (oldValue != null) {
            refItem.setSize(null);
        } else if (newValue != null) {
            refItem.setSize(newValue);
        }
    }

    private static String evaluateMappingInfo(MdNode node, MappingInfo inf) {
        Attribute mandatoryAttr;
        XpathExpression expr;
        Level lvl;
        String xPathExpression = null;
        switch (inf) {
            case MANDATORY: {
                xPathExpression = "INTERNAL_MAPPING_INFO_MANDATORY";
                break;
            }
            case PRECISION: {
                xPathExpression = "INTERNAL_MAPPING_INFO_PRECISION";
                break;
            }
            case SIZE: {
                xPathExpression = "INTERNAL_MAPPING_INFO_SIZE";
                break;
            }
            case TYPE: {
                xPathExpression = "INTERNAL_MAPPING_INFO_TYPE";
            }
        }
        if (xPathExpression != null && (lvl = node.getLevel()) != null && (expr = lvl.findXPathExpression(xPathExpression)) != null) {
            try {
                String res = node.evaluateXpathExpressionCached(xPathExpression, null);
                if (res != null) {
                    return res;
                }
            }
            catch (XPathExpressionException ex) {
                ex.printStackTrace();
            }
        }
        return (mandatoryAttr = node.getAttributeByMapInfo(inf)) == null ? null : mandatoryAttr.getValueOrRefValue();
    }

    @Override
    public Command updateAndDomainCommand(RLogicalField refItem, EStructuralFeature feature) {
        return null;
    }
}

