/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.util.synchro.updaters.impl;

import com.indy.map.Map;
import com.indy.map.Template;
import com.indy.map.custom.commands.TemplateInfo;
import com.indy.map.custom.commands.UpdateInstanceCommand;
import com.indy.map.messages.Messages;
import com.indy.map.ref.RLoadSet;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RProblem;
import com.indy.map.ref.RTemplate;
import com.indy.map.ref.RefPackage;
import com.indy.map.util.IMapResource;
import com.indy.map.util.synchro.IRefItemUpdater;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.osgi.service.log.LogService;

public class TemplateUpdater
implements IRefItemUpdater<RTemplate> {
    @Override
    public void updateAll(RTemplate refItem) throws Exception {
        if (refItem.isHandledS18RC0()) {
            return;
        }
        Template template = (Template)refItem.getDataModel();
        DedicatedUpdateInstanceCommand cmd = new DedicatedUpdateInstanceCommand(template, refItem);
        cmd.doExecute();
    }

    @Override
    public void update(RTemplate refItem, EStructuralFeature feature) throws Exception {
    }

    @Override
    public Command updateAndDomainCommand(RTemplate refItem, EStructuralFeature feature) {
        return null;
    }

    private class DedicatedUpdateInstanceCommand
    extends UpdateInstanceCommand {
        private Template template;
        private RTemplate refItem;

        public DedicatedUpdateInstanceCommand(Template template, RTemplate ref) {
            super(null, (Map)template.eContainer());
            this.template = template;
            this.refItem = ref;
        }

        @Override
        protected void updateInstances() {
            Object p;
            TemplateInfo foundInfo = null;
            String mapModelInternalVersion = ((Map)this.template.eContainer()).getInternalVersion();
            if (mapModelInternalVersion == null) {
                if (((IMapResource)this.template.eResource()).isS17Version()) {
                    foundInfo = this.handleS17();
                } else {
                    boolean comingFromMigrationTool;
                    p = ((Map)this.template.eContainer()).getAdditionalProperty("com.indy.map.helpers.semantic", "migration.tool");
                    boolean bl = comingFromMigrationTool = p != null && p.getValue() != null && !p.getValue().isEmpty();
                    if (!comingFromMigrationTool) {
                        foundInfo = this.handleS18RC0();
                    } else {
                        if (this.template.getName().startsWith("L")) {
                            return;
                        }
                        foundInfo = this.findMappingInfo(this.template);
                        if (foundInfo == null && (foundInfo = this.handleS18RC1()) == null) {
                            foundInfo = this.handleS18RC0();
                        }
                    }
                }
            } else if (mapModelInternalVersion.equals("1")) {
                foundInfo = this.handleS18RC0();
            } else if (mapModelInternalVersion.equals("2")) {
                foundInfo = this.handleS18RC1();
                if (foundInfo == null) {
                    foundInfo = this.handleS18RC0();
                }
            } else {
                foundInfo = this.findMappingInfo(this.template);
                if (foundInfo == null) {
                    foundInfo = this.handleS18RC1();
                }
            }
            if (foundInfo != null) {
                this.refItem.setDescription(foundInfo.getDescription());
                this.refItem.setNodeCode(foundInfo.getNodeCode());
                this.refItem.setTemplateCriteria(foundInfo.getTemplateCriteria());
                this.refItem.setLoad(this.findLoadSet(foundInfo));
                this.refItem.eSetDeliver(false);
                if (!this.refItem.isVisibility() && (p = this.refItem.getProblem(RProblem.ERROR_TEMPLATE_NO_PROCESS)) != null) {
                    this.refItem.getProblem().remove(p);
                }
                this.refItem.getTargetRef().retainAll(foundInfo.getTargetRef());
                this.refItem.getTargetRef().addAll(foundInfo.getTargetRef());
                this.refItem.eSetDeliver(true);
                this.refItem.eNotify((Notification)new ENotificationImpl((InternalEObject)this.refItem, 5, (EStructuralFeature)RefPackage.eINSTANCE.getRTemplate_TargetRef(), null, this.refItem.getTargetRef()));
                foundInfo.refreshSrcTrgAlias(this.template);
            } else if (this.template.getProcess() == null && this.template.getName().matches("L\\d+.*")) {
                this.destroyTemplate();
            } else {
                ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.gmf.map").error(String.valueOf(Messages.TemplateUpdater_2) + this.template.getName() + Messages.TemplateUpdater_3 + this.template.eResource().getURI() + Messages.TemplateUpdater_4);
            }
        }

        private void destroyTemplate() {
            EObject map = this.template.eContainer();
            try {
                boolean deliver = map.eDeliver();
                try {
                    map.eSetDeliver(false);
                    ((Map)map).getTemplate().remove((Object)this.template);
                }
                finally {
                    map.eSetDeliver(deliver);
                }
                int i = 0;
                while (i < this.refItem.getProblem().size()) {
                    try {
                        ((Map)map).decrementErrorCounter();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                ((IMapResource)map.eResource()).getReferenceSynchronizer().unSynchronize(Collections.singletonList(this.template));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private TemplateInfo handleS18RC0() {
            RProblem p;
            TemplateInfo matchingInstance = null;
            if (this.template.getName().charAt(0) != 'L' || this.refItem.isHandledS18RC0()) {
                for (TemplateInfo instance : this.templates) {
                    if (!this.template.getName().equals(instance.getName())) continue;
                    matchingInstance = instance;
                    break;
                }
            }
            if (matchingInstance == null && !this.refItem.isHandledS18RC0()) {
                if (this.template.getName().charAt(0) == 'L') {
                    int i = this.template.getName().indexOf("_");
                    Integer num = null;
                    String subName = null;
                    if (i != -1) {
                        subName = "_" + this.template.getName().substring(i + 1);
                        num = Integer.parseInt(this.template.getName().substring(1, i));
                        if (num > 1) {
                            num = num - 1;
                        }
                    } else {
                        num = Integer.parseInt(this.template.getName().substring(1));
                        subName = "";
                    }
                    for (TemplateInfo instance : this.templates) {
                        if (!instance.getName().equals("L" + num + subName)) continue;
                        matchingInstance = instance;
                        break;
                    }
                } else {
                    if (this.template.getName().charAt(0) != 'R') {
                        throw new RuntimeException(String.valueOf(Messages.TemplateUpdater_9) + this.template.getName());
                    }
                    return null;
                }
                if (matchingInstance != null) {
                    this.refItem.setIsHandledS18RC0();
                }
            }
            if (matchingInstance == null) {
                return null;
            }
            this.template.eSetDeliver(false);
            this.template.setName(matchingInstance.getName());
            this.template.eSetDeliver(true);
            this.refItem.setDescription(matchingInstance.getDescription());
            this.refItem.setNodeCode(matchingInstance.getNodeCode());
            this.refItem.setTemplateCriteria(matchingInstance.getTemplateCriteria());
            this.refItem.setLoad(this.findLoadSet(matchingInstance));
            this.refItem.eSetDeliver(false);
            if (!this.refItem.isVisibility() && (p = this.refItem.getProblem(RProblem.ERROR_TEMPLATE_NO_PROCESS)) != null) {
                this.refItem.getProblem().remove((Object)p);
            }
            this.refItem.getTargetRef().retainAll(matchingInstance.getTargetRef());
            this.refItem.getTargetRef().addAll(matchingInstance.getTargetRef());
            this.refItem.eSetDeliver(true);
            this.refItem.eNotify((Notification)new ENotificationImpl((InternalEObject)this.refItem, 5, (EStructuralFeature)RefPackage.eINSTANCE.getRTemplate_TargetRef(), null, this.refItem.getTargetRef()));
            return matchingInstance;
        }

        protected TemplateInfo handleS18RC1() {
            for (TemplateInfo instance : this.templates) {
                RProblem p;
                if (!instance.getName().equals(this.template.getName())) continue;
                this.refItem.setDescription(instance.getDescription());
                this.refItem.setNodeCode(instance.getNodeCode());
                this.refItem.setTemplateCriteria(instance.getTemplateCriteria());
                this.refItem.eSetDeliver(false);
                this.refItem.setLoad(this.findLoadSet(instance));
                if (!this.refItem.isVisibility() && (p = this.refItem.getProblem(RProblem.ERROR_TEMPLATE_NO_PROCESS)) != null) {
                    this.refItem.getProblem().remove((Object)p);
                }
                this.refItem.getTargetRef().retainAll(instance.getTargetRef());
                this.refItem.getTargetRef().addAll(instance.getTargetRef());
                this.refItem.eSetDeliver(true);
                this.refItem.eNotify((Notification)new ENotificationImpl((InternalEObject)this.refItem, 5, (EStructuralFeature)RefPackage.eINSTANCE.getRTemplate_TargetRef(), null, this.refItem.getTargetRef()));
                return instance;
            }
            return null;
        }

        private RLoadSet findLoadSet(TemplateInfo inf) {
            RLoadSet load = null;
            if (inf.getName().charAt(0) == 'L') {
                for (RLoadSet l : ((RMap)((Map)this.template.eContainer()).getMapReference()).getLoadSet()) {
                    if (!l.getContainer().containsAll(inf.getRef())) continue;
                    load = l;
                    return l;
                }
            }
            return null;
        }

        private TemplateInfo handleS17() {
            for (TemplateInfo instance : this.templates) {
                RProblem p;
                if (!instance.getName().equals(this.template.getName())) continue;
                this.template.eSetDeliver(false);
                this.template.setName(instance.getName());
                this.template.eSetDeliver(true);
                this.refItem.setDescription(instance.getDescription());
                this.refItem.setNodeCode(instance.getNodeCode());
                this.refItem.setTemplateCriteria(instance.getTemplateCriteria());
                this.refItem.eSetDeliver(false);
                this.refItem.setLoad(this.findLoadSet(instance));
                if (!this.refItem.isVisibility() && (p = this.refItem.getProblem(RProblem.ERROR_TEMPLATE_NO_PROCESS)) != null) {
                    this.refItem.getProblem().remove((Object)p);
                }
                this.refItem.getTargetRef().retainAll(instance.getTargetRef());
                this.refItem.getTargetRef().addAll(instance.getTargetRef());
                this.refItem.eSetDeliver(true);
                this.refItem.eNotify((Notification)new ENotificationImpl((InternalEObject)this.refItem, 5, (EStructuralFeature)RefPackage.eINSTANCE.getRTemplate_TargetRef(), null, this.refItem.getTargetRef()));
                return instance;
            }
            return null;
        }

        private TemplateInfo findMappingInfo(Template template) {
            ArrayList<TemplateInfo> candidates = new ArrayList<TemplateInfo>();
            for (TemplateInfo instance : this.templates) {
                if (!instance.getName().equals(template.getName())) continue;
                candidates.add(instance);
            }
            if (candidates.isEmpty()) {
                return null;
            }
            if (candidates.size() > 1) {
                ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.gmf.map").error(Messages.bind((String)Messages.TemplateUpdater_11, (Object)template.getName(), (Object)template.eResource().getURI().toPlatformString(true)));
            }
            return (TemplateInfo)candidates.get(0);
        }

        @Override
        protected void doExecute() {
            if (this.template == null || this.template.eContainer() == null) {
                return;
            }
            super.doExecute();
        }
    }
}

