/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.util.upgrade;

import com.semarchy.xdi.designer.core.models.EMFResourceOptions;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IModelUpgrader;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={IModelUpgrader.class}, property={"type=map"})
public class MappingUpgrader
implements IModelUpgrader {
    private static final HashMap<String, Object> saveOptions = new HashMap();
    private ICacheService cacheService;

    static {
        saveOptions.put("ENCODING", "UTF-8");
        saveOptions.put("SAVE_ONLY_IF_CHANGED", null);
    }

    public void upgradeModels(Collection<URI> mappingModels, Map<Object, Object> upgradeInformations, PrintWriter out, boolean trace) throws Exception {
        TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
        ResourceSet rs = editingDomain.getResourceSet();
        rs.setURIConverter((URIConverter)new InternalResourceURIConverter());
        rs.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        rs.getLoadOptions().put(EMFResourceOptions.LOAD_OPTION_NO_BATCH_VALIDATION, Boolean.TRUE);
        rs.getLoadOptions().put("com.indy.gmf.map.LOAD_OPTION_FAIL_ON_CURRENT_INTERNAL_VERSION", Boolean.TRUE);
        StringBuilder b = new StringBuilder();
        for (URI r : mappingModels) {
            try {
                this.forceSave(r, editingDomain, out, trace);
            }
            catch (Throwable ex) {
                b.append("Failed to upgrade " + r.trimSegments(1) + "because of : " + ex.getMessage() + "\n");
            }
        }
        if (b.length() > 0) {
            throw new Exception("Some mapping could not be upgraded:\n" + b.toString());
        }
    }

    @Reference(policy=ReferencePolicy.DYNAMIC)
    public void bind(ICacheService s) {
        this.cacheService = s;
    }

    public void unbind(ICacheService s) {
        this.cacheService = null;
    }

    /*
     * Exception decompiling
     */
    private void forceSave(URI uri, TransactionalEditingDomain editingDomain, PrintWriter out, boolean trace) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[DOLOOP]], but top level block is 10[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void trace(boolean trace, PrintWriter out, String string) {
        if (trace && out != null) {
            out.println(string);
        }
    }
}

