/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.validation;

import com.indy.map.ComputedField;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.IReferencable;
import com.indy.map.MapModelItem;
import com.indy.map.api.IMetaDataInformationsProvider;
import com.indy.map.compute.graph.Graph;
import com.indy.map.compute.graph.Vertice;
import com.indy.map.compute.graph.tools.LoopDetector;
import com.indy.map.ref.RComputedField;
import com.indy.map.ref.RContainer;
import com.indy.map.ref.RLoadSet;
import com.indy.map.ref.RProblem;
import com.indy.map.ref.RSourceItem;
import com.indy.map.validation.ProblemValidationStatus;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.example.map.custom.command.UpdateFieldRefCommand;

public class ComputedFieldConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        try {
            EObject eObj = ctx.getTarget();
            if (eObj instanceof RComputedField || eObj instanceof ComputedField) {
                String expr;
                String oldParsing;
                boolean supportComputations;
                ComputedField field = eObj instanceof RComputedField ? (ComputedField)((RComputedField)eObj).getDataModel() : (ComputedField)eObj;
                HashSet<ProblemValidationStatus.ProblemEntry> l = new HashSet<ProblemValidationStatus.ProblemEntry>();
                RLoadSet loadSet = ((RContainer)((IReferencable)field.eContainer()).getMapReference()).getLoadSet();
                for (RSourceItem i : ((RComputedField)field.getMapReference()).getRealSourceRef()) {
                    RLoadSet ls;
                    MapModelItem it = i.getDataModel();
                    if (!(it instanceof ILogicalField) || (ls = ((RContainer)((IReferencable)it.eContainer()).getMapReference()).getLoadSet()) == loadSet) continue;
                    l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_MIXED_LOAD_SET, null));
                    break;
                }
                if (this.hasLoop(field)) {
                    l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_COMPUTED_FIELD_RECURSIVE_EXPRESSION, null));
                }
                if (!(supportComputations = field.getAPI().getMdEvaluator().hasWorkspaceCapability((IContainer)field.eContainer(), IMetaDataInformationsProvider.EvaluationLocation.ON_REF))) {
                    l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_COMPUTED_FIELD_NOT_SUPPORTED, null));
                }
                if (field.getFormula() != null && !field.getFormula().trim().isEmpty() && (oldParsing = UpdateFieldRefCommand.markColumns(expr = UpdateFieldRefCommand.parseExpression(field.getFormula()), 0)).trim().isEmpty()) {
                    l.add(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_SQL_PARSER_FAILURE, null));
                }
                return new ProblemValidationStatus((EObject)field.getMapReference(), null, l);
            }
            return ctx.createSuccessStatus();
        }
        catch (Throwable t) {
            return new Status(4, "com.indy.gmf.map", String.valueOf(((Object)((Object)this)).getClass().getName()) + " Validation failed ", t);
        }
    }

    private boolean gatherComputedFields(ComputedField f, Graph g) {
        Vertice v1 = g.createVertice(f);
        for (RSourceItem i : ((RComputedField)f.getMapReference()).getSourceRef()) {
            if (!(i instanceof RComputedField)) continue;
            if (i.getDataModel() == f) {
                return false;
            }
            Vertice v = null;
            v = g.getVertice(i.getDataModel());
            if (v == null) {
                v = g.createVertice(i.getDataModel());
                if (!this.gatherComputedFields((ComputedField)i.getDataModel(), g)) {
                    return false;
                }
            }
            g.createEdge(v1, v);
        }
        RComputedField reff = (RComputedField)f.getMapReference();
        return !reff.getSourceRef().contains((Object)reff);
    }

    private boolean hasLoop(ComputedField field) {
        Graph graph = new Graph();
        if (!this.gatherComputedFields(field, graph)) {
            return true;
        }
        LoopDetector d = new LoopDetector(graph);
        return d.hasLoop_Tarjan();
    }
}

