/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.validation;

import com.indy.gmf.proc.ActionProcess;
import com.indy.map.DataSet;
import com.indy.map.Datastore;
import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.IMetaData;
import com.indy.map.IReferencable;
import com.indy.map.Join;
import com.indy.map.JoinLocation;
import com.indy.map.Map;
import com.indy.map.MapModelItem;
import com.indy.map.MapPackage;
import com.indy.map.Outliner;
import com.indy.map.Template;
import com.indy.map.api.IMetaDataInformationsProvider;
import com.indy.map.compute.graph.Edge;
import com.indy.map.compute.graph.Graph;
import com.indy.map.compute.graph.Vertice;
import com.indy.map.compute.graph.builder.FlowGraphBuilder;
import com.indy.map.custom.commands.UpdateInstanceCommand;
import com.indy.map.messages.Messages;
import com.indy.map.ref.RContainer;
import com.indy.map.ref.RDatastore;
import com.indy.map.ref.RExpression;
import com.indy.map.ref.RLoadSet;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RProblem;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RTemplate;
import com.indy.map.util.SourceSetHelper;
import com.indy.map.validation.ProblemValidationStatus;
import com.stambia.md.MdNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;

public class ContainerConstraint
extends AbstractModelConstraint {
    Logger logger = LogManager.getLogger(ContainerConstraint.class);

    /*
     * WARNING - void declaration
     */
    public IStatus validate(IValidationContext ctx) {
        try {
            EObject eObj = ctx.getTarget();
            if (eObj instanceof IContainer) {
                RLoadSet loadSet;
                Map map;
                RMap refMap;
                boolean isTarget;
                IContainer container = (IContainer)eObj;
                HashSet<ProblemValidationStatus.ProblemEntry> l = new HashSet<ProblemValidationStatus.ProblemEntry>();
                if (container.getDataset() == null) {
                    l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_NO_DATASET, null));
                }
                if (container instanceof IMetaData && ((IMetaData)((Object)container)).getRef() instanceof MdNode) {
                    try {
                        if (((Collection)((MdNode)((IMetaData)((Object)container)).getRef()).evaluateXpathExpressionMdSetCached("INTERNAL_RESERVED_WORDS")).stream().anyMatch(e -> container.getAlias().toString().equalsIgnoreCase(e.toString()))) {
                            l.add(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_ALIAS_MATCHES_RESERVED_WORD, null));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ((Map)container.eContainer()).getContainer().stream().filter(c -> c != container && c.getAlias().toString().equals(container.getAlias().toString())).forEach(c -> {
                    boolean bl = l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_CONTAINER_ALIAS_NOT_UNIQUE, null));
                });
                RContainer ref = (RContainer)((IReferencable)((Object)container)).getMapReference();
                boolean bl = isTarget = ((RMap)((Map)container.eContainer()).getMapReference()).getTargetSetRef(container) != null;
                if (container instanceof Datastore) {
                    boolean isSource;
                    boolean bl2 = isSource = !((RMap)((Map)container.eContainer()).getMapReference()).getSourceSetRef(container.getDataset()).isEmpty();
                    if (isTarget || isSource) {
                        if (isTarget && !container.getAPI().getMdEvaluator().supportTargetMapping(container, IMetaDataInformationsProvider.EvaluationLocation.ON_REF)) {
                            l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_DATASTORE_TECH_NO_TARGET, null));
                        }
                        if (isSource && !container.getAPI().getMdEvaluator().supportSourceMapping(container, IMetaDataInformationsProvider.EvaluationLocation.ON_REF)) {
                            l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_DATASTORE_TECH_NO_SOURCE, null));
                        }
                    }
                }
                if (isTarget && container.getAPI().getMdEvaluator().evaluateConnection(container, IMetaDataInformationsProvider.EvaluationLocation.ON_REF) == null) {
                    l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_TARGET_WITHOUT_CONNECTION, null));
                }
                if (!container.getSetDescriptor().isEmpty()) {
                    if (ref.getSubExpressionTree() == null || container.getSubExpression() == null || container.getSubExpression().isEmpty()) {
                        l.add(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_CONTAINER_SUBEXPRESSION, null));
                    } else if (ref.getSubExpressionTree() != null && ref.getSubExpressionTree().missSetDescriptor(container)) {
                        l.add(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_CONTAINER_SUBEXPRESSION_MISS_SETDESCRIPTOR, null));
                    }
                    EObject obj = container.getAPI().getMdEvaluator().evaluateConnection(container, IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
                    if (obj != null) {
                        Object targetSet;
                        RMap refMap2;
                        boolean checkAncestor4Disjonction;
                        Boolean error = container.getAPI().getMdEvaluator().evaluateDisjointedDataSetError(container, IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
                        Boolean warning = container.getAPI().getMdEvaluator().evaluateDisjointedDataSetWarning(container, IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
                        boolean bl3 = checkAncestor4Disjonction = container instanceof Datastore && ((RDatastore)((Datastore)container).getMapReference()).isHierarchical();
                        if (checkAncestor4Disjonction) {
                            checkAncestor4Disjonction = container.getAPI().getMdEvaluator().evaluateErrorWhenDisjointedDataSetHaveCommonMappedAncestor(container, IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
                        }
                        List<SourceSetHelper.SubSourceSet> subSS = null;
                        if ((error.booleanValue() || warning.booleanValue()) && container.eContainer() instanceof Map && (refMap2 = (RMap)((Map)container.eContainer()).getMapReference()) != null && (targetSet = refMap2.getTargetSetRef(container)) != null) {
                            subSS = SourceSetHelper.computeSubSourceSets(targetSet.getSourceSet());
                            block8: for (SourceSetHelper.SubSourceSet s : subSS) {
                                HashSet ds = new HashSet();
                                for (IContainer iContainer : s.getContainers()) {
                                    ds.add(iContainer.getDataset());
                                }
                                if (ds.size() <= 1) continue;
                                Iterator<MapModelItem> iterator = ds.iterator();
                                while (iterator.hasNext()) {
                                    DataSet dataSet = (DataSet)iterator.next();
                                    boolean isJoined = false;
                                    Iterator iterator2 = ds.iterator();
                                    while (iterator2.hasNext()) {
                                        DataSet d2 = (DataSet)iterator2.next();
                                        if (d2 == dataSet || dataSet.getJoin4Child(d2) == null && dataSet.getJoin4Parent(d2) == null) continue;
                                        isJoined = true;
                                        break;
                                    }
                                    if (isJoined) continue;
                                    if (Boolean.TRUE.equals(error)) {
                                        l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_DISJOINT_DATASET_ON_SUBSOURCESET, null));
                                        continue block8;
                                    }
                                    if (!Boolean.TRUE.equals(warning)) continue block8;
                                    l.add(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_DISJOINT_DATASET_ON_SUBSOURCESET, null));
                                    continue block8;
                                }
                            }
                        }
                        if (checkAncestor4Disjonction) {
                            try {
                                if (subSS == null && container.eContainer() instanceof Map && (refMap2 = (RMap)((Map)container.eContainer()).getMapReference()) != null && (targetSet = refMap2.getTargetSetRef(container)) != null) {
                                    subSS = SourceSetHelper.computeSubSourceSets(targetSet.getSourceSet());
                                }
                                if (subSS != null) {
                                    for (SourceSetHelper.SubSourceSet sub : subSS) {
                                        HashMap disjointedPairs = new HashMap();
                                        for (DataSet d : sub.getDataSets()) {
                                            for (DataSet dataSet : sub.getDataSets()) {
                                                if (dataSet == d || d.getJoin4Child(dataSet) != null || d.getJoin4Parent(dataSet) != null) continue;
                                                if (disjointedPairs.get(d) == null) {
                                                    disjointedPairs.put(d, new HashSet());
                                                }
                                                ((Set)disjointedPairs.get(d)).add(dataSet);
                                            }
                                        }
                                        if (disjointedPairs.isEmpty()) continue;
                                        HashMap targetFields = new HashMap();
                                        for (Field f : ((Datastore)container).getField()) {
                                            Expression ex = f.getExpression(sub.getDesc());
                                            if (ex == null || ex.getExpression() == null || ex.getExpression().trim().isEmpty()) continue;
                                            for (RSourceItem i : ((RExpression)ex.getMapReference()).getSourceRef()) {
                                                if (!(i.getDataModel() instanceof ILogicalField)) continue;
                                                DataSet ds = ((IContainer)i.getDataModel().eContainer()).getDataset();
                                                if (targetFields.get(ds) == null) {
                                                    targetFields.put(ds, new HashSet());
                                                }
                                                ((Set)targetFields.get(ds)).add(f);
                                            }
                                        }
                                        for (Map.Entry en : disjointedPairs.entrySet()) {
                                            for (DataSet ds2 : (Set)en.getValue()) {
                                                Set f1 = (Set)targetFields.get(en.getKey());
                                                Set f2 = (Set)targetFields.get(ds2);
                                                f1.removeAll(f2);
                                                f2.removeAll(f1);
                                                HashSet<Field> h1 = new HashSet<Field>();
                                                for (Field f : f1) {
                                                    for (Field a : f.getAncestors()) {
                                                        Expression e2 = a.getExpression(sub.getDesc());
                                                        if (e2 == null || e2.getExpression() == null || e2.getExpression().trim().isEmpty()) continue;
                                                        h1.add(a);
                                                    }
                                                }
                                                HashSet<Field> h2 = new HashSet<Field>();
                                                for (Field f : f2) {
                                                    for (Field a : f.getAncestors()) {
                                                        Expression e3 = a.getExpression(sub.getDesc());
                                                        if (e3 == null || e3.getExpression() == null || e3.getExpression().trim().isEmpty()) continue;
                                                        h2.add(a);
                                                    }
                                                }
                                                if (Collections.disjoint(h1, h2)) continue;
                                                l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_DISJOINT_DATASET_WITH_MAPPED_ANCESTOR, null));
                                            }
                                        }
                                    }
                                }
                            }
                            catch (Exception ex) {
                                this.logger.error(Messages.ContainerConstraint_1, (Throwable)ex);
                            }
                        }
                    }
                }
                if (container.eContainer() instanceof Map && (refMap = (RMap)(map = (Map)container.eContainer()).getMapReference()) != null && (loadSet = refMap.getLoadSet(container)) != null) {
                    try {
                        if (container.getAPI().getMdEvaluator().evaluateErrorOnLoadSetWhenNoDirectPath(container, IMetaDataInformationsProvider.EvaluationLocation.ON_REF)) {
                            Graph graph = new Graph();
                            ArrayList<Join> joins = new ArrayList<Join>();
                            boolean isInRightJoin = false;
                            for (Join j : map.getJoin()) {
                                if (j.getLocation() != JoinLocation.SRC || j.getLeft() == null || j.getRight() == null || !loadSet.getContainer().contains((Object)j.getLeft()) || !loadSet.getContainer().contains((Object)j.getRight())) continue;
                                joins.add(j);
                                if (j.getRight() != container) continue;
                                isInRightJoin = true;
                            }
                            if (isInRightJoin) {
                                HashMap<Vertice, IContainer> data = new HashMap<Vertice, IContainer>();
                                for (Join j : joins) {
                                    Vertice a = graph.createVertice(j.getLeft());
                                    Vertice vertice = graph.createVertice(j.getRight());
                                    data.put(a, j.getLeft());
                                    data.put(vertice, j.getRight());
                                    graph.createEdge(a, vertice);
                                }
                                boolean pathNotExists = false;
                                block25: for (Vertice _v : graph.getVertex()) {
                                    boolean bl4 = false;
                                    for (Edge e4 : graph.getEdges()) {
                                        void var17_36;
                                        if (e4.getEnd() == _v) {
                                            ++var17_36;
                                        }
                                        if (var17_36 <= true || data.get(_v) != container) continue;
                                        pathNotExists = true;
                                        continue block25;
                                    }
                                }
                                if (pathNotExists) {
                                    l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_JOIN_LOADSET_NO_DIRECT_PATH, null));
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        this.logger.error("Error during graph computation", (Throwable)ex);
                    }
                }
                this.checkStageArea(container, l, isTarget);
                if (container instanceof Outliner && this.outlinerCollectOnMultipleOutputs((Outliner)container)) {
                    l.add(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_OUTLINER_USED_BY_MULTIPLE_DATASTORE_BY_SHARED_LOAD, null));
                }
                return new ProblemValidationStatus(ref, null, l);
            }
            return ctx.createSuccessStatus();
        }
        catch (Exception t) {
            return new Status(4, "com.indy.gmf.map", String.valueOf(((Object)((Object)this)).getClass().getName()) + " Validation failed ", (Throwable)t);
        }
    }

    private void checkStageArea(IContainer container, Set<ProblemValidationStatus.ProblemEntry> problems, boolean isTarget) {
        Datastore ds;
        if (container instanceof Datastore && (ds = (Datastore)container).eIsSet((EStructuralFeature)MapPackage.eINSTANCE.getDatastore_StagingArea())) {
            Template integrationTpl;
            if (!isTarget) {
                problems.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_DATASTORE_STAGING_AREA_ON_SOURCE, null));
            } else {
                boolean hasLoadTemplate = false;
                for (Template t : ((Map)ds.eContainer()).getTemplateForTarget(ds)) {
                    if (((RTemplate)t.getMapReference()).getTemplateType() != RTemplate.Type.LOAD) continue;
                    hasLoadTemplate = true;
                    break;
                }
                if (!hasLoadTemplate) {
                    problems.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_DATASTORE_STAGING_AREA_REQUIRE_LOAD_TEMPLATE, null));
                }
            }
            if (ds.getAPI().getMdEvaluator().hasWorkspaceCapability(ds, IMetaDataInformationsProvider.EvaluationLocation.ON_REF)) {
                problems.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_DATASTORE_STAGING_AREA_WITH_WKSP_CAPABILITY, null));
            }
            boolean supportLoad = true;
            if (ds.getTag().contains((Object)new QName("NO_LOAD"))) {
                supportLoad = false;
            }
            if (supportLoad && (integrationTpl = ((Map)ds.eContainer()).getIntegrationTemplate(ds)).getProcess() instanceof ActionProcess && !UpdateInstanceCommand.checkTemplateSupportLoad(integrationTpl, (FlowGraphBuilder.TargetSet)((Object)((RMap)((Map)ds.eContainer()).getMapReference()).getTargetSetRef(ds).getDataModel()))) {
                supportLoad = false;
            }
            if (!supportLoad) {
                problems.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_DATASTORE_STAGING_AREA_WITH_NO_LOAD_TEMPLATE, null));
            }
        }
    }

    private boolean outlinerCollectOnMultipleOutputs(Outliner container) {
        Map m = (Map)container.eContainer();
        for (Template t : m.getTemplate()) {
            RTemplate refTpl = (RTemplate)t.getMapReference();
            if (refTpl.getTemplateType() != RTemplate.Type.LOAD || !refTpl.getRef().contains(container) || refTpl.getTargetRef().isEmpty()) continue;
            return true;
        }
        return false;
    }
}

