/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.validation;

import com.indy.map.DataSet;
import com.indy.map.Datastore;
import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.IExpression;
import com.indy.map.ILogicalField;
import com.indy.map.IMetaData;
import com.indy.map.Join;
import com.indy.map.Map;
import com.indy.map.MapLocation;
import com.indy.map.MapModelItem;
import com.indy.map.Query;
import com.indy.map.QueryField;
import com.indy.map.api.IMetaDataInformationsProvider;
import com.indy.map.compute.validator.ILinkValidator;
import com.indy.map.compute.validator.MappingValidator;
import com.indy.map.messages.Messages;
import com.indy.map.ref.RExpression;
import com.indy.map.ref.RLoadSet;
import com.indy.map.ref.RLogicalField;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RProblem;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RSourceSet;
import com.indy.map.ref.RTargetSet;
import com.indy.map.ref.RUDFRef;
import com.indy.map.util.ClauseHelper;
import com.indy.map.validation.ClauseConstraint;
import com.indy.map.validation.ProblemValidationStatus;
import com.indy.map.validation.UDFVariableConflictState;
import com.indy.map.validation.parsers.ExpressionParserHelper;
import com.semarchy.xdi.designer.core.IExpressionParser;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.registry.UDF;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.md.MdNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class ExpressionConstraint
extends AbstractModelConstraint {
    private IRegistryService registryService = (IRegistryService)E4InjectorHelper.getService(IRegistryService.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IStatus validate(IValidationContext ctx) {
        ProblemValidationStatus problemValidationStatus;
        BundleContext bundleCtx = null;
        EObject eObj = ctx.getTarget();
        if (!(eObj instanceof RExpression) && !(eObj instanceof Expression)) return ctx.createSuccessStatus();
        Expression expr = eObj instanceof RExpression ? (Expression)((RExpression)eObj).getDataModel() : (Expression)eObj;
        RExpression ref = (RExpression)expr.getMapReference();
        HashSet<ProblemValidationStatus.ProblemEntry> l = new HashSet<ProblemValidationStatus.ProblemEntry>();
        ServiceReference serviceRef = null;
        UDFVariableConflictState varConflictState = null;
        try {
            Collection c;
            Expression o = expr;
            while (o != null && !(o instanceof Map)) {
                o = o.eContainer();
            }
            String mappingUniqueId = null;
            if (o instanceof Map) {
                mappingUniqueId = String.valueOf(((Map)((Object)o)).getId()) + "_" + ((Map)((Object)o)).hashCode();
            }
            if ((c = (bundleCtx = Platform.getBundle((String)"com.indy.gmf.map").getBundleContext()).getServiceReferences(UDFVariableConflictState.class, "(service.pid=" + mappingUniqueId + ")")) != null && !c.isEmpty()) {
                serviceRef = (ServiceReference)c.iterator().next();
                varConflictState = (UDFVariableConflictState)bundleCtx.getService(serviceRef);
            }
        }
        catch (Exception o) {
            // empty catch block
        }
        try {
            String parserURL;
            EObject con;
            boolean isAutoFeed = false;
            HashSet<String> srcRefFullPaths = new HashSet<String>();
            HashSet<String> ambiguousExpressions = new HashSet<String>();
            StringBuffer buf = new StringBuffer();
            if (ref != null) {
                ILogicalField expressionField = (ILogicalField)expr.eContainer();
                for (Object it : ref.getSourceRef()) {
                    IRegistryService.IRegistry registry;
                    if (it instanceof RLogicalField) {
                        ILinkValidator.ValidationStatus st;
                        String fullPath;
                        MapModelItem refSrc = it.getDataModel();
                        if (refSrc instanceof ILogicalField && (fullPath = ((ILogicalField)((Object)refSrc)).getFullPath()) != null && !srcRefFullPaths.add(fullPath.toLowerCase()) && ambiguousExpressions.add(fullPath.toLowerCase())) {
                            l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_AMBIGOUS_SRC_REF_FULL_PATH, fullPath));
                        }
                        if ((st = MappingValidator.INSTANCE.canCreateLink(it.getDataModel().eContainer(), expr.eContainer().eContainer())).isError()) {
                            if (buf.length() > 0) {
                                buf.append("\n");
                            }
                            buf.append("-");
                            buf.append(st.getMessage());
                            if (!isAutoFeed && ((IContainer)it.getDataModel().eContainer()).getDataset() == ((IContainer)expr.eContainer().eContainer()).getDataset()) {
                                isAutoFeed = true;
                            }
                        }
                        if (it.getDataModel() instanceof QueryField && !((ILogicalField)((Object)it.getDataModel())).isEnable()) {
                            l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_USING_DISABLED_FIELD, ((ILogicalField)((Object)it.getDataModel())).getFullPath()));
                        }
                        try {
                            ILogicalField sourceField = (ILogicalField)((Object)it.getDataModel());
                            if (expr.getLocation() != MapLocation.SRC && sourceField instanceof Field && ((Field)sourceField).isExtraStatic()) {
                                boolean supportExtraStatic = false;
                                Datastore parentContainer = null;
                                try {
                                    parentContainer = (Datastore)sourceField.eContainer();
                                    supportExtraStatic = parentContainer.getAPI().getMdEvaluator().supportExtraStaticFieldUsageOnWrk(parentContainer);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (!supportExtraStatic) {
                                    l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_USING_EXTRA_FIELD, sourceField.getFullPath().toString()));
                                }
                            }
                            EObject srcStagingArea = ((IContainer)sourceField.eContainer()).getAPI().getMdEvaluator().evaluateConnection((IContainer)sourceField.eContainer(), IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
                            EObject trgStagingArea = ((IContainer)expressionField.eContainer()).getAPI().getMdEvaluator().evaluateConnection((IContainer)expressionField.eContainer(), IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING);
                            URI srcStagingAreaURI = null;
                            if (srcStagingArea != null) {
                                srcStagingAreaURI = srcStagingArea.eIsProxy() ? ((InternalEObject)srcStagingArea).eProxyURI() : EcoreUtil.getURI((EObject)srcStagingArea);
                            }
                            URI trgStagingAreaURI = null;
                            if (trgStagingArea != null) {
                                URI uRI = trgStagingAreaURI = trgStagingArea.eIsProxy() ? ((InternalEObject)trgStagingArea).eProxyURI() : EcoreUtil.getURI((EObject)trgStagingArea);
                            }
                            if (sourceField.eContainer() instanceof Query && expr.eContainer().eContainer() instanceof Query && !sourceField.isStageable() && srcStagingAreaURI != null && trgStagingAreaURI != null && !srcStagingAreaURI.equals(trgStagingAreaURI) && (((QueryField)expr.eContainer()).getMdNode() == null || expr.getLocation() != MapLocation.SRC)) {
                                l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_STAGING_CONNECTION_DIFFERENT, null));
                            }
                            if (expr.getLocation() != MapLocation.WRK || srcStagingAreaURI == null || trgStagingAreaURI == null || srcStagingAreaURI.equals(trgStagingAreaURI) || sourceField.isStageable()) continue;
                            l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_WORK_LOCATION_STAGING, null));
                        }
                        catch (Throwable t) {
                            ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.indy.map").error(Messages.ExpressionConstraint_6, (Object)t);
                        }
                        continue;
                    }
                    if (!(it instanceof RUDFRef) || (registry = this.registryService.getRegistry(UDF.class)) == null) continue;
                    List udf = registry.find((IRegistryService.IRegistryMatcher)((RUDFRef)it).getIdentifier());
                    if (udf == null || udf.isEmpty()) {
                        l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_UDF_NOT_FOUND, ((RUDFRef)it).getIdentifier().getFullName()));
                        continue;
                    }
                    for (String productCode : ref.getContextualProductCode()) {
                        if (((UDF)udf.get(0)).supportProduct(productCode)) continue;
                        l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_UDF_MISSING_PRODUCT_IMPLEMENTATION, Messages.bind((String)Messages.ExpressionConstraint_7, (Object)productCode, (Object)((UDF)udf.get(0)).getFunctionFullName())));
                    }
                    if (varConflictState == null) continue;
                    try {
                        varConflictState.check((UDF)udf.get(0));
                    }
                    catch (Exception e) {
                        l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_VARIABLE_CONFLICT, e.getMessage()));
                    }
                }
            }
            if (buf.length() > 0) {
                QName errCode = null;
                errCode = isAutoFeed ? RProblem.ERROR_MAPPING_BY_OWN_DATASET : RProblem.ERROR_MAPPING_AND_ANCESTOR_JOIN;
                l.add(new ProblemValidationStatus.ProblemEntry(errCode, buf.toString()));
            }
            if (expr.eResource() != null && expr.eContainer() instanceof IMetaData) {
                for (QName q : this.checkField(expr)) {
                    l.add(new ProblemValidationStatus.ProblemEntry(q, null));
                }
            }
            if (this.checkJoinAndWorkspaceCapability(expr)) {
                l.add(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_NO_WORKSPACE_CAPABILITY_AND_JOIN, null));
            }
            if (expr.getExpression() != null && !expr.getExpression().trim().isEmpty() && (con = ExpressionParserHelper.getContextConnection(expr)) instanceof MdNode && (parserURL = ((MdNode)con).evaluateXpathExpressionCached("INTERNAL_EXPRESSION_PARSER", null)) != null) {
                try {
                    String parseError;
                    IExpressionParser parser = ExpressionParserHelper.createParser(parserURL);
                    if (parser != null && (parseError = parser.parse(expr.getExpression(), ExpressionParserHelper.getExpressionOptions())) != null) {
                        l.add(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_SQL_PARSER_FAILURE, parseError));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            problemValidationStatus = new ProblemValidationStatus(ref, null, l);
            if (serviceRef == null) return problemValidationStatus;
        }
        catch (Throwable throwable) {
            try {
                if (serviceRef == null) throw throwable;
                bundleCtx.ungetService(serviceRef);
                throw throwable;
            }
            catch (Throwable t) {
                return new Status(4, "com.indy.gmf.map", String.valueOf(((Object)((Object)this)).getClass().getName()) + " Validation failed ", t);
            }
        }
        bundleCtx.ungetService(serviceRef);
        return problemValidationStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkJoinAndWorkspaceCapability(Expression expr) {
        ILogicalField trgField = (ILogicalField)expr.eContainer();
        RExpression refExpr = null;
        try {
            refExpr = (RExpression)expr.getMapReference();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (refExpr == null) return false;
        if (refExpr.getSourceRef().isEmpty()) return false;
        try {
            if (expr.getAPI().getMdEvaluator().hasWorkspaceCapability((IContainer)trgField.eContainer(), IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING)) return false;
            Map map = (Map)trgField.eContainer().eContainer();
            RMap refMap = (RMap)map.getMapReference();
            RSourceSet refSS = refMap.getInputSourceSet((IContainer)trgField.eContainer());
            if (refSS == null) return false;
            Iterator iterator = refSS.getDataSet().iterator();
            block4: while (true) {
                Join j;
                if (!iterator.hasNext()) {
                    return false;
                }
                DataSet ds = (DataSet)iterator.next();
                Iterator iterator2 = ds.getJoin().iterator();
                do {
                    if (!iterator2.hasNext()) continue block4;
                } while ((j = (Join)iterator2.next()).isInheritance() && (j.getLeft() != null && !refSS.getDataSet().contains((Object)j.getLeft().getDataset()) || j.getRight() != null && !refSS.getDataSet().contains((Object)j.getRight().getDataset())) || ClauseHelper.hasRefOnSameConnection(j));
                break;
            }
            return true;
        }
        catch (Exception ex) {
            ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.indy.map").error(Messages.ExpressionConstraint_8, (Object)ex);
        }
        return false;
    }

    protected List<QName> checkField(Expression expr) {
        ArrayList<QName> l;
        block29: {
            l = new ArrayList<QName>();
            try {
                IExpression.MappingMode mm = expr.getMappingMode();
                ILogicalField trgField = (ILogicalField)expr.eContainer();
                if (trgField instanceof QueryField && expr.getLocation().equals((Object)MapLocation.SRC) && !trgField.isStageable()) {
                    l.add(RProblem.ERROR_SOURCE_LOCATION_WITHOUT_DATATYPE);
                }
                if (expr.getLocation().equals((Object)MapLocation.SRC)) {
                    if (((RExpression)expr.getMapReference()).getSourceRef().size() > 0) {
                        if (!mm.equals((Object)IExpression.MappingMode.BIJECTIVE)) {
                            EObject previousConnection = null;
                            boolean error02Added = false;
                            RLoadSet loadSet = null;
                            for (RSourceItem srcRef : ((RExpression)expr.getMapReference()).getRealSourceRef()) {
                                RLoadSet ls;
                                MapModelItem it = srcRef.getDataModel();
                                if (it instanceof ILogicalField && ((ILogicalField)((Object)it)).isStageable()) {
                                    if (!expr.getAPI().getMdEvaluator().hasTransformOrWorkspaceCapability((IContainer)it.eContainer(), IMetaDataInformationsProvider.EvaluationLocation.ON_REF)) {
                                        l.add(RProblem.ERROR_TRANSFORM_SOURCE_LOCATION);
                                    } else if (expr.getAPI().getMdEvaluator().hasWarningOnTransform((IContainer)it.eContainer(), IMetaDataInformationsProvider.EvaluationLocation.ON_REF)) {
                                        l.add(RProblem.WARNING_TRANSFORM_CAPABILITIES);
                                    }
                                }
                                if (!mm.equals((Object)IExpression.MappingMode.MULTI_FIELDS) || !(it instanceof ILogicalField)) continue;
                                if (loadSet == null) {
                                    loadSet = ((RMap)((Map)it.eContainer().eContainer()).getMapReference()).getLoadSet((IContainer)it.eContainer());
                                }
                                EObject curConn = ((IContainer)it.eContainer()).getAPI().getMdEvaluator().evaluateConnection((IContainer)it.eContainer(), IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
                                if (previousConnection == null) {
                                    previousConnection = curConn;
                                    continue;
                                }
                                if (!error02Added && curConn != null && !ClauseConstraint.connectionsEquals(curConn, previousConnection)) {
                                    l.add(RProblem.ERROR_SOURCE_LOCATION);
                                    error02Added = true;
                                }
                                if (loadSet == null || curConn == null || (ls = ((RMap)((Map)it.eContainer().eContainer()).getMapReference()).getLoadSet((IContainer)it.eContainer())) == loadSet) continue;
                                l.add(RProblem.ERROR_SOURCE_LOCATION_MULTIPLE_LOAD_SET);
                            }
                        }
                    } else if (trgField.isMapped() && !expr.getAPI().getMdEvaluator().hasTransformOrWorkspaceCapability((IContainer)trgField.eContainer(), IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING)) {
                        RTargetSet trgSet = ((RMap)((Map)trgField.eContainer().eContainer()).getMapReference()).getTargetSetRef((IContainer)trgField.eContainer());
                        if (trgSet == null) {
                            l.add(RProblem.ERROR_NO_TARGETSET);
                        } else {
                            ArrayList<String> srcConnectionsId = new ArrayList<String>();
                            for (DataSet ds : trgSet.getSourceSet().getDataSet()) {
                                for (IContainer c : ds.getContainer()) {
                                    String conId = c.getAPI().getMdEvaluator().evaluateConnectionId(c, IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
                                    if (conId == null || srcConnectionsId.contains(conId)) continue;
                                    srcConnectionsId.add(conId);
                                }
                            }
                            if (srcConnectionsId.size() > 1) {
                                l.add(RProblem.WARNING_SOURCE_LOCATION);
                            }
                        }
                    }
                    break block29;
                }
                if (expr.getLocation().equals((Object)MapLocation.WRK) && !mm.equals((Object)IExpression.MappingMode.BIJECTIVE) && trgField.isStageable()) {
                    if (expr.getExpression() != null && !expr.getExpression().isEmpty()) {
                        if (!expr.getAPI().getMdEvaluator().hasTransformOrWorkspaceCapability((IContainer)trgField.eContainer(), IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING)) {
                            l.add(RProblem.ERROR_TRANSFORM_STAGING_LOCATION);
                        } else if (expr.getAPI().getMdEvaluator().hasWarningOnTransform((IContainer)trgField.eContainer(), IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING)) {
                            l.add(RProblem.WARNING_TRANSFORM_CAPABILITIES);
                        }
                    }
                    break block29;
                }
                if (!expr.getLocation().equals((Object)MapLocation.TRG)) break block29;
                try {
                    IContainer c = (IContainer)expr.eContainer().eContainer();
                    Map map = (Map)c.eContainer();
                    RTargetSet ts = ((RMap)map.getMapReference()).getTargetSetRef(c);
                    for (RSourceItem rs : ((RExpression)expr.getMapReference()).getSourceRef()) {
                        if (!(rs.getDataModel() instanceof ILogicalField) || !ts.getSourceSet().contains((IContainer)rs.getDataModel().eContainer())) continue;
                        l.add(RProblem.WARNING_FIELD_TARGET_LOCATION);
                        break;
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return l;
    }
}

