/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.validation;

import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.ILogicalField;
import com.indy.map.IReferencable;
import com.indy.map.QueryField;
import com.indy.map.ref.RField;
import com.indy.map.ref.RLogicalField;
import com.indy.map.ref.RProblem;
import com.indy.map.validation.ProblemValidationStatus;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;

public class FieldConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        try {
            EObject eObj = ctx.getTarget();
            if (eObj instanceof RLogicalField || eObj instanceof ILogicalField) {
                ILogicalField field = eObj instanceof RLogicalField ? (ILogicalField)((Object)((RLogicalField)eObj).getDataModel()) : (ILogicalField)eObj;
                ProblemValidationStatus ms = new ProblemValidationStatus((EObject)((IReferencable)((Object)field)).getMapReference(), null, new HashSet<ProblemValidationStatus.ProblemEntry>());
                boolean hasEmpty = false;
                boolean hasMapped = false;
                boolean warningNotExpressionAllSet = false;
                for (Expression exp : field.getExpression()) {
                    if (exp.getExpression() == null || exp.getExpression().trim().isEmpty()) {
                        hasEmpty = true;
                        if (!hasMapped) continue;
                        warningNotExpressionAllSet = true;
                        break;
                    }
                    hasMapped = true;
                    if (!hasEmpty) continue;
                    warningNotExpressionAllSet = true;
                    break;
                }
                if (field instanceof Field) {
                    String fullAlias;
                    if (hasMapped && !((Field)field).getAPI().getMdEvaluator().supportTargetMapping((Field)field)) {
                        ms.addChild((IStatus)new ProblemValidationStatus((EObject)((IReferencable)((Object)field)).getMapReference(), null, Collections.singleton(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_FIELD_TECH_NO_TARGET, field.getFullPath()))));
                    }
                    if (!((RField)((Field)field).getMapReference()).getUsage().isEmpty() && (fullAlias = ((Field)field).getFullAlias()) != null && !fullAlias.equals(((Field)field).getFullAlias())) {
                        ms.addChild((IStatus)new ProblemValidationStatus((EObject)((IReferencable)((Object)field)).getMapReference(), null, Collections.singleton(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_FIELD_WRONG_FULL_ALIAS, null))));
                    }
                }
                if (field instanceof QueryField && !((RLogicalField)((QueryField)field).getMapReference()).getUsage().isEmpty() && !hasMapped) {
                    ms.addChild((IStatus)new ProblemValidationStatus((EObject)((IReferencable)((Object)field)).getMapReference(), null, Collections.singleton(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_QUERY_FIELD_NOT_DEFINED, null))));
                }
                if (warningNotExpressionAllSet) {
                    ms.addChild((IStatus)new ProblemValidationStatus((EObject)((IReferencable)((Object)field)).getMapReference(), null, Collections.singleton(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_FIELD_NOT_MAPPED_IN_ALL_SET, null))));
                }
                return ms;
            }
            return ctx.createSuccessStatus();
        }
        catch (Throwable t) {
            return new Status(4, "com.indy.gmf.map", String.valueOf(((Object)((Object)this)).getClass().getName()) + " Validation failed ", t);
        }
    }
}

