/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.validation;

import com.indy.map.IReferencable;
import com.indy.map.Map;
import com.indy.map.MapPackage;
import com.indy.map.ref.RItem;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RProblem;
import com.indy.map.ref.RefPackage;
import com.indy.map.util.synchro.IRefItemUpdater;
import com.indy.map.util.synchro.IRefUpdaterProvider;
import com.indy.map.validation.ProblemValidationStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ILiveValidator;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.emf.validation.util.FilteredCollection;

public abstract class LiveValidationContentAdapter
extends EContentAdapter {
    private ILiveValidator validator = null;
    private IBatchValidator batchValidator = null;
    private static LiveValidationContentAdapter INSTANCE = new LiveValidationContentAdapter(){};
    private FilteredCollection.Filter<Notification> updateFilter = new FilteredCollection.Filter<Notification>(){

        public boolean accept(Notification element) {
            return element.getFeature() == MapPackage.eINSTANCE.getQuery_SetDescriptor() || element.getFeature() == MapPackage.eINSTANCE.getDatastore_SetDescriptor() || element.getFeature() == MapPackage.eINSTANCE.getMap_Datastore() || element.getFeature() == MapPackage.eINSTANCE.getMap_Query() || element.getFeature() == MapPackage.eINSTANCE.getMap_Outliner() || element.getFeature() == MapPackage.eINSTANCE.getDatastore_ComputedField() || element.getFeature() == MapPackage.eINSTANCE.getDatastore_Field() || element.getFeature() == MapPackage.eINSTANCE.getQuery_Field() || element.getFeature() == MapPackage.eINSTANCE.getQuery_ComputedField() || element.getFeature() == MapPackage.eINSTANCE.getOutliner_Field() || element.getFeature() == MapPackage.eINSTANCE.getOutliner_OutputField() || element.getFeature() == MapPackage.eINSTANCE.getSetDescriptor_Label() || element.getFeature() == MapPackage.eINSTANCE.getClause_Location() || element.getFeature() == MapPackage.eINSTANCE.getMap_Variable();
        }
    };

    private LiveValidationContentAdapter() {
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (this.validator == null) {
            this.validator = (ILiveValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.LIVE);
            this.validator.setNotificationFilter((FilteredCollection.Filter)new FilteredCollection.Filter<Notification>(){

                public boolean accept(Notification element) {
                    return element.getFeature() == RefPackage.eINSTANCE.getRUsage_SourceRef() || element.getFeature() == RefPackage.eINSTANCE.getRSourceItem_Usage() || element.getFeature() == RefPackage.eINSTANCE.getRUsage_InternalExpression() || element.getFeature() == MapPackage.eINSTANCE.getClause_Location() || element.getFeature() == MapPackage.eINSTANCE.getJoin_Left() || element.getFeature() == MapPackage.eINSTANCE.getJoin_Right() || element.getFeature() == MapPackage.eINSTANCE.getDatastore_Ref() || element.getFeature() == MapPackage.eINSTANCE.getQuery_StagingArea() || element.getFeature() == MapPackage.eINSTANCE.getField_Ref() || element.getFeature() == MapPackage.eINSTANCE.getExpression_Location() || element.getFeature() == MapPackage.eINSTANCE.getMap_Datastore() || element.getFeature() == MapPackage.eINSTANCE.getMap_Query() || element.getFeature() == MapPackage.eINSTANCE.getMap_Outliner() || element.getFeature() == MapPackage.eINSTANCE.getDatastore_Field() || element.getFeature() == MapPackage.eINSTANCE.getDatastore_ComputedField() || element.getFeature() == MapPackage.eINSTANCE.getQuery_ComputedField() || element.getFeature() == MapPackage.eINSTANCE.getQuery_Field() || element.getFeature() == MapPackage.eINSTANCE.getQuery_SubExpression() || element.getFeature() == MapPackage.eINSTANCE.getOutliner_Field() || element.getFeature() == MapPackage.eINSTANCE.getOutliner_OutputField() || element.getFeature() == MapPackage.eINSTANCE.getDatastore_SubExpression() || element.getFeature() == MapPackage.eINSTANCE.getMap_Variable();
                }
            });
            this.validator.setReportSuccesses(true);
            this.batchValidator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
            this.batchValidator.setReportSuccesses(true);
            this.batchValidator.setIncludeLiveConstraints(true);
        }
        IStatus status = this.validator.validate(notification);
        this.updateProblems(status);
        if (this.updateFilter.accept((Object)notification)) {
            status = this.updateProblematicObjects(notification);
            this.updateProblems(status);
        }
    }

    public void updateProblems(IStatus status) {
        Object it;
        List<ProblemValidationStatus> l = this.handleStatus(status);
        HashMap m = new HashMap();
        for (ProblemValidationStatus s : l) {
            it = (RItem)s.getTarget();
            ArrayList<QName> h = (ArrayList<QName>)m.get(it);
            if (h == null) {
                h = new ArrayList<QName>();
                m.put(it, h);
            }
            for (Object o : s.getResultLocus()) {
                h.add(((RProblem)o).getCode());
            }
        }
        for (RItem k : m.keySet()) {
            if (k == null) continue;
            it = k.getProblem().iterator();
            while (it.hasNext()) {
                RProblem p = (RProblem)it.next();
                if (((List)m.get(k)).contains(p.getCode())) continue;
                it.remove();
            }
            for (QName q : (List)m.get(k)) {
                k.addProblem(q);
            }
        }
    }

    private IStatus updateProblematicObjects(Notification notification) {
        Map map = null;
        EObject obj = (EObject)notification.getNotifier();
        while (obj != null && map == null) {
            if (!((obj = obj.eContainer()) instanceof Map)) continue;
            map = (Map)obj;
        }
        if (map == null) {
            return Status.OK_STATUS;
        }
        if (notification.getEventType() == 3 || notification.getEventType() == 5) {
            for (RItem it : ((RMap)map.getMapReference()).getProblematicItems()) {
                IRefItemUpdater<RItem> updater = IRefUpdaterProvider.INSTANCE.getUpdater(it);
                if (updater == null) continue;
                try {
                    updater.updateAll(it);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return Status.OK_STATUS;
    }

    private List<ProblemValidationStatus> handleStatus(IStatus status) {
        ArrayList<ProblemValidationStatus> l = new ArrayList<ProblemValidationStatus>();
        if (status instanceof ProblemValidationStatus) {
            l.add((ProblemValidationStatus)status);
        }
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus s = iStatusArray[n2];
                l.addAll(this.handleStatus(s));
                ++n2;
            }
        }
        return l;
    }

    public void batchValidate(Map mapModel) {
        TreeIterator it = mapModel.eAllContents();
        ArrayList<EObject> l = new ArrayList<EObject>();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            RItem ref = null;
            if (obj instanceof IReferencable) {
                ref = (RItem)((IReferencable)obj).getMapReference();
            }
            if (obj == null) continue;
            l.add(obj);
        }
        IStatus status = this.batchValidator.validate(l);
        this.updateProblems(status);
    }

    /* synthetic */ LiveValidationContentAdapter(LiveValidationContentAdapter liveValidationContentAdapter) {
        this();
    }
}

