/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.validation;

import com.indy.map.DataSet;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.JoinLocation;
import com.indy.map.Map;
import com.indy.map.MapModelItem;
import com.indy.map.QueryField;
import com.indy.map.TargetFilter;
import com.indy.map.Template;
import com.indy.map.api.IMetaDataInformationsProvider;
import com.indy.map.compute.validator.ILinkValidator;
import com.indy.map.compute.validator.MappingValidator;
import com.indy.map.ref.RClause;
import com.indy.map.ref.RLogicalField;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RProblem;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RSourceSet;
import com.indy.map.ref.RTemplate;
import com.indy.map.validation.ProblemValidationStatus;
import com.indy.map.validation.UsageConstraint;
import com.semarchy.xdi.designer.core.capabilities.ICapability;
import com.semarchy.xdi.designer.core.capabilities.ICapabilityProvider;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;

public class TargetFilterConstraint
extends UsageConstraint {
    private static final Pattern PATTERN_GENE_BLOCK = Pattern.compile("(%[esx](\\([a-zA-Z0-1]*\\))?\\{)");

    @Override
    public IStatus validate(IValidationContext ctx) {
        try {
            EObject eObj = ctx.getTarget();
            IStatus s = super.validate(ctx);
            if (eObj instanceof TargetFilter || eObj instanceof RClause && ((RClause)eObj).getDataModel() instanceof TargetFilter) {
                EObject o;
                IContainer owner;
                Map map;
                Template integrationTemplate;
                boolean targetLocationSupported;
                TargetFilter trgFilter = eObj instanceof TargetFilter ? (TargetFilter)eObj : (TargetFilter)((RClause)eObj).getDataModel();
                RClause ref = (RClause)trgFilter.getMapReference();
                HashSet<ProblemValidationStatus.ProblemEntry> l = new HashSet<ProblemValidationStatus.ProblemEntry>();
                if (trgFilter.getLocation() == JoinLocation.WRK) {
                    for (IContainer c : trgFilter.getInvolvedContainers()) {
                        if (!MappingValidator.INSTANCE.canCreateLink(c, trgFilter.eContainer()).isError()) continue;
                        l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_TARGETFILTER_SRC_NOT_MAPPABLE, c.getAlias().toString()));
                    }
                }
                boolean isAutoFeed = false;
                HashSet<String> srcRefFullPaths = new HashSet<String>();
                HashSet<String> ambiguousExpressions = new HashSet<String>();
                StringBuffer buf = new StringBuffer();
                if (ref != null) {
                    IContainer container = (IContainer)trgFilter.eContainer();
                    for (RSourceItem it : ref.getSourceRef()) {
                        Object st;
                        String fullPath;
                        if (!(it instanceof RLogicalField)) continue;
                        MapModelItem refSrc = it.getDataModel();
                        if (refSrc instanceof ILogicalField && (fullPath = ((ILogicalField)((Object)refSrc)).getFullPath()) != null && !srcRefFullPaths.add(fullPath.toLowerCase()) && ambiguousExpressions.add(fullPath.toLowerCase())) {
                            l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_AMBIGOUS_SRC_REF_FULL_PATH, fullPath));
                        }
                        if (((ILinkValidator.ValidationStatus)(st = MappingValidator.INSTANCE.canCreateLink(it.getDataModel().eContainer(), container))).isError()) {
                            if (buf.length() > 0) {
                                buf.append("\n");
                            }
                            buf.append("-");
                            buf.append(((ILinkValidator.ValidationStatus)st).getMessage());
                            if (!isAutoFeed && ((IContainer)it.getDataModel().eContainer()).getDataset() == container.getDataset()) {
                                isAutoFeed = true;
                            }
                        }
                        if (it.getDataModel() instanceof QueryField && !((ILogicalField)((Object)it.getDataModel())).isEnable()) {
                            l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_USING_DISABLED_FIELD, null));
                        }
                        ILogicalField sourceField = (ILogicalField)((Object)it.getDataModel());
                        if (trgFilter.getLocation() == JoinLocation.WRK && !sourceField.isStageable()) {
                            IContainer owner2 = (IContainer)trgFilter.eContainer();
                            Map map2 = (Map)owner2.eContainer();
                            for (Template t : map2.getTemplate()) {
                                RTemplate rTpl = (RTemplate)t.getMapReference();
                                if (!rTpl.getTargetRef().contains((Object)owner2) || rTpl.getLoad() == null || !rTpl.getLoad().getContainer().contains((Object)sourceField.eContainer())) continue;
                                l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_CLAUSE_NON_STAGEABLE_FIELD, null));
                            }
                        }
                        if (trgFilter.getLocation() != JoinLocation.TRG || trgFilter.eContainer() == sourceField.eContainer()) continue;
                        l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_TARGET_FILTER_SOURCE_NOT_OWNED, sourceField.getFullPath()));
                    }
                }
                if (trgFilter.getLocation() == JoinLocation.WRK) {
                    HashSet<RSourceSet> sourceSets = new HashSet<RSourceSet>();
                    HashSet<DataSet> involvedDataSets = new HashSet<DataSet>();
                    for (IContainer c : trgFilter.getInvolvedContainers()) {
                        involvedDataSets.add(c.getDataset());
                    }
                    Map map3 = null;
                    EObject o2 = trgFilter.eContainer();
                    while (map3 == null && o2 != null) {
                        if (o2 instanceof Map) {
                            map3 = (Map)o2;
                        }
                        o2 = o2.eContainer();
                    }
                    for (RSourceSet ss : ((RMap)map3.getMapReference()).getSourceSetRef()) {
                        if (!ss.getDataSet().containsAll(involvedDataSets)) continue;
                        sourceSets.add(ss);
                    }
                    boolean multipleTargetTechs = false;
                    for (RSourceSet ss : sourceSets) {
                        String productCode = null;
                        if (!ss.getTargetSet().getContainerModel().contains(trgFilter.eContainer())) continue;
                        for (IContainer target : trgFilter.getInvolvedContainers()) {
                            EObject o3 = target.getAPI().getMdEvaluator().evaluateConnection(target, IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
                            if (o3 == null || multipleTargetTechs) continue;
                            try {
                                String _productCode = target.getAPI().getMdEvaluator().evaluateTechCode(target, IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
                                if (productCode == null) {
                                    productCode = _productCode;
                                    continue;
                                }
                                if (productCode.equals(_productCode)) continue;
                                multipleTargetTechs = true;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if (multipleTargetTechs) {
                        l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_MULTIPLE_TARGET_TECH, null));
                    }
                    try {
                        IContainer owner3 = (IContainer)trgFilter.eContainer();
                        EObject o4 = owner3.getAPI().getMdEvaluator().evaluateConnection(owner3, IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING);
                        if (o4 != null) {
                            if (!trgFilter.getAPI().getMdEvaluator().hasFilterOrWorkspaceCapability(owner3, IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING)) {
                                l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_NO_FILTER_CAPABILITY_GUI, null));
                            } else if (trgFilter.getAPI().getMdEvaluator().hasWarningOnFilter(owner3, IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING)) {
                                l.add(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_TRANSFORM_CAPABILITIES, null));
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (trgFilter.getLocation() == JoinLocation.WRK && buf.length() > 0) {
                    if (isAutoFeed) {
                        l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_MAPPING_BY_OWN_DATASET, buf.toString()));
                    } else {
                        l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_MAPPING_AND_ANCESTOR_JOIN, buf.toString()));
                    }
                }
                if (trgFilter.getLocation() == JoinLocation.TRG && !(targetLocationSupported = TargetFilterConstraint.isTargetFilterOnTrgAllowed(integrationTemplate = (map = (Map)(owner = (IContainer)trgFilter.eContainer()).eContainer()).getIntegrationTemplate(owner)))) {
                    l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_TEMPLATE_DOES_NOT_SUPPORT_TARGET_FILTER, null));
                }
                if ((o = trgFilter.getAPI().getMdEvaluator().evaluateConnection((IContainer)trgFilter.eContainer(), IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING)) != null) {
                    try {
                        if (!trgFilter.getAPI().getMdEvaluator().hasFilterOrWorkspaceCapability((IContainer)trgFilter.eContainer(), IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING)) {
                            l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_NO_FILTER_CAPABILITY_GUI, null));
                        } else if (trgFilter.getAPI().getMdEvaluator().hasWarningOnFilter((IContainer)trgFilter.eContainer(), IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING)) {
                            l.add(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_TRANSFORM_CAPABILITIES, null));
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (s instanceof ProblemValidationStatus) {
                    ((ProblemValidationStatus)s).getResultLocus().addAll(l);
                    return s;
                }
                return new ProblemValidationStatus((EObject)trgFilter.getMapReference(), null, l);
            }
            return s;
        }
        catch (Throwable t) {
            return new Status(4, "com.indy.gmf.map", String.valueOf(((Object)((Object)this)).getClass().getName()) + " Validation failed ", t);
        }
    }

    public static boolean isTargetFilterOnTrgAllowed(Template integrationTemplate) {
        if (integrationTemplate == null) {
            return false;
        }
        ICapabilityProvider provider = integrationTemplate.getCapacityProvider("template-feature-support", "targetFilter");
        if (provider == null) {
            return false;
        }
        ICapability capability = provider.getCapability("template-feature-support", "targetFilter");
        if (capability == null) {
            return false;
        }
        boolean supported = false;
        try {
            supported = integrationTemplate.isSupported(capability);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return supported;
    }
}

