/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.validation;

import com.indy.map.Clause;
import com.indy.map.ComputedField;
import com.indy.map.Datastore;
import com.indy.map.Expression;
import com.indy.map.ILogicalField;
import com.indy.map.InputParameter;
import com.indy.map.MapModelItem;
import com.indy.map.QueryField;
import com.indy.map.UDFRef;
import com.indy.map.Variable;
import com.indy.map.impl.custom.Outliner;
import com.indy.map.ref.RClause;
import com.indy.map.ref.RComputedField;
import com.indy.map.ref.RDatastore;
import com.indy.map.ref.RProblem;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RUDFRef;
import com.indy.map.ref.RUsage;
import com.indy.map.validation.ProblemValidationStatus;
import com.indy.xsl.global.Functions;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.registry.UDF;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.example.map.custom.command.UpdateFieldRefCommand;

public class UsageConstraint
extends AbstractModelConstraint {
    private IRegistryService registryService = (IRegistryService)E4InjectorHelper.getService(IRegistryService.class);

    public IStatus validate(IValidationContext ctx) {
        try {
            EObject eObj = ctx.getTarget();
            if (eObj instanceof RUsage || eObj instanceof Clause || eObj instanceof Expression || eObj instanceof ComputedField) {
                String[] functionList;
                RUsage usage = null;
                usage = eObj instanceof Clause ? (RUsage)((Clause)eObj).getMapReference() : (eObj instanceof Expression ? (RUsage)((Expression)eObj).getMapReference() : (eObj instanceof ComputedField ? (RUsage)((ComputedField)eObj).getMapReference() : (RUsage)eObj));
                HashSet<ProblemValidationStatus.ProblemEntry> l = new HashSet<ProblemValidationStatus.ProblemEntry>();
                String modelExpression = null;
                try {
                    modelExpression = usage instanceof RComputedField ? ((ComputedField)usage.getDataModel()).getFormula() : (usage instanceof RClause ? ((Clause)usage.getDataModel()).getExpression() : ((Expression)usage.getDataModel()).getExpression());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (usage.getInternalExpression() != null && !usage.getInternalExpression().trim().equals("") && (modelExpression == null || modelExpression.trim().equals(""))) {
                    l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_UNPARSED_EXPRESSION, null));
                }
                HashSet<String> resolvedField = new HashSet<String>();
                String parsedExpression = null;
                parsedExpression = UpdateFieldRefCommand.parseExpression(modelExpression);
                String[] stringArray = functionList = Functions.variableListAll((String)parsedExpression);
                int n = functionList.length;
                int n2 = 0;
                while (n2 < n) {
                    String fieldName = stringArray[n2];
                    if (fieldName.startsWith("#")) {
                        fieldName = fieldName.substring(2, fieldName.length() - 2);
                        for (RSourceItem it : usage.getSourceRef()) {
                            IRegistryService.IRegistry registry;
                            MapModelItem eob = it.getDataModel();
                            if (this.isOutlinerInput(eob)) {
                                l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_FIELD_SRC_NOT_TOLERATED, "Outliner input cannot be used"));
                            }
                            eob.eContainer();
                            if (eob instanceof ILogicalField) {
                                boolean yesNCS;
                                boolean caseSensitive = ((ILogicalField)((Object)eob)).eContainer() instanceof Datastore ? ((RDatastore)((Datastore)eob.eContainer()).getMapReference()).isCaseSensitive() : false;
                                boolean yesCS = caseSensitive && ILogicalField.FullPathComparator.equals((ILogicalField)((Object)eob), fieldName);
                                boolean bl = yesNCS = !yesCS && !caseSensitive ? ILogicalField.FullPathComparator.equalsIgnoreCase((ILogicalField)((Object)eob), fieldName) : false;
                                if (!yesCS && !yesNCS) continue;
                                resolvedField.add(fieldName);
                                continue;
                            }
                            if (eob instanceof Variable && ((Variable)eob).getAlias() != null & ((Variable)eob).getAlias().toString().equals(fieldName)) {
                                resolvedField.add(fieldName);
                                continue;
                            }
                            if (!(eob instanceof UDFRef) || (registry = this.registryService.getRegistry(UDF.class)) == null) continue;
                            List udf = registry.find((IRegistryService.IRegistryMatcher)((RUDFRef)it).getIdentifier());
                            if (udf == null || udf.isEmpty()) {
                                l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_UDF_NOT_FOUND, null));
                                continue;
                            }
                            for (String productCode : usage.getContextualProductCode()) {
                                if (((UDF)udf.get(0)).supportProduct(productCode)) continue;
                                l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_UDF_MISSING_PRODUCT_IMPLEMENTATION, productCode));
                            }
                        }
                    }
                    ++n2;
                }
                stringArray = functionList;
                n = functionList.length;
                n2 = 0;
                while (n2 < n) {
                    String _str;
                    String str = stringArray[n2];
                    if (str.startsWith("${") && str.endsWith("}$")) {
                        _str = str.substring(2, str.length() - 2);
                        l.add(new ProblemValidationStatus.ProblemEntry(RProblem.INFO_USING_SESSION_VARIABLE, null));
                    } else {
                        _str = str.substring(2, str.length() - 2);
                        if (!resolvedField.contains(_str)) {
                            boolean resolvedAsVariable = false;
                            if (str.trim().startsWith("%{") && str.trim().endsWith("}%")) {
                                for (RSourceItem it : usage.getSourceRef()) {
                                    MapModelItem eob = it.getDataModel();
                                    if (eob instanceof Variable) {
                                        if (!_str.equals(((Variable)eob).getAlias().toString())) continue;
                                        resolvedAsVariable = true;
                                        break;
                                    }
                                    if (!(eob instanceof InputParameter) || !_str.equals(((InputParameter)eob).getName().toString())) continue;
                                    resolvedAsVariable = true;
                                    break;
                                }
                            }
                            if (!resolvedAsVariable) {
                                l.add(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_FIELDS_NOT_FOUND, str));
                            }
                        }
                    }
                    ++n2;
                }
                return new ProblemValidationStatus(usage, null, l);
            }
            return ctx.createSuccessStatus();
        }
        catch (Throwable t) {
            return new Status(4, "com.indy.gmf.map", String.valueOf(((Object)((Object)this)).getClass().getName()) + " Validation failed ", t);
        }
    }

    private boolean isOutlinerInput(MapModelItem eob) {
        if (eob instanceof QueryField && eob.eContainer() instanceof Outliner) {
            return ((Outliner)eob.eContainer()).getInputField() == eob;
        }
        return false;
    }
}

