/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.bigquery;

import com.google.api.gax.paging.Page;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.RangePartitioning;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TimePartitioning;
import com.stambia.jdbc.bigquery.metadata.MetadataBigQueryTableResultSetImpl;
import com.stambia.udriver.jdbc.DatabaseMetadataImpl;
import com.stambia.udriver.jdbc.metadata.MetadataCatalogResultSetImpl;
import com.stambia.udriver.jdbc.metadata.MetadataColumnResultSetImpl;
import com.stambia.udriver.jdbc.metadata.MetadataSchemaResultSetImpl;
import com.stambia.udriver.jdbc.metadata.MetadataTableResultSetImpl;
import com.stambia.udriver.jdbc.metadata.MetadataTableTypeResultSet;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;

public class BigQueryDatabaseMetadata
extends DatabaseMetadataImpl {
    BigQuery bigquery;

    public BigQueryDatabaseMetadata(Driver driver, Connection connection, BigQuery bigquery) {
        super(driver, connection);
        this.bigquery = bigquery;
    }

    @Override
    public ResultSet getTables(String catalogName, String schemaName, String filter, String[] typesFilter) throws SQLException {
        Page page = null;
        MetadataBigQueryTableResultSetImpl res = new MetadataBigQueryTableResultSetImpl();
        do {
            page = page == null ? this.bigquery.listTables(schemaName, new BigQuery.TableListOption[]{BigQuery.TableListOption.pageSize((long)100L)}) : page.getNextPage();
            for (Table table : page.getValues()) {
                if (filter != null && !table.getTableId().getTable().matches(filter.replace("%", "(.*)"))) continue;
                res.newRow();
                res.addField(table.getTableId().getTable(), "TABLE_NAME");
                res.addField(table.getTableId().getDataset(), "TABLE_SCHEM");
                res.addField(table.getTableId().getProject(), "TABLE_CAT");
                this.getPartition(table, res);
            }
        } while (page.hasNextPage());
        return res;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        Page page = null;
        MetadataCatalogResultSetImpl res = new MetadataCatalogResultSetImpl();
        HashSet<String> projects = new HashSet<String>();
        do {
            page = page == null ? this.bigquery.listDatasets(new BigQuery.DatasetListOption[]{BigQuery.DatasetListOption.pageSize((long)100L)}) : page.getNextPage();
            for (Dataset dataset : page.getValues()) {
                projects.add(dataset.getDatasetId().getProject());
            }
        } while (page.hasNextPage());
        for (String projectId : projects) {
            res.newRow();
            res.addField(projectId, MetadataCatalogResultSetImpl.MetadataColumnName.TABLE_CAT.name());
        }
        return res;
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        TableDefinition def = null;
        MetadataColumnResultSetImpl res = new MetadataColumnResultSetImpl();
        Table table = this.bigquery.getTable(schemaPattern, tableNamePattern, new BigQuery.TableOption[0]);
        def = table.getDefinition();
        int i = 1;
        for (Field field : def.getSchema().getFields()) {
            res.newRow();
            res.addField(table.getTableId().getTable(), MetadataColumnResultSetImpl.MetadataColumnName.TABLE_NAME.name());
            res.addField(table.getTableId().getDataset(), MetadataColumnResultSetImpl.MetadataColumnName.TABLE_SCHEM.name());
            res.addField(table.getTableId().getProject(), MetadataColumnResultSetImpl.MetadataColumnName.TABLE_CAT.name());
            res.addField(field.getName(), MetadataColumnResultSetImpl.MetadataColumnName.COLUMN_NAME.name());
            boolean nullable = false;
            boolean repeated = false;
            if (field.getMode() != null) {
                if (field.getMode().name().equals(Field.Mode.NULLABLE.name())) {
                    nullable = true;
                    repeated = false;
                } else if (field.getMode().name().equals(Field.Mode.REQUIRED.name())) {
                    nullable = false;
                    repeated = false;
                } else if (field.getMode().name().equals(Field.Mode.REPEATED.name())) {
                    nullable = true;
                    repeated = true;
                } else {
                    nullable = true;
                    repeated = false;
                }
            } else {
                nullable = true;
                repeated = false;
            }
            res.addField(nullable, MetadataColumnResultSetImpl.MetadataColumnName.NULLABLE.name());
            res.addField(repeated, MetadataColumnResultSetImpl.MetadataColumnName.IS_REPEATED.name());
            if (field.getType() == LegacySQLTypeName.RECORD) {
                res.addField(this.printFieldDescriptor(field, true), MetadataColumnResultSetImpl.MetadataColumnName.TYPE_NAME.name());
            } else {
                res.addField(this.printFieldDescriptor(field, false), MetadataColumnResultSetImpl.MetadataColumnName.TYPE_NAME.name());
            }
            res.addField(i, MetadataColumnResultSetImpl.MetadataColumnName.ORDINAL_POSITION.name());
            ++i;
        }
        return res;
    }

    private void getPartition(Table table, MetadataTableResultSetImpl res) throws SQLException {
        TableDefinition tableDefinition = table.getDefinition();
        if ("TABLE".equals(tableDefinition.getType().toString())) {
            StandardTableDefinition standardTableDefinition = (StandardTableDefinition)tableDefinition;
            RangePartitioning rangePartitioning = standardTableDefinition.getRangePartitioning();
            TimePartitioning timePartitioning = standardTableDefinition.getTimePartitioning();
            if (null != rangePartitioning) {
                res.addField("Range", MetadataBigQueryTableResultSetImpl.MetadataGoogleBigQueryPartitionColumnName.GBQ_PARTITION_TYPE.name());
                res.addField(rangePartitioning.getField(), MetadataBigQueryTableResultSetImpl.MetadataGoogleBigQueryPartitionColumnName.GBQ_PARTITION_COLUMN_NAME.name());
                RangePartitioning.Range range = rangePartitioning.getRange();
                res.addField(range.getStart(), MetadataBigQueryTableResultSetImpl.MetadataGoogleBigQueryPartitionColumnName.GBQ_RANGE_PARTITION_MIN.name());
                res.addField(range.getEnd(), MetadataBigQueryTableResultSetImpl.MetadataGoogleBigQueryPartitionColumnName.GBQ_RANGE_PARTITION_MAX.name());
                res.addField(range.getInterval(), MetadataBigQueryTableResultSetImpl.MetadataGoogleBigQueryPartitionColumnName.GBQ_RANGE_PARTITION_INTERVAL.name());
            } else if (null != timePartitioning) {
                if (null != timePartitioning.getField()) {
                    res.addField("Timestamp", MetadataBigQueryTableResultSetImpl.MetadataGoogleBigQueryPartitionColumnName.GBQ_PARTITION_TYPE.name());
                } else {
                    res.addField("Ingestion Timestamp", MetadataBigQueryTableResultSetImpl.MetadataGoogleBigQueryPartitionColumnName.GBQ_PARTITION_TYPE.name());
                }
                res.addField(timePartitioning.getField(), MetadataBigQueryTableResultSetImpl.MetadataGoogleBigQueryPartitionColumnName.GBQ_PARTITION_COLUMN_NAME.name());
                TimePartitioning.Type timePartitioningType = timePartitioning.getType();
                String type = timePartitioningType.name().substring(0, 1).toUpperCase() + timePartitioningType.name().substring(1).toLowerCase();
                res.addField(type, MetadataBigQueryTableResultSetImpl.MetadataGoogleBigQueryPartitionColumnName.GBQ_TIME_PARTITION_TYPE.name());
            }
        }
    }

    private String printFieldDescriptor(Field field, boolean addInfo) {
        boolean repeated;
        boolean nullable;
        if (field.getMode() != null) {
            if (field.getMode().name().equals(Field.Mode.NULLABLE.name())) {
                nullable = true;
                repeated = false;
            } else if (field.getMode().name().equals(Field.Mode.REQUIRED.name())) {
                nullable = false;
                repeated = false;
            } else if (field.getMode().name().equals(Field.Mode.REPEATED.name())) {
                nullable = true;
                repeated = true;
            } else {
                nullable = true;
                repeated = false;
            }
        } else {
            nullable = true;
            repeated = false;
        }
        Object type = field.getType().name();
        if (addInfo) {
            type = (String)type + "|" + nullable;
            type = (String)type + "|" + repeated;
        }
        if (field.getType() == LegacySQLTypeName.RECORD) {
            Object ret = type;
            ret = (String)ret + "<";
            int i = 0;
            for (Field child : field.getSubFields()) {
                if (i > 0) {
                    ret = (String)ret + ",";
                }
                ++i;
                ret = (String)ret + child.getName() + ":";
                ret = (String)ret + this.printFieldDescriptor(child, addInfo);
            }
            ret = (String)ret + ">";
            return ret;
        }
        return type;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        Page page = null;
        MetadataSchemaResultSetImpl res = new MetadataSchemaResultSetImpl();
        do {
            page = page == null ? this.bigquery.listDatasets(new BigQuery.DatasetListOption[]{BigQuery.DatasetListOption.pageSize((long)100L)}) : page.getNextPage();
            for (Dataset dataset : page.getValues()) {
                if (catalog != null && !dataset.getDatasetId().getProject().equals(catalog) || schemaPattern != null && !dataset.getDatasetId().getDataset().equals(schemaPattern)) continue;
                res.newRow();
                res.addField(dataset.getDatasetId().getDataset(), MetadataSchemaResultSetImpl.MetadataColumnName.TABLE_SCHEM.name());
                res.addField(dataset.getDatasetId().getProject(), MetadataSchemaResultSetImpl.MetadataColumnName.TABLE_CAT.name());
            }
        } while (page.hasNextPage());
        return res;
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        MetadataTableTypeResultSet mt = new MetadataTableTypeResultSet();
        mt.newRow();
        mt.addField("TABLE", "TABLE_TYPE");
        return mt;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "GoogleBigQuery";
    }
}

