/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.bigquery;

import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.TableResult;
import com.stambia.udriver.jdbc.ResultSetImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.Iterator;
import java.util.List;

public class BigQueryResultSet
extends ResultSetImpl {
    TableResult tr;
    Iterator<FieldValueList> all;
    List<FieldValue> current;
    FieldValue lastValue;
    public static final String bqDateTimeFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String bqTimeFormat = "HH:mm:ss.SSS";

    public void setTableResult(TableResult tr) {
        this.tr = tr;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.all == null) {
            this.all = this.tr.iterateAll().iterator();
        }
        if (this.all.hasNext()) {
            this.current = (List)this.all.next();
            return true;
        }
        return false;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.lastValue = this.getFieldValue(columnIndex);
        if (this.lastValue != null) {
            return this.lastValue.getStringValue();
        }
        return null;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.lastValue = this.getFieldValue(columnIndex);
        if (this.lastValue != null) {
            return this.lastValue.getBooleanValue();
        }
        return false;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.lastValue = this.getFieldValue(columnIndex);
        if (this.lastValue != null) {
            return this.lastValue.getBytesValue();
        }
        return null;
    }

    FieldValue getFieldValue(int columnIndex) {
        FieldValue fv = this.current.get(columnIndex - 1);
        if (fv.isNull()) {
            return null;
        }
        return fv;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastValue == null || this.lastValue.isNull();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.lastValue = this.getFieldValue(columnIndex);
        if (this.lastValue != null) {
            return this.lastValue.getDoubleValue();
        }
        return 0.0;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        try {
            this.lastValue = this.getFieldValue(columnIndex);
            if (this.lastValue != null) {
                return Math.toIntExact(this.lastValue.getLongValue());
            }
        }
        catch (ArithmeticException e) {
            throw new SQLException(e);
        }
        return 0;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.lastValue = this.getFieldValue(columnIndex);
        if (this.lastValue != null) {
            return this.lastValue.getLongValue();
        }
        return 0L;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.lastValue = this.getFieldValue(columnIndex);
        if (this.lastValue != null) {
            long timestamp = 0L;
            try {
                timestamp = this.lastValue.getTimestampValue();
            }
            catch (Exception e) {
                try {
                    timestamp = new SimpleDateFormat(bqDateTimeFormat).parse(this.lastValue.getStringValue()).getTime() * 1000L;
                }
                catch (Exception e0) {
                    throw new SQLException(e0);
                }
            }
            return com.google.cloud.Timestamp.ofTimeMicroseconds((long)timestamp).toSqlTimestamp();
        }
        return null;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.lastValue = this.getFieldValue(columnIndex);
        if (this.lastValue != null) {
            return this.lastValue.getValue();
        }
        return null;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> className) throws SQLException {
        this.lastValue = this.getFieldValue(columnIndex);
        if (this.lastValue != null) {
            if (className == null) {
                throw new SQLException("requested type cannot be null");
            }
            if (className == LocalTime.class) {
                return className.cast(this.getTime(columnIndex));
            }
        }
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.lastValue = this.getFieldValue(columnIndex);
        if (this.lastValue != null) {
            return this.lastValue.getNumericValue();
        }
        return null;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.lastValue = this.getFieldValue(columnIndex);
        if (this.lastValue != null) {
            return Date.valueOf(this.lastValue.getStringValue());
        }
        return null;
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.lastValue = this.getFieldValue(columnIndex);
        if (this.lastValue != null) {
            try {
                LocalTime localtime = LocalTime.parse(this.lastValue.getStringValue());
                return Time.valueOf(localtime);
            }
            catch (DateTimeParseException e) {
                throw new SQLException(e);
            }
        }
        return null;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s != null) {
            return new StringReader(s);
        }
        return null;
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.lastValue = this.getFieldValue(columnIndex);
        if (this.lastValue != null) {
            return new ByteArrayInputStream(this.lastValue.getBytesValue());
        }
        return null;
    }
}

