/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.core.models;

import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IInternalResourceRegistry;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;

public class InternalResourceURIConverter
extends ExtensibleURIConverterImpl {
    private IInternalResourceRegistry registry;
    private ICacheService cacheService;
    private static Map<URI, URI> normalizedEnvrionmentResourceURI = Collections.synchronizedMap(new HashMap());
    private boolean normalizeFromCacheRegistry;

    public InternalResourceURIConverter() {
        this(true);
    }

    public InternalResourceURIConverter(boolean normalizeFromCacheRegistry) {
        this.normalizeFromCacheRegistry = normalizeFromCacheRegistry;
        this.registry = E4InjectorHelper.getService(IInternalResourceRegistry.class);
        this.cacheService = E4InjectorHelper.getService(ICacheService.class);
    }

    private IInternalResourceRegistry getRegistry() {
        return this.registry;
    }

    private ICacheService getCacheService() {
        return this.cacheService;
    }

    public URI normalize(URI uri) {
        if (uri.isPlatformPlugin() && uri.segment(1).equals("com.indy.environment")) {
            IInternalResourceRegistry.InternalResourceProvider p;
            URI res = null;
            res = normalizedEnvrionmentResourceURI.get(uri);
            if (res == null && (p = this.getRegistry().getProvider(uri)) != null) {
                StringBuffer buf = new StringBuffer();
                buf.append("/");
                buf.append(p.getBundleName());
                URI realURI = p.getPathRelativeToBundle(uri);
                int i = 0;
                while (i < realURI.segmentCount()) {
                    buf.append("/");
                    buf.append(URI.decode((String)realURI.segment(i)));
                    ++i;
                }
                res = URI.createPlatformPluginURI((String)buf.toString(), (boolean)true);
                normalizedEnvrionmentResourceURI.put(uri, res);
            }
            if (res != null) {
                return this.normalizeFromCache(res);
            }
        }
        if (this.normalizeFromCacheRegistry) {
            return this.normalizeFromCache(uri);
        }
        return super.normalize(uri);
    }

    private URI normalizeFromCache(URI uri) {
        ICacheService service = this.getCacheService();
        if (service == null) {
            return super.normalize(uri);
        }
        String ID = service.getSourceId(uri);
        if (ID == null) {
            return super.normalize(uri);
        }
        URI cacheURI = service.findResourceURIByFileId(ID);
        if (cacheURI != null) {
            String fragment = null;
            fragment = uri.fragment();
            if (fragment != null) {
                cacheURI = cacheURI.appendFragment(fragment);
            }
            return super.normalize(cacheURI);
        }
        return super.normalize(uri);
    }
}

