/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.core.services.registry;

import com.semarchy.xdi.designer.core.services.IRegistryService;
import java.io.Serializable;
import org.eclipse.core.runtime.Assert;

public class ModuleRequirment
implements IRegistryService.RegistryItem,
Serializable {
    private ModuleRequirmentKey key;

    public ModuleRequirment(String fileID, String moduleName, String baseModule) {
        Assert.isNotNull((Object)fileID);
        Assert.isNotNull((Object)baseModule, (String)("Null baseModule for fileID=" + fileID));
        this.key = new ModuleRequirmentKey(fileID, moduleName, baseModule);
    }

    public String getRequiredModuleName() {
        return this.key.getModuleName();
    }

    public String getRequiredBaseModule() {
        return this.key.getBaseModuleName();
    }

    @Override
    public IRegistryService.IRegistryKey getRegistrationKey() {
        return this.key;
    }

    public static class ModuleRequirmentKey
    implements IRegistryService.IRegistryKey,
    Serializable {
        private static final long serialVersionUID = -7540260726388578070L;
        private String fileID;
        private String moduleName;
        private String baseModuleName;
        private String internalKey;

        public ModuleRequirmentKey(String fileID, String moduleName, String baseModuleName) {
            this.fileID = fileID;
            this.moduleName = moduleName;
            this.baseModuleName = baseModuleName;
            this.internalKey = String.valueOf(fileID) + "|" + moduleName + "|" + baseModuleName;
        }

        @Override
        public boolean match(Object o) {
            if (o instanceof ModuleRequirmentKey) {
                return this.internalKey.equals(((ModuleRequirmentKey)o).internalKey);
            }
            return false;
        }

        public int hashCode() {
            return this.internalKey.hashCode();
        }

        public boolean equals(Object obj) {
            return this.match(obj);
        }

        @Override
        public String getProviderFileID() {
            return this.fileID;
        }

        public String toString() {
            return String.valueOf(this.getProviderFileID()) + "_" + this.internalKey;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public String getBaseModuleName() {
            return this.baseModuleName;
        }
    }
}

