/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.core.utils;

import com.semarchy.xdi.designer.core.models.EMFResourceOptions;
import com.semarchy.xdi.designer.core.models.IMetaDataInformationsProviderFactory;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class MemoryPreserverEditingDomainWrapper {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private TransactionalEditingDomain editingDomain = null;
    private IMetaDataInformationsProviderFactory mdInfoProviderFactory;
    private int availableMemoryThreshold = 15;

    public MemoryPreserverEditingDomainWrapper(IMetaDataInformationsProviderFactory mdInfoProviderFactory, int availableMemoryThreshold) {
        this.mdInfoProviderFactory = mdInfoProviderFactory;
        this.availableMemoryThreshold = availableMemoryThreshold;
    }

    public final TransactionalEditingDomain getEditingDomain() {
        if (this.editingDomain == null) {
            this.createEditingDomain();
        }
        return this.editingDomain;
    }

    public final void releaseMemory() {
        if (this.editingDomain == null) {
            return;
        }
        try {
            this.logger.trace("Clearing memory ...");
            this.editingDomain.getCommandStack().flush();
            this.clearMetaDataInfoProvider();
            this.editingDomain.getResourceSet().getResources().stream().filter(r -> r != null).forEach(r -> r.unload());
            this.editingDomain.getResourceSet().getResources().clear();
            this.logger.trace("Cleared memory");
        }
        catch (Exception t) {
            block5: {
                this.logger.warn("Error while clearing memory", (Throwable)t);
                this.clearMetaDataInfoProvider();
                try {
                    this.editingDomain.dispose();
                }
                catch (Exception ex) {
                    if (!this.logger.isDebugEnabled()) break block5;
                    this.logger.debug("Error while clearing memory", (Throwable)t);
                }
            }
            this.createEditingDomain();
        }
    }

    public final Resource loadResource(URI mapModelURI) {
        TransactionalEditingDomain localDomain = this.getEditingDomain();
        Resource r = null;
        try {
            r = localDomain.getResourceSet().getResource(mapModelURI, false);
            if (r != null) {
                r.unload();
                localDomain.getResourceSet().getResources().remove((Object)r);
            }
            r = localDomain.getResourceSet().getResource(mapModelURI, true);
        }
        catch (Exception ex) {
            localDomain.getCommandStack().flush();
            r = localDomain.getResourceSet().getResource(mapModelURI, false);
            if (r != null) {
                r.unload();
                localDomain.getResourceSet().getResources().remove((Object)r);
            }
            throw ex;
        }
        return r;
    }

    public final boolean releaseWhenMemoryIsThin() {
        long maxHeap = Runtime.getRuntime().maxMemory();
        long freeHeap1 = Runtime.getRuntime().freeMemory();
        long usedHeap = Runtime.getRuntime().totalMemory() - freeHeap1;
        long totalFreeHeap = Runtime.getRuntime().maxMemory() - usedHeap;
        double freePercentage = (double)totalFreeHeap * 100.0 / (double)maxHeap;
        if (freePercentage > (double)this.availableMemoryThreshold || this.editingDomain == null) {
            return false;
        }
        this.logger.info("Available Heap Size is getting thin, releasing EMF resources ...");
        this.editingDomain.getCommandStack().flush();
        ResourceSet rs = this.editingDomain.getResourceSet();
        Iterator it = rs.getResources().iterator();
        while (it.hasNext()) {
            Resource r = (Resource)it.next();
            if (r == null || !r.isLoaded()) continue;
            r.unload();
            it.remove();
        }
        this.editingDomain.getResourceSet().getResources().clear();
        System.gc();
        return true;
    }

    public final void clearMetaDataInfoProvider() {
        if (this.editingDomain == null) {
            return;
        }
        IMetaDataInformationsProviderFactory.Clearable mdInfoProvider = (IMetaDataInformationsProviderFactory.Clearable)this.editingDomain.getResourceSet().getLoadOptions().get(EMFResourceOptions.LOAD_OPTION_METADATA_INFORMATION_PROVIDER);
        if (mdInfoProvider != null) {
            mdInfoProvider.clear();
        }
    }

    private void createEditingDomain() {
        this.editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
        ResourceSet rs = this.editingDomain.getResourceSet();
        rs.setURIConverter((URIConverter)new InternalResourceURIConverter());
        rs.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        rs.getLoadOptions().put(EMFResourceOptions.LOAD_OPTION_NO_EXTERNAIZATION_LOADING, Boolean.TRUE);
        rs.getLoadOptions().put("com.indy.emf.uri.resource.load.detectDuplicateId", Boolean.FALSE);
        if (this.mdInfoProviderFactory != null) {
            rs.getLoadOptions().put(EMFResourceOptions.LOAD_OPTION_METADATA_INFORMATION_PROVIDER, this.mdInfoProviderFactory.createMetaDataInformationsProvider(rs));
        }
    }

    public void dispose() {
        this.releaseMemory();
        if (this.editingDomain != null) {
            this.editingDomain.dispose();
        }
        this.editingDomain = null;
    }
}

