/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.base.core.auth;

import com.semarchy.xdi.base.core.auth.OAuth2;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Map;

public class OAuth2Metadata {
    public static final String GRANT_TYPE_4_1 = "Authorization Code Grant";
    public static final String GRANT_TYPE_4_2 = "Implicit Grant";
    public static final String GRANT_TYPE_4_3 = "Resource Owner Password Credentials Grant";
    public static final String GRANT_TYPE_4_4 = "Client Credentials Grant";
    public static final String HTTP_METHOD_POST = "POST";
    public static final String HTTP_METHOD_GET = "GET";
    public String state;
    public String login;
    public String password;
    public String securityToken;
    public String flowType;
    public String accessToken;
    public String refreshToken;
    public String clientSecret;
    public String clientId;
    public Map<String, String> additionnalParameters;
    public Map<String, String> additionnalHttpHeaders;
    public OAuth2.CredentialMode clientCredentialPolicy;
    public long expiresIn = -1L;
    public String tokenEndpoint;
    public String tokenEndpointHttpMethod = "POST";
    public long refreshTime = 0L;
    public String scope;
    public String authEndpoint;
    public String redirectEndpoint;
    public String code;
    public int numberOfAttempts = 1;
    public int connectionTimeout = -1;
    public String proxyHost = null;
    public int proxyPort = -1;
    public String proxyUser = null;
    public String proxyPassword = null;
    public Boolean enableHostnameVerification = true;
    public Boolean enableCertificateVerification = true;
    Logger logger = new OAuthEmptyLogger();

    public String toString() {
        return "OAuth2Metadata [accessToken=" + this.accessToken + ", refreshToken=" + this.refreshToken + ", clientSecret=" + this.clientSecret + ", clientId=" + this.clientId + ", expiresIn=" + this.expiresIn + ", tokenEndpoint=" + this.tokenEndpoint + ", refreshTime=" + this.refreshTime + ", scope=" + this.scope + ", authEndpoint=" + this.authEndpoint + ", redirectEndpoint=" + this.redirectEndpoint + ", code=" + this.code + ", numberOfAttempts=" + this.numberOfAttempts + ", connectionTimeout=" + this.connectionTimeout + "]";
    }

    public Proxy getProxy() {
        if (this.proxyHost != null) {
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, this.proxyPort));
        }
        return null;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
    }

    public static interface Logger {
        public void debug(String var1);

        public void warn(String var1, Exception var2);

        public void warn(String var1);
    }

    public class OAuthEmptyLogger
    implements Logger {
        @Override
        public void debug(String string) {
        }

        @Override
        public void warn(String string, Exception e) {
        }

        @Override
        public void warn(String string) {
        }
    }
}

