/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.edit.provider.custom;

import com.indy.gmf.map.edit.provider.custom.MapEditUtil;
import com.indy.map.Clause;
import com.indy.map.Datastore;
import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.Filter;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.IReferencable;
import com.indy.map.InputParameter;
import com.indy.map.ItemProperty;
import com.indy.map.Join;
import com.indy.map.MapLocation;
import com.indy.map.MapModelItem;
import com.indy.map.Operator;
import com.indy.map.OperatorType;
import com.indy.map.OutlinerField;
import com.indy.map.QueryField;
import com.indy.map.RejectNullValueType;
import com.indy.map.SetDescriptor;
import com.indy.map.TargetFilter;
import com.indy.map.edit.provider.MapEditPlugin;
import com.indy.map.ref.RClause;
import com.indy.map.ref.RExpression;
import com.indy.map.ref.RExpressionStatus;
import com.indy.map.ref.RField;
import com.indy.map.ref.RLogicalField;
import com.indy.map.ref.RParameter;
import com.indy.map.ref.RProblem;
import com.indy.map.ref.RUsage;
import com.indy.ui.custom.out.Activator;
import com.stambia.md.MdNode;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class MapIconAPI {
    static ImageRegistry ir = null;
    private static Map<String, ImageDescriptor> propertiesImageDescriptors;
    private static final Map<Object, Image> disabledClauseImages;

    static {
        try {
            ir = new ImageRegistry();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        propertiesImageDescriptors = new HashMap<String, ImageDescriptor>();
        disabledClauseImages = new HashMap<Object, Image>();
    }

    public static Image getDisableSetDescriptor() {
        return MapIconAPI.getImage("full/obj16x22/set16x22_disable.png");
    }

    public static Image getErrorIcon(InputParameter p) {
        boolean hasProblems = false;
        for (RProblem pb : ((RParameter)p.getMapReference()).getProblem()) {
            boolean bl = hasProblems = hasProblems || pb.getProblemType().ordinal() >= RProblem.Type.WARNING.ordinal();
            if (pb.getProblemType() != RProblem.Type.ERROR) continue;
            return MapIconAPI.getImage("full/other/error_obj.gif");
        }
        if (hasProblems) {
            return MapIconAPI.getImage("full/other/warning_obj.gif");
        }
        return null;
    }

    public static Image getFieldTypeIcon(QueryField field) {
        if (field != null) {
            Image image;
            Object i;
            ArrayList<Object> images = new ArrayList<Object>();
            String id = null;
            id = "SrcFieldDisable";
            if (!((RLogicalField)field.getMapReference()).getUsage().isEmpty()) {
                id = "SrcFieldEnable";
            }
            if ((i = MapIconAPI.addTypeImage((ILogicalField)field, image = MapIconAPI.getFieldBackGroundIcon(id), id, false)) != null) {
                images.add(i);
            }
            if (field instanceof OutlinerField && ((OutlinerField)field).isUpdateKey()) {
                images.add(MapIconAPI.getImage("full/obj10x16/Key10x16.png"));
            }
            ComposedImage obj = new ComposedImage(images);
            Image retour = ExtendedImageRegistry.getInstance().getImage((Object)obj);
            return retour;
        }
        return null;
    }

    public static Image getOutlinerInputFieldImage() {
        return ExtendedImageRegistry.getInstance().getImage((Object)MapIconAPI.getImage("full/obj16x16/arrow-orange-with-blue-circle.png"));
    }

    public static Image getFieldTypeIcon(Field field) {
        if (field != null) {
            ArrayList<Object> images = new ArrayList<Object>();
            String id = null;
            id = "SrcFieldDisable";
            if (field.getMapReference() != null && !((RField)field.getMapReference()).getUsage().isEmpty()) {
                id = "SrcFieldEnable";
            }
            Image image = MapIconAPI.getFieldBackGroundIcon(id);
            images.add(MapIconAPI.addTypeImage((ILogicalField)field, image, id, true));
            if (field.eContainer() instanceof Datastore) {
                if (((Datastore)field.eContainer()).getUpdateKeyRef() == null) {
                    if (field.isUpdateKey()) {
                        images.add(MapIconAPI.getImage("full/obj10x16/Key10x16.png"));
                    }
                } else if (((Datastore)field.eContainer()).getUpdateKeyRef() instanceof MdNode) {
                    try {
                        Collection c = (Collection)((MdNode)((Datastore)field.eContainer()).getUpdateKeyRef()).evaluateXpathExpressionMdSetCached("INTERNAL_UPDATE_KEY_REF_CONTENT");
                        if (c != null && c.contains(field.getRef())) {
                            images.add(MapIconAPI.getImage("full/obj10x16/Key10x16_purple.png"));
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            if (field.getMapReference() != null && ((RField)field.getMapReference()).isMandatory()) {
                if (field.getRejectNullValue().equals((Object)RejectNullValueType.TRUE) || field.getRejectNullValue().equals((Object)RejectNullValueType.DEFAULT)) {
                    images.add(MapIconAPI.getImage("full/obj16x16/Mandatory_TR_16x16.png"));
                } else {
                    images.add(MapIconAPI.getImage("full/obj16x16/MandatoryUnchecked_TR_16x16.png"));
                }
            } else if (field.getRejectNullValue().equals((Object)RejectNullValueType.TRUE)) {
                images.add(MapIconAPI.getImage("full/obj16x16/MandatoryAdded_TR_16x16.png"));
            }
            ComposedImage obj = new ComposedImage(images);
            Image retour = ExtendedImageRegistry.getInstance().getImage((Object)obj);
            return retour;
        }
        return null;
    }

    public static Image getFieldTypeIcon(Field field, SetDescriptor editedSetDesc) {
        if (editedSetDesc == null) {
            return MapIconAPI.getFieldTypeIcon(field);
        }
        if (field != null) {
            ArrayList<Object> images = new ArrayList<Object>();
            String id = null;
            id = "SrcFieldDisable";
            if (field.getMapReference() != null) {
                for (RUsage u : ((RField)field.getMapReference()).getUsage()) {
                    if (!(u.getDataModel() instanceof Expression) || ((Expression)u.getDataModel()).getSetDescriptorRef() != editedSetDesc) continue;
                    id = "SrcFieldEnable";
                    break;
                }
            }
            Image image = MapIconAPI.getFieldBackGroundIcon(id);
            images.add(MapIconAPI.addTypeImage((ILogicalField)field, image, id, true));
            ComposedImage obj = new ComposedImage(images);
            Image retour = ExtendedImageRegistry.getInstance().getImage((Object)obj);
            return retour;
        }
        return null;
    }

    public static Image getFieldError(Field field, EObject ref) {
        RField rField;
        if (field != null && (rField = (RField)field.getMapReference()) != null && rField.getStatus() != null) {
            if (rField.getStatus().equals((Object)RExpressionStatus.ERROR) || ref != null && ref.eIsProxy()) {
                if (!rField.getUsage().isEmpty() && rField.getProblem(RProblem.ERROR_PROXY_FIELDS) != null) {
                    return MapIconAPI.getImage("full/other/error_obj.gif");
                }
                if (!field.isEnable() && !((IContainer)field.eContainer()).getSetDescriptor().isEmpty()) {
                    return MapIconAPI.getImage("full/other/error_obj_gray.gif");
                }
                return MapIconAPI.getImage("full/other/error_obj.gif");
            }
            if (rField.getStatus().equals((Object)RExpressionStatus.WARNING) || ref != null && ((MdNode)ref).getName() != null && !field.getName().equals(((MdNode)ref).getName())) {
                if (!field.isEnable() && !((IContainer)field.eContainer()).getSetDescriptor().isEmpty()) {
                    return MapIconAPI.getImage("full/other/warning_obj_gray.gif");
                }
                return MapIconAPI.getImage("full/other/warning_obj.gif");
            }
            if (rField.getStatus().equals((Object)RExpressionStatus.WARNING) || ref != null && ((MdNode)ref).getAttributeByCode("com.stambia.http.rest.content.mediaType") != null && !field.getName().equals(((MdNode)ref).getAttributeByCode("com.stambia.http.rest.content.mediaType").getValue())) {
                if (!field.isEnable() && !((IContainer)field.eContainer()).getSetDescriptor().isEmpty()) {
                    return MapIconAPI.getImage("full/other/warning_obj_gray.gif");
                }
                return MapIconAPI.getImage("full/other/warning_obj.gif");
            }
            if (rField.getStatus().equals((Object)RExpressionStatus.VALID)) {
                for (Expression e : field.getExpression()) {
                    if (((RExpression)e.getMapReference()).getProblem().isEmpty()) continue;
                    return MapIconAPI.getImage("full/other/info_obj.png");
                }
            }
        }
        return null;
    }

    public static Image getFieldError(QueryField field) {
        RLogicalField rField;
        if (field != null && (rField = (RLogicalField)field.getMapReference()) != null && rField.getStatus() != null) {
            if (rField.getStatus().equals((Object)RExpressionStatus.ERROR)) {
                if (!field.isEnable() && !((IContainer)field.eContainer()).getSetDescriptor().isEmpty()) {
                    return MapIconAPI.getImage("full/other/error_obj_gray.gif");
                }
                return MapIconAPI.getImage("full/other/error_obj.gif");
            }
            if (rField.getStatus().equals((Object)RExpressionStatus.WARNING)) {
                if (!field.isEnable() && !((IContainer)field.eContainer()).getSetDescriptor().isEmpty()) {
                    return MapIconAPI.getImage("full/other/warning_obj_gray.gif");
                }
                return MapIconAPI.getImage("full/other/warning_obj.gif");
            }
        }
        return null;
    }

    public static Image getFieldMdIcon(Field field, EObject ref) {
        if (field != null && ref != null && !ref.eIsProxy() && ref instanceof MdNode) {
            return MapEditUtil.getImage(ref);
        }
        return null;
    }

    public static Image getOnePixelTranspartentImage() {
        return MapIconAPI.getImage("full/other/Transparent1x16.png");
    }

    public static Image get13PixelTranspartentImage() {
        return MapIconAPI.getImage("full/other/Transparent13x16.png");
    }

    public static Image get7PixelTranspartentImage() {
        return MapIconAPI.getImage("full/other/transparent7x16.png");
    }

    public static Image getTrgFieldInfoIcon(Expression expression) {
        ILogicalField trgField = (ILogicalField)expression.eContainer();
        ArrayList<Image> images = new ArrayList<Image>();
        String id = null;
        if (trgField instanceof Field) {
            id = "TrgFieldInfo" + (((Field)trgField).isUpdate() ? "U" : "_") + (((Field)trgField).isInsert() ? "I" : "_") + (expression.isAggregate() ? "A" : "_") + (((Field)trgField).getTag().size() > 0 ? "T" : "_");
        } else if (trgField instanceof OutlinerField) {
            id = "TrgFieldInfo" + (((OutlinerField)trgField).isUpdate() ? "U" : "_") + (((OutlinerField)trgField).isInsert() ? "I" : "_") + (expression.isAggregate() ? "A" : "_") + (((OutlinerField)trgField).getTag().size() > 0 ? "T" : "_");
        } else {
            id = "TrgFieldInfo" + (expression.isAggregate() ? "A" : "_") + (((QueryField)trgField).getTag().size() > 0 ? "T" : "_");
            if (trgField instanceof QueryField && !((QueryField)trgField).getProperty().isEmpty()) {
                id = String.valueOf(id) + "_P";
            }
        }
        Image image = ir.get(id);
        if (image == null || image.isDisposed()) {
            if (image != null) {
                ir.remove(id);
            }
            if (trgField instanceof Field) {
                if (((Field)trgField).isUpdate()) {
                    images.add(MapIconAPI.getImage("full/obj13x16/EnableUpdate1_TL_13x16.png"));
                }
                if (((Field)trgField).isInsert()) {
                    images.add(MapIconAPI.getImage("full/obj13x16/EnableInsert1_BL_13x16.png"));
                }
            } else if (trgField instanceof OutlinerField) {
                if (((OutlinerField)trgField).isUpdate()) {
                    images.add(MapIconAPI.getImage("full/obj13x16/EnableUpdate1_TL_13x16.png"));
                }
                if (((OutlinerField)trgField).isInsert()) {
                    images.add(MapIconAPI.getImage("full/obj13x16/EnableInsert1_BL_13x16.png"));
                }
            }
            if (expression.isAggregate()) {
                images.add(MapIconAPI.getImage("full/obj13x16/Aggregate1_BR_13x16.png"));
            }
            if (((MapModelItem)trgField).getTag().size() > 0) {
                images.add(MapIconAPI.getImage("full/obj16x16/ExistsTag_TR_16x16.png"));
            }
            if (trgField instanceof QueryField && !((QueryField)trgField).getProperty().isEmpty()) {
                images.add(MapIconAPI.getImage("full/obj13x16/EnableProperty_TR2_13x16.png"));
            }
            ComposedImage obj = new ComposedImage(images);
            image = images.size() > 0 ? ExtendedImageRegistry.getInstance().getImage((Object)obj) : MapIconAPI.get13PixelTranspartentImage();
            ir.put(id, image);
        }
        return image;
    }

    private static Object addTypeImage(ILogicalField field, Image image, String prefix, boolean reduceFont) {
        String letter = null;
        int fontSize = reduceFont ? 7 : 9;
        RLogicalField refField = (RLogicalField)((IReferencable)field).getMapReference();
        if (refField != null) {
            if (refField.getType() != null && !refField.getType().isEmpty()) {
                letter = refField.getType().substring(0, 1).toUpperCase();
            } else {
                letter = "~";
                fontSize = 12;
            }
        } else {
            letter = "~";
            fontSize = 12;
        }
        if (letter != null) {
            String _id = String.valueOf(prefix) + "Letter" + letter + reduceFont;
            Image _image = ir.get(_id);
            if (_image == null || _image.isDisposed()) {
                if (_image != null) {
                    ir.remove(_id);
                    _image.dispose();
                }
                _image = new Image(image.getDevice(), image.getImageData());
                GC gc = new GC((Drawable)_image);
                gc.setTextAntialias(1);
                Font font = new Font(_image.getDevice(), "Arial", fontSize, 1);
                gc.setFont(font);
                Point p = gc.textExtent(letter);
                int x = (16 - p.x) / 2 + 1;
                x = x >= 5 ? x - 1 : x;
                int y = (16 - p.y) / 2;
                y = reduceFont ? y + 2 : y;
                gc.setForeground(Activator.getDefault().getColor(255, 255, 255));
                gc.drawString(letter, x, y, true);
                gc.dispose();
                font.dispose();
                ir.put(_id, _image);
            }
            return _image;
        }
        return image;
    }

    public static Image getQueryFieldMappedIcon(QueryField field) {
        String id = null;
        id = !field.isMapped() ? "Disable" : "Enable";
        Image image = ir.get(id = "QueryField" + id);
        if (image == null || image.isDisposed()) {
            ir.remove(id);
            ArrayList<Image> images = new ArrayList<Image>();
            images.add(MapIconAPI.getFieldTypeIcon(field));
            images.add(MapIconAPI.getFieldBackGroundIcon(id.replace("QueryField", "TrgField")));
            ComposedImage obj = new ComposedImage(images);
            image = ExtendedImageRegistry.getInstance().getImage((Object)obj);
            ir.put(id, image);
        }
        return image;
    }

    public static Image getTrgFieldLocationIcon(QueryField trgField, Expression expression) {
        String id = "QueryFieldLocation" + (trgField.isEnable() ? "E" : "D") + MapLocation.WRK.getValue();
        Image image = ir.get(id);
        if ((image == null || image.isDisposed()) && image != null) {
            ir.remove(id);
        }
        ArrayList<Image> images = new ArrayList<Image>();
        String enableStr = null;
        enableStr = trgField.isEnable() ? (expression == null || !expression.isMapped() ? "Disable" : "Enable") : "Disable";
        images.add(MapIconAPI.getFieldBackGroundIcon("TrgField" + enableStr));
        switch (expression.getLocation()) {
            case SRC: {
                images.add(MapIconAPI.getImage("full/obj16x16/LocationSource16x16.png"));
                break;
            }
            case WRK: {
                images.add(MapIconAPI.getImage("full/obj16x16/LocationWork16x16.png"));
            }
        }
        ComposedImage obj = new ComposedImage(images);
        image = ExtendedImageRegistry.getInstance().getImage((Object)obj);
        if (ir.get(id) == null) {
            ir.put(id, image);
        }
        return image;
    }

    public static Image getTrgFilterIcon(TargetFilter expression) {
        ComposedImage obj;
        ArrayList<Object> images;
        Image image;
        String id = "TrgFilter";
        id = expression.isEnable() ? String.valueOf(id) + "_enabled" : String.valueOf(id) + "_disabled";
        if (expression.isAggregate()) {
            id = String.valueOf(id) + "_agg";
        }
        if ((image = ir.get(id)) == null || image.isDisposed()) {
            if (image != null) {
                ir.remove(id);
            }
            images = new ArrayList<Object>();
            if (expression.isEnable()) {
                images.add(MapIconAPI.getImage("full/obj16x16/TargetFiltre16x16.png"));
            } else {
                images.add(MapIconAPI.getImage("full/obj16x16/TargetFiltre16x16_gray.png"));
            }
            if (expression.isAggregate()) {
                images.add(MapIconAPI.getImage("full/obj16x16/TargetFiltre16x16_agg_deco.png"));
            }
            obj = new ComposedImage(images);
            image = ExtendedImageRegistry.getInstance().getImage((Object)obj);
            ir.put(id, image);
        }
        images = new ArrayList();
        images.add(image);
        MapIconAPI.addExpressionPlaceImage((Clause)expression, images);
        MapIconAPI.addExpressionErrorImage((Clause)expression, images);
        obj = new ComposedImage(images);
        image = ExtendedImageRegistry.getInstance().getImage((Object)obj);
        return image;
    }

    public static Image getTrgFieldLocationIcon(Field trgField, Expression expression) {
        String id = "TrgFieldLocation" + (trgField.isEnable() && expression != null && expression.isMapped() ? "E" : "D") + (expression != null ? Integer.valueOf(expression.getLocation().getValue()) : "");
        Image image = ir.get(id);
        if (image == null || image.isDisposed()) {
            if (image != null) {
                ir.remove(id);
            }
            ArrayList<Image> images = new ArrayList<Image>();
            String enableStr = null;
            enableStr = trgField.isEnable() ? (expression == null || !expression.isMapped() ? "Disable" : "Enable") : "Disable";
            images.add(MapIconAPI.getFieldBackGroundIcon("TrgField" + enableStr));
            if (expression != null) {
                switch (expression.getLocation().getValue()) {
                    case 0: {
                        images.add(MapIconAPI.getImage("full/obj16x16/LocationSource16x16.png"));
                        break;
                    }
                    case 1: {
                        images.add(MapIconAPI.getImage("full/obj16x16/LocationWork16x16.png"));
                        break;
                    }
                    case 2: {
                        images.add(MapIconAPI.getImage("full/obj16x16/LocationTarget16x16.png"));
                    }
                }
            }
            ComposedImage obj = new ComposedImage(images);
            image = ExtendedImageRegistry.getInstance().getImage((Object)obj);
            ir.put(id, image);
        }
        return image;
    }

    public static Image getFieldBackGroundIcon(String id) {
        Image image = ir.get(id);
        if (image == null || image.isDisposed()) {
            if (image != null) {
                ir.remove(id);
            }
            if (id.equals("TrgFieldEnable")) {
                RGB rgb = StringConverter.asRGB((String)Platform.getPreferencesService().getString("com.indy.gmf.map.diagram", "Appearance.targetColor", "", null), (RGB)PreferenceConverter.COLOR_DEFAULT_DEFAULT);
                image = MapIconAPI.getDiagonalGradientColorImage(16, 16, rgb.red, rgb.green, rgb.blue, rgb.red, rgb.green, rgb.blue, false, true);
            } else if (id.equals("TrgFieldDisable") || id.equals("SrcFieldDisable")) {
                image = MapIconAPI.getDiagonalGradientColorImage(16, 16, 82, 82, 82, 113, 113, 113, false, true);
            } else if (id.equals("SrcFieldEnable")) {
                RGB rgb = StringConverter.asRGB((String)Platform.getPreferencesService().getString("com.indy.gmf.map.diagram", "Appearance.sourceColor", "", null), (RGB)PreferenceConverter.COLOR_DEFAULT_DEFAULT);
                image = MapIconAPI.getDiagonalGradientColorImage(16, 16, rgb.red, rgb.green, rgb.blue, rgb.red, rgb.green, rgb.blue, false, true);
            }
            ir.put(id, image);
        }
        return image;
    }

    public static Image getImage(String path) {
        Image image = ir.get(path);
        if (image == null || image.isDisposed()) {
            Object obj;
            if (image != null) {
                ir.remove(path);
                image = null;
            }
            if ((obj = MapEditPlugin.INSTANCE.getImage(path)) != null) {
                image = ExtendedImageRegistry.getInstance().getImage(obj);
            }
            if (image != null) {
                ir.put(path, image);
            }
        }
        return image;
    }

    public static Image getImage(ItemProperty prop) {
        String iconURI = prop.getDescriptor().getUIIconURI();
        Image im = null;
        if (iconURI != null) {
            ImageDescriptor desc = propertiesImageDescriptors.get(iconURI);
            if (desc == null) {
                try {
                    desc = ImageDescriptor.createFromURL((URL)new URL(iconURI));
                    propertiesImageDescriptors.put(iconURI, desc);
                }
                catch (Exception exception) {}
            }
            if (desc != null && (im = ir.get(iconURI)) == null) {
                ir.put(iconURI, desc);
                im = ir.get(iconURI);
            }
        }
        return im;
    }

    public static Image getGradientColorImage(int x, int y, int red, int green, int blue, int red2, int green2, int blue2, boolean vertical) {
        Display display = Display.getCurrent();
        Image newImage = new Image((Device)display, x, y);
        GC gc = new GC((Drawable)newImage);
        gc.setForeground(Activator.getDefault().getColor(red, green, blue));
        gc.setBackground(Activator.getDefault().getColor(red2, green2, blue2));
        gc.fillGradientRectangle(0, 0, x, y, vertical);
        gc.dispose();
        return newImage;
    }

    public static Image getDiagonalGradientColorImage(int x, int y, int red, int green, int blue, int red2, int green2, int blue2, boolean upToDown, boolean leftToRight) {
        Display display = Display.getCurrent();
        Image newImage = new Image((Device)display, x, y);
        GC gc = new GC((Drawable)newImage);
        Color color1 = Activator.getDefault().getColor(red, green, blue);
        Color color2 = Activator.getDefault().getColor(red2, green2, blue2);
        Pattern pattern = null;
        if (upToDown && leftToRight) {
            pattern = new Pattern((Device)display, 0.0f, 0.0f, (float)x, (float)y, color1, color2);
        } else if (!upToDown && leftToRight) {
            pattern = new Pattern((Device)display, 0.0f, (float)y, (float)x, 0.0f, color1, color2);
        } else if (!upToDown && !leftToRight) {
            pattern = new Pattern((Device)display, (float)x, (float)y, 0.0f, 0.0f, color1, color2);
        } else if (upToDown && !leftToRight) {
            pattern = new Pattern((Device)display, (float)x, 0.0f, 0.0f, (float)y, color1, color2);
        }
        gc.setBackgroundPattern(pattern);
        gc.fillRectangle(newImage.getBounds());
        gc.dispose();
        pattern.dispose();
        return newImage;
    }

    public static Image getExpressionImage(Clause expression) {
        ArrayList<Object> images = new ArrayList<Object>();
        MapIconAPI.addExpressionBackGroundImage(expression, images);
        MapIconAPI.addExpressionPlaceImage(expression, images);
        MapIconAPI.addExpressionErrorImage(expression, images);
        if (expression instanceof Filter) {
            if (((Filter)expression).isAggregate()) {
                images.add(MapIconAPI.getImage("full/obj22x22/AggregateFilter22x22.png"));
            }
            if (((Filter)expression).isQualify()) {
                images.add(MapIconAPI.getImage("full/obj22x22/QualifyFilter22x22.png"));
            }
        }
        ComposedImage obj = new ComposedImage(images);
        Image image = ExtendedImageRegistry.getInstance().getImage((Object)obj);
        if (expression.isEnable() || !expression.isSetEnable()) {
            return image;
        }
        if (disabledClauseImages.get(obj) != null) {
            return disabledClauseImages.get(obj);
        }
        image = new Image(image.getDevice(), image, 2);
        disabledClauseImages.put(obj, image);
        return image;
    }

    private static void addExpressionErrorImage(Clause expression, List<Object> images) {
        String filtreError = "full/obj22x22/FiltreError22x22.png";
        String joinError = "full/obj16x22/JoinError22x16.png";
        String filtreWarning = "full/obj22x22/FiltreWarning22x22.png";
        String joinWarning = "full/obj16x22/JoinWarning22x16.png";
        String filtreInfo = "full/obj22x22/FiltreInfo22x22.png";
        String joinInfo = "full/obj16x22/JoinInfo22x16.png";
        RClause ref = (RClause)expression.getMapReference();
        if (ref == null || ref.getStatus().equals((Object)RExpressionStatus.ERROR)) {
            if (expression instanceof Join) {
                images.add(MapIconAPI.getImage(joinError));
            } else {
                images.add(MapIconAPI.getImage(filtreError));
            }
        } else if (((RClause)expression.getMapReference()).getStatus().equals((Object)RExpressionStatus.WARNING)) {
            if (expression instanceof Join) {
                images.add(MapIconAPI.getImage(joinWarning));
            } else {
                images.add(MapIconAPI.getImage(filtreWarning));
            }
        } else if (!((RClause)expression.getMapReference()).getProblem().isEmpty()) {
            if (expression instanceof Join) {
                images.add(MapIconAPI.getImage(joinInfo));
            } else {
                images.add(MapIconAPI.getImage(filtreInfo));
            }
        }
    }

    private static void addExpressionPlaceImage(Clause expression, List<Object> images) {
        String location = null;
        if (expression.getLocation() != null) {
            switch (expression.getLocation()) {
                case SRC: {
                    location = "Source";
                    break;
                }
                case WRK: {
                    location = "Work";
                    break;
                }
                case TRG: {
                    location = "Target";
                }
            }
        }
        String couleur = "Rouge";
        String type = expression instanceof Clause ? "Filtre" : "Join";
        String taille = expression instanceof Clause ? "22x22" : "16x22";
        Image image = null;
        if (location != null) {
            image = MapIconAPI.getImage("full/obj" + taille + "/" + type + location + couleur + taille + ".gif");
        }
        if (image != null) {
            images.add(image);
        }
    }

    private static void addExpressionBackGroundImage(Clause expression, List<Object> images) {
        String filtreActif = "full/obj22x22/Filtre22x22SimpleBleu.gif";
        String joinActif = "full/obj16x22/JoinFondNormal16x22.gif";
        if (expression instanceof Join) {
            images.add(MapIconAPI.getImage(joinActif));
        } else if (expression instanceof Filter) {
            images.add(MapIconAPI.getImage(filtreActif));
        } else if (expression instanceof Operator) {
            if (((Operator)expression).getType() == OperatorType.EXISTS) {
                images.add(MapIconAPI.getImage("full/obj16x16/Filtre22x22Exists6.png"));
            } else {
                images.add(MapIconAPI.getImage("full/obj16x16/Filtre22x22Exists7.png"));
            }
        }
    }

    public static Image getEnableSetDescriptor() {
        return MapIconAPI.getImage("full/obj16x22/set16x22.png");
    }

    public static Image getEnableSetDescriptor16x16() {
        return MapIconAPI.getImage("full/obj16x16/set16x16.png");
    }

    public static Image getFieldMappedIcon(ILogicalField field) {
        if (field.isMapped()) {
            return MapIconAPI.getImage("full/other/field_mapped_8x16.png");
        }
        return MapIconAPI.getImage("full/other/field_unmapped_8x16.png");
    }

    public static Image getPropertyIcon() {
        return MapIconAPI.getImage("full/obj16x16/EnableProperty_TR_16x16.png");
    }

    public static Image getPropertyIcon_16x16() {
        Image bg = MapIconAPI.getDiagonalGradientColorImage(16, 16, 114, 190, 248, 114, 190, 248, false, false);
        String _id = "LetterP";
        Image _image = ir.get(_id);
        if (_image == null || _image.isDisposed()) {
            if (_image != null) {
                ir.remove(_id);
            }
            _image = new Image(bg.getDevice(), bg.getImageData());
            GC gc = new GC((Drawable)_image);
            gc.setTextAntialias(1);
            Font font = new Font(_image.getDevice(), "Arial", 9, 1);
            gc.setFont(font);
            Point p = gc.textExtent("P");
            int x = (16 - p.x) / 2 + 1;
            x = x >= 5 ? x - 1 : x;
            int y = (16 - p.y) / 2;
            gc.setForeground(Activator.getDefault().getColor(255, 255, 255));
            gc.drawString("P", x, y, true);
            gc.dispose();
            font.dispose();
            ir.put(_id, _image);
        }
        return _image;
    }

    public static Image getPropertyBlankIcon_16x16() {
        Image _image = ir.get("_blank_16x16");
        if (_image == null || _image.isDisposed()) {
            ir.remove("_blank_16x16");
            Image newImage = new Image((Device)Display.getCurrent(), 16, 16);
            GC gc = new GC((Drawable)newImage);
            gc.setBackground(new Color(null, 255, 255, 255));
            gc.setAlpha(0);
            gc.drawRectangle(0, 0, 16, 16);
            gc.dispose();
            _image = newImage;
            ir.put("_blank_16x16", _image);
            gc.dispose();
        }
        return null;
    }

    public static Image getFieldTagIcon(Field field) {
        if (field.getTag().isEmpty()) {
            return MapIconAPI.get7PixelTranspartentImage();
        }
        return MapIconAPI.getImage("full/obj7x16/ExistsTag_TL_7x16.png");
    }
}

