/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.scripting;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class StbScriptEngineManager
extends ScriptEngineManager {
    public StbScriptEngineManager(ClassLoader loader) {
        super(loader);
    }

    private ScriptEngine rhinoNonJdk() {
        ScriptEngine engine = super.getEngineByName("rhino-nonjdk");
        Bindings bindings = engine.getBindings(100);
        bindings.clear();
        try {
            engine.eval("function  println( str){print(str);};");
        }
        catch (ScriptException e) {
            throw new IllegalStateException(e);
        }
        return engine;
    }

    private ScriptEngine nashornRhinoCompat() {
        ScriptEngine engine = super.getEngineByName("nashorn");
        Bindings bindings = engine.getBindings(100);
        bindings.clear();
        try {
            engine.eval("function  println( str){print(str);};load('nashorn:mozilla_compat.js')");
        }
        catch (ScriptException e) {
            throw new IllegalStateException(e);
        }
        return engine;
    }

    private ScriptEngine other(String engineName) {
        ScriptEngine engine = super.getEngineByName(engineName);
        Bindings bindings = engine.getBindings(100);
        bindings.clear();
        return engine;
    }

    @Override
    public ScriptEngine getEngineByName(String engineName) {
        return this.getEngineByName(engineName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptEngine getEngineByName(String engineName, ClassLoader cl) {
        ClassLoader cl2 = null;
        try {
            if (cl != null) {
                cl2 = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(cl);
            }
            switch (engineName) {
                case "rhino": 
                case "rhino-nonjdk": {
                    ScriptEngine scriptEngine = this.rhinoNonJdk();
                    return scriptEngine;
                }
                case "nashorn-rhino": {
                    ScriptEngine scriptEngine = this.nashornRhinoCompat();
                    return scriptEngine;
                }
            }
            ScriptEngine scriptEngine = this.other(engineName);
            return scriptEngine;
        }
        finally {
            if (cl2 != null) {
                Thread.currentThread().setContextClassLoader(cl2);
            }
        }
    }
}

