/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.bigquery;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.storage.Storage;
import com.stambia.jdbc.bigquery.BigQueryDatabaseMetadata;
import com.stambia.jdbc.bigquery.BigQueryPreparedStatement;
import com.stambia.udriver.jdbc.ConnectionImpl;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class BigQueryConnection
extends ConnectionImpl {
    private Storage storage;
    private String jobsLocation;
    private int backendErrorRetryNumber = -1;
    private int backendErrorRetryDelay = -1;
    Driver driver;
    BigQueryOptions options;
    BigQuery bigquery;

    public BigQueryConnection(Driver driver, BigQueryOptions options, BigQuery bigquery, Storage storage, String jobsLocation, int backendErrorRetryNumber, int backendErrorRetryDelay) {
        this.options = options;
        this.bigquery = bigquery;
        this.storage = storage;
        this.driver = driver;
        this.jobsLocation = jobsLocation;
        this.backendErrorRetryNumber = backendErrorRetryNumber;
        this.backendErrorRetryDelay = backendErrorRetryDelay;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public BigQuery getBigQuery() {
        return this.bigquery;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new BigQueryDatabaseMetadata(this.driver, this, this.bigquery);
    }

    @Override
    public Statement createStatement() throws SQLException {
        BigQueryPreparedStatement st = new BigQueryPreparedStatement(this.bigquery, this.storage, null, this.jobsLocation, this.backendErrorRetryNumber, this.backendErrorRetryDelay);
        return st;
    }

    @Override
    public PreparedStatement prepareStatement(String query) throws SQLException {
        BigQueryPreparedStatement st = new BigQueryPreparedStatement(this.bigquery, this.storage, query, this.jobsLocation, this.backendErrorRetryNumber, this.backendErrorRetryDelay);
        return st;
    }

    @Override
    public String getCatalog() throws SQLException {
        return ((BigQueryOptions)this.bigquery.getOptions()).getProjectId();
    }
}

