/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.bigquery;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.TransportOptions;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.http.HttpTransportOptions;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.stambia.jdbc.bigquery.BigQueryConnection;
import com.stambia.jdbc.bigquery.Messages;
import com.stambia.udriver.jdbc.DriverImpl;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Set;

public class BigQueryDriver
extends DriverImpl {
    private static final String PARAMETERS_START = "\\?";
    private static final int PARAMETERS_INDEX = 1;
    private static final String PARAMETERS_SEPARATOR = "&";
    private static final String PARAMETER_NAME_VALUE_SEPARATOR = "=";
    private static final int PARAMETER_VALUE_INDEX = 1;
    private static final String JOBS_LOCATION_PARAMETER = "jobsLocation";
    private static final String BACKEND_ERROR_RETRY_NUMBER_PARAMETER = "backendErrorRetryNumber";
    private static final String BACKEND_ERROR_RETRY_DELAY_PARAMETER = "backendErrorRetryDelay";
    private static final String CONNECTION_TIMEOUT_PARAMETER = "connectionTimeout";
    private static final String READ_TIMEOUT_PARAMETER = "readTimeout";
    private static final String BIGQUERY_PERMISSION = "https://www.googleapis.com/auth/bigquery";
    private static final String DRIVE_PERMISSION = "https://www.googleapis.com/auth/drive";
    private static final String STORAGE_PERMISSION = "https://www.googleapis.com/auth/devstorage.read_write";

    public BigQueryDriver() {
        super("jdbc:semarchy:bigquery(.*)|jdbc:stambia:bigquery(.*)", 1, 0);
    }

    @Override
    public Connection connect(String jdbcUrl, Properties props) throws SQLException {
        String projectId = props.getProperty("projectId");
        String credentialsFile = props.getProperty("credentialsFile");
        String credentialsString = props.getProperty("credentialsString");
        String credentialsFormat = props.getProperty("credentialsFormat");
        Integer backendErrorRetryNumber = null;
        Integer backendErrorRetryDelay = null;
        Integer readTimeout = null;
        Integer connectionTimeout = null;
        try {
            backendErrorRetryNumber = this.readPropertyIntegerValue(props, BACKEND_ERROR_RETRY_NUMBER_PARAMETER);
            backendErrorRetryDelay = this.readPropertyIntegerValue(props, BACKEND_ERROR_RETRY_DELAY_PARAMETER);
            readTimeout = this.readPropertyIntegerValue(props, READ_TIMEOUT_PARAMETER);
            connectionTimeout = this.readPropertyIntegerValue(props, CONNECTION_TIMEOUT_PARAMETER);
        }
        catch (Exception e) {
            throw new SQLException(Messages.getString("BigQueryDriver.2"), e);
        }
        try {
            String jobsLocation;
            GoogleCredentials credentials = null;
            if (credentialsFile != null && !credentialsFile.isEmpty() && "LocalFile".equals(credentialsFormat)) {
                credentialsStream = new FileInputStream(credentialsFile);
                credentials = GoogleCredentials.fromStream((InputStream)credentialsStream);
            } else if ("ApplicationDefault".equals(credentialsFormat)) {
                credentials = GoogleCredentials.getApplicationDefault();
            } else if (credentialsString != null && !credentialsString.isEmpty() && "String".equals(credentialsFormat)) {
                credentialsStream = new ByteArrayInputStream(credentialsString.getBytes());
                credentials = GoogleCredentials.fromStream((InputStream)credentialsStream);
            } else {
                throw new SQLException(Messages.getString("BigQueryDriver.1"));
            }
            Properties parameters = this.parseParameters(jdbcUrl);
            String string = jobsLocation = parameters.containsKey(JOBS_LOCATION_PARAMETER) ? parameters.getProperty(JOBS_LOCATION_PARAMETER) : null;
            if (null == backendErrorRetryNumber) {
                backendErrorRetryNumber = this.getParameterValue(parameters, BACKEND_ERROR_RETRY_NUMBER_PARAMETER, -1);
            }
            if (null == backendErrorRetryDelay) {
                backendErrorRetryDelay = this.getParameterValue(parameters, BACKEND_ERROR_RETRY_DELAY_PARAMETER, -1);
            }
            if (null == connectionTimeout) {
                connectionTimeout = this.getParameterValue(parameters, CONNECTION_TIMEOUT_PARAMETER);
            }
            if (null == readTimeout) {
                readTimeout = this.getParameterValue(parameters, READ_TIMEOUT_PARAMETER);
            }
            credentials = credentials.createScoped(Set.of(BIGQUERY_PERMISSION, DRIVE_PERMISSION, STORAGE_PERMISSION));
            BigQueryOptions.Builder bigQueryOptionsBuilder = (BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setProjectId(projectId)).setCredentials((Credentials)credentials);
            if (null != connectionTimeout || null != readTimeout) {
                HttpTransportOptions.Builder httpTransportOptionsBuilder = HttpTransportOptions.newBuilder();
                if (null != connectionTimeout) {
                    httpTransportOptionsBuilder.setConnectTimeout(connectionTimeout.intValue());
                }
                if (null != readTimeout) {
                    httpTransportOptionsBuilder.setReadTimeout(readTimeout.intValue());
                }
                bigQueryOptionsBuilder.setTransportOptions((TransportOptions)httpTransportOptionsBuilder.build());
            }
            BigQueryOptions options = bigQueryOptionsBuilder.build();
            StorageOptions sOptions = ((StorageOptions.Builder)((StorageOptions.Builder)StorageOptions.newBuilder().setProjectId(projectId)).setCredentials((Credentials)credentials)).build();
            BigQuery bigquery = (BigQuery)options.getService();
            Storage storage = (Storage)sOptions.getService();
            return new BigQueryConnection(this, options, bigquery, storage, jobsLocation, backendErrorRetryNumber, backendErrorRetryDelay);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    private Integer readPropertyIntegerValue(Properties props, String key) {
        Integer integerValue = null;
        String parameterValue = props.getProperty(key);
        if (null != parameterValue) {
            integerValue = Integer.parseInt(parameterValue);
        }
        return integerValue;
    }

    private int getParameterValue(Properties properties, String parameterName, int defaultValue) throws SQLException {
        Integer parameterValue = this.getParameterValue(properties, parameterName);
        if (null == parameterValue) {
            parameterValue = defaultValue;
        }
        return parameterValue;
    }

    private Integer getParameterValue(Properties properties, String parameterName) throws SQLException {
        Integer parameterValue = null;
        if (properties.containsKey(parameterName)) {
            try {
                parameterValue = Integer.valueOf(properties.getProperty(parameterName));
            }
            catch (Exception e) {
                String message = String.format(Messages.getString("BigQueryUrlParameter.0"), parameterName);
                throw new SQLException(message);
            }
        }
        return parameterValue;
    }

    private Properties parseParameters(String rawUrl) {
        String[] splittedUrl;
        Properties parameters = new Properties();
        if (null != rawUrl && 1 < (splittedUrl = rawUrl.split(PARAMETERS_START)).length) {
            String rawParameters = splittedUrl[1];
            for (String rawParameter : rawParameters.split(PARAMETERS_SEPARATOR)) {
                String[] splittedParameter = rawParameter.split(PARAMETER_NAME_VALUE_SEPARATOR);
                if (1 >= splittedParameter.length) continue;
                String parameterName = splittedParameter[0];
                String parameterValue = splittedParameter[1];
                parameters.put(parameterName, parameterValue);
            }
        }
        return parameters;
    }

    static {
        try {
            DriverManager.registerDriver(new BigQueryDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException(Messages.getString("BigQueryDriver.0") + e.getMessage());
        }
    }
}

