/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.bigquery;

import com.google.cloud.RetryOption;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.QueryParameterValue;
import com.google.cloud.bigquery.TableResult;
import com.google.cloud.storage.Storage;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import com.stambia.jdbc.bigquery.BigQueryResultSet;
import com.stambia.jdbc.bigquery.Messages;
import com.stambia.udriver.jdbc.PreparedStatementImpl;
import com.stambia.udriver.jdbc.ResultSetMetaDataImpl;
import com.stambia.udriver.jdbc.tools.ScriptManagerUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.xml.bind.DatatypeConverter;

public class BigQueryPreparedStatement
extends PreparedStatementImpl {
    public static final int BACKEND_ERROR_RETRY_NUMBER_DEFAULT = -1;
    public static final int BACKEND_ERROR_RETRY_DELAY_DEFAULT = -1;
    public static final String JOB_BACKEND_ERROR = "JOBBACKENDERROR";
    public static final String JOB_INTERNAL_ERROR = "JOBINTERNALERROR";
    public static final String JOB_ID_SCRIPT_VAR = "__jobid__";
    private String jobsLocation;
    private int backendErrorRetryNumber = -1;
    private int backendErrorRetryDelay = -1;
    private static final String LINE_RETURN = "\r\n";
    private Storage storage;
    String originalQuery;
    String queryToExecute;
    BigQuery bigQuery;
    QueryJobConfiguration.Builder queryRequestBuilder;
    QueryJobConfiguration queryRequest;
    TableResult tableResult;
    ResultSet rs;
    String scriptLanguage;
    PreparedObject preparedObject = new PreparedObject();
    private int rowCount = 0;
    QueryType type;
    Object[] parameters = new Object[0];

    public BigQueryPreparedStatement(BigQuery bigquery, Storage storage, String query, String jobsLocation, int backendErrorRetryNumber, int backendErrorRetryDelay) throws SQLException {
        this.bigQuery = bigquery;
        this.storage = storage;
        this.jobsLocation = jobsLocation;
        this.backendErrorRetryNumber = backendErrorRetryNumber;
        this.backendErrorRetryDelay = backendErrorRetryDelay;
        if (query != null) {
            this.originalQuery = query;
            this.doSetQuery(this.originalQuery);
            if (this.type == QueryType.script) {
                this.rowCount = this.doExecuteScript();
            } else {
                this.doPrepareQuery(this.queryToExecute);
            }
        }
    }

    private void doSetQuery(String paramQuery) {
        if (paramQuery != null) {
            this.originalQuery = paramQuery;
            String lower = paramQuery.trim();
            if (lower.startsWith("script:")) {
                lower = lower.substring(7);
                int index = lower.indexOf("\n");
                this.scriptLanguage = lower.substring(0, index);
                this.type = QueryType.script;
                this.queryToExecute = lower.substring(index).trim();
            } else if (lower.startsWith("select")) {
                this.type = QueryType.select;
                this.queryToExecute = paramQuery;
            } else {
                this.type = QueryType.dml;
                this.queryToExecute = paramQuery;
            }
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return -1;
    }

    @Override
    public boolean execute(String paramQuery) throws SQLException {
        this.doSetQuery(paramQuery);
        this.rs = null;
        if (this.type == QueryType.script) {
            this.rowCount = this.doExecuteScript();
        } else {
            this.doPrepareQuery(this.queryToExecute);
            this.rs = this.doExecuteQuery();
        }
        return this.rs != null;
    }

    @Override
    public void addBatch() throws SQLException {
        this.execute();
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.execute();
        int tmpRowCount = this.rowCount;
        this.rowCount = 0;
        return tmpRowCount;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] arr = new int[]{this.rowCount};
        this.rowCount = 0;
        return arr;
    }

    @Override
    public boolean execute() throws SQLException {
        if (this.preparedObject.os != null) {
            try {
                this.preparedObject.prepare();
                this.preparedObject.newRow();
                for (int i = 0; i < this.preparedObject.columns.size(); ++i) {
                    Object o = this.parameters[i];
                    String name = this.preparedObject.columns.get(i);
                    this.preparedObject.addValue(name, o);
                }
                this.preparedObject.endRow();
                ++this.rowCount;
                return true;
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        return this.execute(this.queryToExecute);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.rs;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.doSetQuery(sql);
        this.doPrepareQuery(sql);
        return this.doExecuteQuery();
    }

    private void doPrepareQuery(String query) {
        this.queryToExecute = query;
        this.queryRequestBuilder = QueryJobConfiguration.newBuilder((String)query).setUseLegacySql(Boolean.valueOf(false));
    }

    private void handleBigQueryDetailException(BigQueryException bigQueryException) throws SQLException {
        List errors = bigQueryException.getErrors();
        SQLException superError = null;
        if (null != errors) {
            StringBuilder message = new StringBuilder(bigQueryException.getMessage()).append(LINE_RETURN);
            int errorNumber = errors.size();
            int errorIndex = 0;
            for (BigQueryError error : errors) {
                message = message.append(String.format(Messages.getString("BigQueryDetailedErrors.0"), ++errorIndex, errorNumber, error.getMessage()));
            }
            superError = new SQLException(message.toString(), bigQueryException.getCause());
            superError.setStackTrace(bigQueryException.getStackTrace());
        } else {
            superError = new SQLException(bigQueryException);
        }
        throw superError;
    }

    private JobId getJobId() {
        JobId.Builder jobIdBuilder = JobId.newBuilder();
        if (null != this.jobsLocation) {
            jobIdBuilder = jobIdBuilder.setLocation(this.jobsLocation);
        }
        return jobIdBuilder.build();
    }

    private SQLException handleRetryError(SQLException exception) throws SQLException {
        SQLException lastBqJobException = null;
        String originalMessage = exception.getMessage().toUpperCase();
        if (originalMessage.contains(JOB_BACKEND_ERROR) || originalMessage.contains(JOB_INTERNAL_ERROR)) {
            try {
                Thread.sleep(this.backendErrorRetryDelay);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
                throw new SQLException(e1);
            }
        } else {
            throw new SQLException(exception);
        }
        lastBqJobException = exception;
        return lastBqJobException;
    }

    private void throwRetryError(SQLException exception) throws SQLException {
        if (null != exception) {
            SQLException superError = null;
            String message = String.format(Messages.getString("BigQueryJobInterruption.0"), this.backendErrorRetryNumber, exception.getMessage());
            superError = new SQLException(message, exception.getCause());
            superError.setStackTrace(exception.getStackTrace());
            throw superError;
        }
    }

    private Job executeJob() throws SQLException {
        JobId jobId = this.getJobId();
        Job queryJob = this.bigQuery.create(JobInfo.of((JobId)jobId, (JobConfiguration)this.queryRequest), new BigQuery.JobOption[0]);
        try {
            this.tableResult = queryJob.getQueryResults(new BigQuery.QueryResultsOption[0]);
        }
        catch (BigQueryException e) {
            this.handleBigQueryDetailException(e);
            String errorMesssage = "";
            if (null != queryJob && null != queryJob.getStatus() && null != queryJob.getStatus().getError()) {
                errorMesssage = queryJob.getStatus().getError().getMessage();
                if (null == errorMesssage || errorMesssage.isEmpty()) {
                    errorMesssage = Messages.getString("BigQueryPreparedStatement.0");
                }
                throw new SQLException(errorMesssage, e);
            }
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
            throw new SQLException(e1);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        Job completeJob = null;
        try {
            completeJob = queryJob.waitFor(new RetryOption[0]);
        }
        catch (BigQueryException e) {
            this.handleBigQueryDetailException(e);
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
            throw new SQLException(e1);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return completeJob;
    }

    private Job executeJobWithRetry() throws SQLException {
        Job completeJob = null;
        SQLException lastBqJobException = null;
        for (int backendErrorRetryCounter = 0; backendErrorRetryCounter < this.backendErrorRetryNumber; ++backendErrorRetryCounter) {
            try {
                completeJob = this.executeJob();
                lastBqJobException = null;
                break;
            }
            catch (SQLException e) {
                lastBqJobException = this.handleRetryError(e);
                continue;
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }
        this.throwRetryError(lastBqJobException);
        return completeJob;
    }

    private ResultSet doExecuteQuery() throws SQLException {
        Job completeJob;
        if (this.parameters.length > 0) {
            for (Object o : this.parameters) {
                QueryParameterValue parameterValue = o instanceof Integer ? QueryParameterValue.int64((Integer)((Integer)o)) : (o instanceof Long ? QueryParameterValue.int64((Long)((Long)o)) : (o instanceof Short ? QueryParameterValue.int64((Integer)((Short)o).intValue()) : (o instanceof BigDecimal ? QueryParameterValue.bigNumeric((BigDecimal)((BigDecimal)o)) : (o instanceof Double ? QueryParameterValue.float64((Double)((Double)o)) : (o instanceof Float ? QueryParameterValue.float64((Float)((Float)o)) : (o instanceof Boolean ? QueryParameterValue.bool((Boolean)((Boolean)o)) : QueryParameterValue.string((String)o.toString())))))));
                this.queryRequestBuilder.addPositionalParameter(parameterValue);
            }
        }
        this.queryRequest = this.queryRequestBuilder.build();
        Job job = completeJob = this.backendErrorRetryNumber > 0 && this.backendErrorRetryDelay > 0 ? this.executeJobWithRetry() : this.executeJob();
        if (completeJob != null) {
            JobStatistics jobStatistics = completeJob.getStatistics();
            if (jobStatistics instanceof JobStatistics.QueryStatistics) {
                JobStatistics.QueryStatistics queryStatistics = (JobStatistics.QueryStatistics)jobStatistics;
                JobStatistics.QueryStatistics.StatementType statementType = queryStatistics.getStatementType();
                if (JobStatistics.QueryStatistics.StatementType.SELECT.equals((Object)statementType)) {
                    this.rowCount = 0;
                } else {
                    try {
                        Long numDmlAffectedRows = queryStatistics.getNumDmlAffectedRows();
                        if (numDmlAffectedRows != null) {
                            this.rowCount = numDmlAffectedRows.intValue();
                        }
                        this.rowCount = 0;
                    }
                    catch (Exception e) {
                        throw new SQLException(e);
                    }
                }
            } else {
                this.rowCount = 0;
            }
        } else {
            this.rowCount = 0;
        }
        if (this.tableResult != null && this.tableResult.getSchema() != null && this.tableResult.getSchema().getFields() != null) {
            ArrayList<ResultSetMetaDataImpl.ColumnMetadata> list = new ArrayList<ResultSetMetaDataImpl.ColumnMetadata>();
            for (Field field : this.tableResult.getSchema().getFields()) {
                ResultSetMetaDataImpl.ColumnMetadata cm = new ResultSetMetaDataImpl.ColumnMetadata();
                cm.columnName = field.getName();
                cm.columnLabel = field.getName();
                cm.columnTypeName = field.getType().name();
                cm.columnType = this.getColumnType(field);
                list.add(cm);
            }
            ResultSetMetaDataImpl rsmi = new ResultSetMetaDataImpl(list);
            BigQueryResultSet rsi = new BigQueryResultSet();
            rsi.setMetadata(rsmi);
            rsi.setTableResult(this.tableResult);
            rsi.setStatement(this);
            return rsi;
        }
        return null;
    }

    private int getColumnType(Field field) {
        switch (field.getType().getStandardType()) {
            case BYTES: {
                return -2;
            }
            case INT64: {
                return -5;
            }
            case FLOAT64: {
                return 8;
            }
            case BIGNUMERIC: 
            case NUMERIC: {
                return 2;
            }
            case BOOL: {
                return 16;
            }
            case DATETIME: 
            case TIMESTAMP: {
                return 93;
            }
            case TIME: {
                return 92;
            }
            case DATE: {
                return 91;
            }
        }
        return 12;
    }

    private void executeScript(ScriptEngine se) throws SQLException {
        try {
            JobId jobId = this.getJobId();
            Bindings b = se.getBindings(100);
            b.put(JOB_ID_SCRIPT_VAR, (Object)jobId);
            se.eval(this.queryToExecute);
        }
        catch (BigQueryException e) {
            this.handleBigQueryDetailException(e);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    private Job executeScriptWithRetry(ScriptEngine se) throws SQLException {
        Job completeJob = null;
        SQLException lastBqJobException = null;
        for (int backendErrorRetryCounter = 0; backendErrorRetryCounter < this.backendErrorRetryNumber; ++backendErrorRetryCounter) {
            try {
                this.executeScript(se);
                lastBqJobException = null;
                break;
            }
            catch (SQLException e) {
                lastBqJobException = this.handleRetryError(e);
                continue;
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }
        this.throwRetryError(lastBqJobException);
        return completeJob;
    }

    private int doExecuteScript() throws SQLException {
        ClassLoader cl = this.getClass().getClassLoader();
        ClassLoader cl2 = null;
        try {
            if (cl != null) {
                cl2 = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(cl);
            }
            ScriptEngineManager stem = ScriptManagerUtil.getScriptEngineManager(cl);
            ScriptEngine se = stem.getEngineByName(this.scriptLanguage);
            Bindings b = se.getBindings(100);
            Return ret = new Return();
            b.put("__bigquery__", (Object)this.bigQuery);
            b.put("__return__", (Object)ret);
            b.put("__storage__", (Object)this.storage);
            b.put("__preparedObject__", (Object)this.preparedObject);
            if (this.backendErrorRetryNumber > 0 && this.backendErrorRetryDelay > 0) {
                this.executeScriptWithRetry(se);
            } else {
                this.executeScript(se);
            }
            int n = ret.nbRows;
            return n;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        finally {
            if (cl2 != null) {
                Thread.currentThread().setContextClassLoader(cl2);
            }
        }
    }

    @Override
    public void setInt(int arg0, int arg1) throws SQLException {
        this.doSetValue(arg0, arg1);
    }

    private void doSetValue(int arg0, Object o) {
        int size = arg0;
        if (this.parameters.length > size) {
            size = this.parameters.length;
        }
        Object[] localParameters = new Object[size];
        for (int i = 0; i < size; ++i) {
            if (arg0 - 1 == i) {
                localParameters[i] = o;
                continue;
            }
            if (this.parameters.length <= i) continue;
            localParameters[i] = this.parameters[i];
        }
        this.parameters = localParameters;
    }

    @Override
    public void setString(int arg0, String arg1) throws SQLException {
        this.doSetValue(arg0, arg1);
    }

    @Override
    public void setBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        this.doSetValue(arg0, arg1);
    }

    @Override
    public void setBoolean(int arg0, boolean arg1) throws SQLException {
        this.doSetValue(arg0, arg1);
    }

    @Override
    public void setTime(int arg0, Time arg1) throws SQLException {
        String timeString = null;
        if (arg1 != null) {
            SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSSSSS");
            timeString = df.format(arg1);
        }
        this.doSetValue(arg0, timeString);
    }

    @Override
    public void setTimestamp(int arg0, Timestamp arg1) throws SQLException {
        String datestring = null;
        if (arg1 != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS");
            Date date = new Date(arg1.getTime());
            datestring = df.format(date);
        }
        this.doSetValue(arg0, datestring);
    }

    @Override
    public void setDate(int arg0, Date arg1) throws SQLException {
        String datestring = null;
        if (arg1 != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            datestring = df.format(arg1);
        }
        this.doSetValue(arg0, datestring);
    }

    @Override
    public void setBytes(int arg0, byte[] arg1) throws SQLException {
        String base64EncodedString = null;
        if (arg1 != null) {
            base64EncodedString = DatatypeConverter.printBase64Binary((byte[])arg1);
        }
        this.doSetValue(arg0, base64EncodedString);
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1) throws SQLException {
        String base64EncodedString = null;
        if (arg1 != null) {
            byte[] inputAsBytes;
            try {
                inputAsBytes = ByteStreams.toByteArray((InputStream)arg1);
            }
            catch (IOException e) {
                throw new SQLException(e.getMessage());
            }
            base64EncodedString = DatatypeConverter.printBase64Binary((byte[])inputAsBytes);
        }
        this.doSetValue(arg0, base64EncodedString);
    }

    @Override
    public void clearParameters() throws SQLException {
        Object[] parameters = new Object[]{};
    }

    @Override
    public void close() throws SQLException {
        try {
            this.preparedObject.close();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        super.close();
    }

    @Override
    public void setNull(int arg0, int arg1) throws SQLException {
        this.doSetValue(arg0, null);
    }

    @Override
    public void setDouble(int arg0, double arg1) throws SQLException {
        this.doSetValue(arg0, arg1);
    }

    @Override
    public void setShort(int arg0, short arg1) throws SQLException {
        this.doSetValue(arg0, arg1);
    }

    @Override
    public void setLong(int arg0, long arg1) throws SQLException {
        this.doSetValue(arg0, arg1);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.execute(sql);
        int internalRowCount = this.rowCount;
        this.rowCount = 0;
        return internalRowCount;
    }

    public class PreparedObject
    implements AutoCloseable {
        String operation;
        OutputStream os;
        List<String> columns = new ArrayList<String>();
        private JsonWriter jw;
        StreamHandler sh;
        boolean prepared;
        private Writer oswriter;
        CloseHandler ch;

        public OutputStream setPipedStream(StreamHandler sh) throws IOException {
            this.sh = sh;
            PipedInputStream in = new PipedInputStream(8192);
            PipedOutputStream out = new PipedOutputStream(in);
            Thread th = new Thread(() -> sh.readInputStream(in));
            th.setName("PipedStream2");
            th.start();
            this.os = out;
            return this.os;
        }

        public void setOutputStream(OutputStream stream) {
            this.os = stream;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }

        public void addColumn(String name) {
            this.columns.add(name);
        }

        void prepare() throws IOException {
            if (!this.prepared) {
                this.prepared = true;
                this.oswriter = new BufferedWriter(new OutputStreamWriter(this.os, StandardCharsets.UTF_8));
                GsonBuilder builder = new GsonBuilder();
                Gson gson = builder.create();
                this.jw = gson.newJsonWriter(this.oswriter);
                this.jw.setLenient(true);
            }
        }

        void newRow() throws IOException {
            this.jw.beginObject();
        }

        void addValue(String field, Object value) throws IOException {
            this.jw.name(field);
            if (value instanceof String) {
                this.jw.value((String)value);
            } else if (value instanceof Number) {
                this.jw.value((Number)value);
            } else if (value instanceof Boolean) {
                this.jw.value((Boolean)value);
            } else if (value == null) {
                this.jw.nullValue();
            } else if (value instanceof Double) {
                this.jw.value(((Double)value).doubleValue());
            } else if (value instanceof Long) {
                this.jw.value(((Long)value).longValue());
            }
        }

        void endRow() throws IOException {
            this.jw.endObject();
            this.oswriter.write(10);
        }

        @Override
        public void close() throws Exception {
            Exception exception;
            block14: {
                block13: {
                    exception = null;
                    try {
                        if (this.jw != null) {
                            this.jw.close();
                            this.jw = null;
                        }
                    }
                    catch (Exception e) {
                        exception = e;
                    }
                    try {
                        if (this.oswriter != null) {
                            this.oswriter.close();
                        }
                    }
                    catch (Exception e) {
                        if (exception != null) break block13;
                        exception = e;
                    }
                }
                try {
                    if (this.os != null) {
                        this.os.close();
                        this.os = null;
                    }
                }
                catch (Exception e) {
                    if (exception != null) break block14;
                    exception = e;
                }
            }
            if (this.ch != null) {
                try {
                    this.ch.close();
                }
                catch (BigQueryException e) {
                    BigQueryPreparedStatement.this.handleBigQueryDetailException(e);
                }
            }
            if (exception != null) {
                throw exception;
            }
        }

        public void addCloseHandler(CloseHandler ch) {
            this.ch = ch;
        }
    }

    static enum QueryType {
        select,
        ddl,
        dml,
        unkown,
        script;

    }

    public class Return {
        public int nbRows;
    }

    public static interface StreamHandler {
        public void readInputStream(InputStream var1);
    }

    public static interface CloseHandler {
        public void close();
    }
}

