/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.udriver.jdbc;

import com.stambia.udriver.jdbc.ResultSetImpl;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ArrayResultSetImpl
extends ResultSetImpl {
    List<Row> rows = new ArrayList<Row>();
    private int columnCount;
    Row currentRow;
    int position = -1;

    public void incrColumnCount() {
        ++this.columnCount;
    }

    public ArrayResultSetImpl(int columnCount) {
        this.columnCount = columnCount;
    }

    public void addField(Object data, String columnLabel) throws SQLException {
        this.currentRow.fields[this.findColumn((String)columnLabel) - 1] = data;
    }

    public void newRow() {
        this.currentRow = new Row();
        this.currentRow.fields = new Object[this.columnCount];
        this.rows.add(this.currentRow);
    }

    @Override
    public boolean next() throws SQLException {
        if (this.position < this.rows.size() - 1) {
            ++this.position;
            this.currentRow = this.rows.get(this.position);
            return true;
        }
        return false;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object o = this.currentRow.fields[columnIndex - 1];
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    class Row {
        Object[] fields;

        Row() {
        }
    }
}

