/*
 * Decompiled with CFR 0.152.
 */
package com.indy.md.ui.edit.custom;

import com.indy.md.ui.edit.custom.Messages;
import com.indy.ui.custom.out.CustomComboBoxCellEditor;
import com.stambia.md.MdNode;
import com.stambia.md.MdPackage;
import com.stambia.md.provider.MdEditPlugin;
import com.stambia.md.util.MdFactoryHelper;
import com.stambia.md.util.StbMdResourceImpl;
import com.stambia.tech.Level;
import com.stambia.tech.Property;
import com.stambia.tech.PropertyType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public abstract class MdTableViewer
extends TableViewer {
    MdNode node;
    String defTypeChildren;

    public MdTableViewer(Composite parent, int style, MdNode node, String defTypeChildren) {
        super(parent, style);
        this.node = node;
        this.defTypeChildren = defTypeChildren;
        TableLayout tableLayout = new TableLayout();
        this.getTable().setLayout((Layout)tableLayout);
        this.getTable().setHeaderVisible(true);
        this.getTable().setLinesVisible(true);
        this.getTable().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                MdTableViewer.this.handleSelection(e);
            }
        });
        Level level = ((StbMdResourceImpl)node.eResource()).getLevel(defTypeChildren);
        TableColumn objectColumn = new TableColumn(this.getTable(), 0);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 100, true));
        objectColumn.setText(Messages.MdTableViewer_0);
        objectColumn.setResizable(true);
        CellEditor[] editors = new CellEditor[level.getAttribute().size() + 2];
        TextCellEditor textEditor = new TextCellEditor((Composite)this.getTable());
        ((Text)textEditor.getControl()).setTextLimit(60);
        ICellEditorListener cel = new ICellEditorListener(){

            public void applyEditorValue() {
            }

            public void cancelEditor() {
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }
        };
        textEditor.addListener(cel);
        editors[0] = textEditor;
        String[] columnNames = new String[level.getAttribute().size() + 2];
        columnNames[0] = "md:name";
        objectColumn = new TableColumn(this.getTable(), 0);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 100, true));
        objectColumn.setText(Messages.MdTableViewer_2);
        objectColumn.setResizable(true);
        editors[1] = this.createIntegerEditor(0);
        columnNames[1] = "md:position";
        int i = 2;
        for (Property prop : level.getAttribute()) {
            boolean eval = true;
            if (eval) {
                int _style;
                columnNames[i] = prop.getCode();
                objectColumn = new TableColumn(this.getTable(), 0);
                tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 100, true));
                objectColumn.setText(prop.getDisplayName());
                if (prop.getToolTip() != null && !prop.getToolTip().isEmpty()) {
                    objectColumn.setToolTipText(prop.getToolTip());
                }
                objectColumn.setResizable(true);
                int n = _style = prop.isEditable() ? 0 : 8;
                editors[i] = prop.getType().equals((Object)PropertyType.BOOLEAN) ? new CheckboxCellEditor((Composite)this.getTable(), _style) : (prop.getType().equals((Object)PropertyType.LIST) ? this.createChoiceEditor(prop, _style) : (prop.getType().equals((Object)PropertyType.INTEGER) ? this.createIntegerEditor(_style) : this.createTextEditor(_style)));
                editors[i].addListener(cel);
            }
            ++i;
        }
        this.setColumnProperties(columnNames);
        this.setCellEditors(editors);
        this.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                Property p = ((MdNode)element).getPropertyByShortCode(property);
                Object value = property.equals("md:name") ? ((MdNode)element).getName() : (property.equals("md:position") ? (((MdNode)element).getPosition() == null ? null : ((MdNode)element).getPosition().toString()) : ((MdNode)element).getAttributeValueByShortCode(property));
                if (p != null && p.getType().equals((Object)PropertyType.BOOLEAN)) {
                    value = value != null && value.equals("1") ? Boolean.valueOf(true) : (value != null && value.equals("0") ? Boolean.valueOf(false) : (value == null || value.equals("false") ? Boolean.valueOf(false) : Boolean.valueOf(true)));
                }
                return value == null ? "" : value;
            }

            public void modify(Object element, String property, Object value) {
                String oldValue;
                MdNode node = (MdNode)((TableItem)element).getData();
                boolean modification = false;
                if (property.equals("md:name")) {
                    oldValue = node.getName();
                    if (value == null || oldValue == null || !value.equals(oldValue)) {
                        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)((MdNode)((TableItem)element).getData()));
                        ted.getCommandStack().execute((Command)new SetCommand((EditingDomain)ted, (EObject)((MdNode)((TableItem)element).getData()), (EStructuralFeature)MdPackage.eINSTANCE.getElement_Name(), value));
                        modification = true;
                    }
                } else if (property.equals("md:position")) {
                    String string = oldValue = node.getPosition() == null ? null : ((MdNode)((TableItem)element).getData()).getPosition().toString();
                    if (value == null || oldValue == null || !value.equals(oldValue)) {
                        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)((MdNode)((TableItem)element).getData()));
                        ted.getCommandStack().execute((Command)new SetCommand((EditingDomain)ted, (EObject)((MdNode)((TableItem)element).getData()), (EStructuralFeature)MdPackage.eINSTANCE.getElement_Position(), (Object)new BigInteger(value.toString())));
                        modification = true;
                    }
                } else {
                    oldValue = node.getAttributeValueByShortCode(property);
                    if (property.equals("nullable") && value != null) {
                        String val = (Boolean)value != false ? "1" : "0";
                        modification = node.setAttribute(property, val.toString(), true);
                    } else {
                        modification = node.setAttribute(property, value.toString(), true);
                    }
                }
                if (modification) {
                    MdTableViewer.this.handleModification(node, property, value, oldValue);
                    MdTableViewer.this.refresh();
                }
            }
        });
        this.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] result = MdTableViewer.this.getElements();
                if (result != null) {
                    return result;
                }
                result = new Object[((MdNode)inputElement).getNodeByCode(MdTableViewer.this.defTypeChildren).size()];
                ((MdNode)inputElement).getNodeByCode(MdTableViewer.this.defTypeChildren).toArray(result);
                return result;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
    }

    public Object[] getElements() {
        return null;
    }

    public CellEditor createIntegerEditor(int style) {
        TextCellEditor textEditor = new TextCellEditor((Composite)this.getTable(), style);
        ((Text)textEditor.getControl()).setTextLimit(60);
        ((Text)textEditor.getControl()).addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.matches("[0-9]*");
            }
        });
        return textEditor;
    }

    public CellEditor createChoiceEditor(Property prop, int style) {
        ArrayList list = new ArrayList();
        String[] values = null;
        if (prop.getMdXpathAccess() != null) {
            try {
                Object obj = this.node.evaluateMdStringList(prop.getMdXpathAccess());
                if (obj instanceof List) {
                    values = ((List)obj).toArray(new String[((List)obj).size()]);
                }
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
        }
        return new CustomComboBoxCellEditor((Composite)this.getTable(), values, style);
    }

    public CellEditor createTextEditor(int style) {
        TextCellEditor textEditor = new TextCellEditor((Composite)this.getTable(), style);
        ((Text)textEditor.getControl()).setTextLimit(60);
        return textEditor;
    }

    public void addDeletetButton(Button button) {
        Image image = ExtendedImageRegistry.getInstance().getImage(MdEditPlugin.INSTANCE.getImage("full/custom/remove.row16x16.png"));
        button.setImage(image);
        button.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                ISelection selection = MdTableViewer.this.getSelection();
                if (selection instanceof IStructuredSelection) {
                    for (Object ob : (IStructuredSelection)selection) {
                        if (!(ob instanceof MdNode)) continue;
                        MdNode previous = ((MdNode)ob).getPreviousNode();
                        MdNode following = ((MdNode)ob).getFollowingNode();
                        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)MdTableViewer.this.node);
                        ted.getCommandStack().execute((Command)new RemoveCommand((EditingDomain)ted, (EObject)MdTableViewer.this.node, (EStructuralFeature)MdPackage.eINSTANCE.getMdNode_Node(), ob));
                        MdTableViewer.this.setInput(MdTableViewer.this.node);
                        MdTableViewer.this.handleRemoveNode((MdNode)ob);
                        if (following != null) {
                            MdTableViewer.this.setSelection((ISelection)new StructuredSelection((Object)following));
                            continue;
                        }
                        if (previous == null) continue;
                        MdTableViewer.this.setSelection((ISelection)new StructuredSelection((Object)previous));
                    }
                }
            }
        });
    }

    public void addUpButton(Button button) {
        Image image = ExtendedImageRegistry.getInstance().getImage(MdEditPlugin.INSTANCE.getImage("full/custom/up.arrow16x16.png"));
        button.setImage(image);
        button.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                ISelection selection = MdTableViewer.this.getSelection();
                if (selection instanceof IStructuredSelection) {
                    for (Object ob : (IStructuredSelection)selection) {
                        if (!(ob instanceof MdNode)) continue;
                        MdNode child = (MdNode)ob;
                        MdNode previous = child.getPreviousNode();
                        MdNode folowwing = child.getFollowingNode();
                        if (previous == null) continue;
                        BigInteger previousPosition = previous.getPosition();
                        BigInteger actualPosition = child.getPosition();
                        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)MdTableViewer.this.node);
                        ted.getCommandStack().execute((Command)new SetCommand((EditingDomain)ted, (EObject)previous, (EStructuralFeature)MdPackage.eINSTANCE.getElement_Position(), (Object)actualPosition));
                        ted.getCommandStack().execute((Command)new SetCommand((EditingDomain)ted, (EObject)child, (EStructuralFeature)MdPackage.eINSTANCE.getElement_Position(), (Object)previousPosition));
                        MdTableViewer.this.setInput(MdTableViewer.this.node);
                        MdTableViewer.this.setSelection((ISelection)new StructuredSelection((Object)child));
                        MdTableViewer.this.handleMoveNode(child, previous);
                    }
                }
            }
        });
    }

    public void addDownButton(Button button) {
        Image image = ExtendedImageRegistry.getInstance().getImage(MdEditPlugin.INSTANCE.getImage("full/custom/down.arrow16x16.png"));
        button.setImage(image);
        button.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                ISelection selection = MdTableViewer.this.getSelection();
                if (selection instanceof IStructuredSelection) {
                    for (Object ob : (IStructuredSelection)selection) {
                        MdNode child;
                        MdNode following;
                        if (!(ob instanceof MdNode) || (following = (child = (MdNode)ob).getFollowingNode()) == null) continue;
                        BigInteger followingPosition = following.getPosition();
                        BigInteger actualPosition = child.getPosition();
                        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)MdTableViewer.this.node);
                        ted.getCommandStack().execute((Command)new SetCommand((EditingDomain)ted, (EObject)following, (EStructuralFeature)MdPackage.eINSTANCE.getElement_Position(), (Object)actualPosition));
                        ted.getCommandStack().execute((Command)new SetCommand((EditingDomain)ted, (EObject)child, (EStructuralFeature)MdPackage.eINSTANCE.getElement_Position(), (Object)followingPosition));
                        MdTableViewer.this.setInput(MdTableViewer.this.node);
                        MdTableViewer.this.setSelection((ISelection)new StructuredSelection((Object)child));
                        MdTableViewer.this.handleMoveNode(child, following);
                    }
                }
            }
        });
    }

    public void addNewButton(Button button) {
        Image image = ExtendedImageRegistry.getInstance().getImage(MdEditPlugin.INSTANCE.getImage("full/custom/add.row16x16.png"));
        button.setImage(image);
        button.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                final MdNode child = MdFactoryHelper.createMdNode((String)MdTableViewer.this.defTypeChildren);
                TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)MdTableViewer.this.node);
                RecordingCommand rc = new RecordingCommand(ted){

                    protected void doExecute() {
                        String lastPosition = "";
                        (this).MdTableViewer.this.node.getNode().add((Object)child);
                        try {
                            lastPosition = (this).MdTableViewer.this.node.evaluate("max(*[@defType='" + (this).MdTableViewer.this.defTypeChildren + "']/@position)+1");
                        }
                        catch (XPathExpressionException e1) {
                            e1.printStackTrace();
                        }
                        lastPosition = lastPosition == null || lastPosition.isEmpty() ? "1" : lastPosition;
                        child.setPosition(new BigInteger(lastPosition));
                        child.setName("C" + lastPosition);
                        child.setAttribute("physicalName", "C" + lastPosition, false);
                        child.setAttributeWithDefaultValue("type", false);
                        child.setAttributeWithDefaultValue("size", false);
                    }
                };
                ted.getCommandStack().execute((Command)rc);
                MdTableViewer.this.setInput(MdTableViewer.this.node);
                MdTableViewer.this.setSelection((ISelection)new StructuredSelection((Object)child));
                MdTableViewer.this.handleAddNode(child);
            }
        });
    }

    public abstract void handleModification(MdNode var1, String var2, Object var3, Object var4);

    public abstract void handleRemoveNode(MdNode var1);

    public abstract void handleMoveNode(MdNode var1, MdNode var2);

    public abstract void handleAddNode(MdNode var1);

    public abstract void handleSelection(SelectionEvent var1);

    public void setDefaultLabelProvider() {
        this.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
    }

    public class MdSorter
    extends ViewerSorter {
        private String code;

        public MdSorter(String code) {
            this.code = code;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            MdNode node1 = (MdNode)e1;
            MdNode node2 = (MdNode)e2;
            if (this.code.equals("position")) {
                return node1.getPosition() != null && node2.getPosition() != null ? node1.getPosition().compareTo(node2.getPosition()) : 0;
            }
            return super.compare(viewer, e1, e2);
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            String res = null;
            if (index == 0) {
                res = ((MdNode)obj).getName();
                if (res == null) {
                    res = "";
                }
                return res;
            }
            if (index == 1) {
                String string = res = ((MdNode)obj).getPosition() == null ? null : ((MdNode)obj).getPosition().toString();
                if (res == null) {
                    res = "";
                }
                return res;
            }
            int _index = index - 2;
            Level level = ((MdNode)obj).getLevel();
            boolean i = false;
            Property p = (Property)level.getAttribute().get(_index);
            try {
                String value = ((MdNode)obj).evaluateMdString("@" + p.getXmlName());
                if (p.getCode().equals("nullable")) {
                    String string = value != null ? (value.equals("1") ? "true" : "false") : (value = "false");
                }
                if (value == null) {
                    value = "";
                }
                return value;
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
                return "";
            }
        }

        public Image getColumnImage(Object obj, int index) {
            EObject container;
            if (index == 0 && obj instanceof MdNode && (container = ((MdNode)obj).eContainer()) instanceof MdNode) {
                for (MdNode n : ((MdNode)container).getNode()) {
                    if (n == obj) continue;
                    try {
                        if (n.getName() == null || !n.getName().equals(((MdNode)obj).getName())) continue;
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            return null;
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

