/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.cfc.presentation;

import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.indy.ui.conf.editor.Messages;
import com.indy.ui.custom.out.GlobalPropertySection;
import com.indy.ui.custom.out.fixes.MacOsTextHelper;
import com.semarchy.xdi.engine.common.exceptions.OtherExceptionI;
import com.stambia.cfc.CfcPackage;
import com.stambia.cfc.Configuration;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CfgPropertySection
extends GlobalPropertySection {
    private Text code;
    private Text description;
    private Text password;
    private Button selectionProtection;
    private Button executionProtection;

    protected void initializeControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(1808);
        parent.setLayoutData((Object)gridData);
        Composite topComposite = this.getWidgetFactory().createComposite(parent);
        topComposite.setLayoutData((Object)gridData);
        topComposite.setLayout((Layout)new GridLayout(2, false));
        MacOsTextHelper.handle((Composite)topComposite, (Composite)parent.getParent());
        this.getWidgetFactory().createLabel(topComposite, Messages.CfgPropertySection_0);
        this.code = this.getWidgetFactory().createText(topComposite, "");
        gridData = new GridData(768);
        this.code.setLayoutData((Object)gridData);
        this.connectText(this.code, true, (EStructuralFeature)CfcPackage.eINSTANCE.getConfiguration_Code(), true);
        this.getWidgetFactory().createLabel(topComposite, Messages.CfgPropertySection_2);
        this.password = this.getWidgetFactory().createText(topComposite, "", 0x400000);
        gridData = new GridData(768);
        this.password.setLayoutData((Object)gridData);
        this.connectText(this.password, false, (EStructuralFeature)CfcPackage.eINSTANCE.getConfiguration_Password(), true);
        this.selectionProtection = this.getWidgetFactory().createButton(topComposite, Messages.CfgPropertySection_4, 32);
        this.selectionProtection.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.connectCheckBox(this.selectionProtection, (EStructuralFeature)CfcPackage.eINSTANCE.getConfiguration_SelectionProtection());
        this.executionProtection = this.getWidgetFactory().createButton(topComposite, Messages.CfgPropertySection_5, 32);
        this.executionProtection.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.connectCheckBox(this.executionProtection, (EStructuralFeature)CfcPackage.eINSTANCE.getConfiguration_ExecutionProtection());
        this.createDescriptionGroup(topComposite, 2);
    }

    protected void createDescriptionGroup(Composite composite, int horizontalSpan) {
        GridData gridData = new GridData(1808);
        gridData.minimumHeight = 100;
        Group descriptionGroup = this.getWidgetFactory().createGroup(composite, Messages.CfgPropertySection_6);
        gridData.horizontalSpan = horizontalSpan;
        descriptionGroup.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        descriptionGroup.setLayout((Layout)gridLayout);
        this.description = this.getWidgetFactory().createText((Composite)descriptionGroup, "", 578);
        gridData = new GridData(1808);
        gridData.widthHint = 0;
        this.description.setLayoutData((Object)gridData);
        this.connectText(this.description, false, (EStructuralFeature)CfcPackage.eINSTANCE.getConfiguration_Description(), true);
    }

    public void refresh() {
        super.refresh();
        if (!this.isDisposed()) {
            this.executeAsReadAction(new Runnable(){

                @Override
                public void run() {
                    EObject eObject = CfgPropertySection.this.getEObject();
                    if (eObject instanceof Configuration) {
                        Configuration conf = (Configuration)eObject;
                        boolean isReadOnly = CfgPropertySection.this.isReadOnly();
                        CfgPropertySection.this.code.setText(conf.getCode() != null ? "" + conf.getCode() : "");
                        CfgPropertySection.this.description.setText(conf.getDescription() != null ? conf.getDescription() : "");
                        if (conf.getPassword() == null) {
                            CfgPropertySection.this.password.setText("");
                        } else {
                            try {
                                SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                                semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                                String decrypt = semaphoreManager.getStringAsciiInfo(conf.getPassword());
                                CfgPropertySection.this.password.setText(decrypt);
                            }
                            catch (OtherExceptionI e1) {
                                e1.printStackTrace();
                            }
                        }
                        CfgPropertySection.this.executionProtection.setSelection(conf.isExecutionProtection());
                        CfgPropertySection.this.selectionProtection.setSelection(conf.isSelectionProtection());
                    }
                }
            });
        }
    }

    protected void setValue(Object value, EStructuralFeature feature) {
        if (feature == CfcPackage.eINSTANCE.getConfiguration_Password()) {
            try {
                SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                String encrypt = semaphoreManager.setSemaphore(true, (String)value);
                super.setValue((Object)encrypt, feature);
            }
            catch (OtherExceptionI e1) {
                e1.printStackTrace();
            }
        } else {
            super.setValue(value, feature);
        }
    }
}

