/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.state;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClusterStateAction
extends TransportMasterNodeReadAction<ClusterStateRequest, ClusterStateResponse> {
    private static final Logger logger = LogManager.getLogger(TransportClusterStateAction.class);

    @Inject
    public TransportClusterStateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:monitor/state", false, transportService, clusterService, threadPool, actionFilters, ClusterStateRequest::new, indexNameExpressionResolver, ClusterStateResponse::new, "management");
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterStateRequest request, ClusterState state) {
        return null;
    }

    @Override
    protected void masterOperation(ClusterStateRequest request, ClusterState state, ActionListener<ClusterStateResponse> listener) throws IOException {
        assert (false) : "task is required";
        throw new UnsupportedOperationException("task is required");
    }

    @Override
    protected void masterOperation(Task task, final ClusterStateRequest request, final ClusterState state, final ActionListener<ClusterStateResponse> listener) throws IOException {
        Predicate<ClusterState> acceptableClusterStateOrFailedPredicate;
        assert (task instanceof CancellableTask) : task + " not cancellable";
        final CancellableTask cancellableTask = (CancellableTask)task;
        final Predicate<ClusterState> acceptableClusterStatePredicate = request.waitForMetadataVersion() == null ? clusterState -> true : clusterState -> clusterState.metadata().version() >= request.waitForMetadataVersion();
        Predicate<ClusterState> predicate = acceptableClusterStateOrFailedPredicate = request.local() ? acceptableClusterStatePredicate : acceptableClusterStatePredicate.or(clusterState -> !clusterState.nodes().isLocalNodeElectedMaster());
        if (acceptableClusterStatePredicate.test(state) && !cancellableTask.isCancelled()) {
            ActionListener.completeWith(listener, () -> this.buildResponse(request, state));
        } else {
            assert (!acceptableClusterStateOrFailedPredicate.test(state));
            new ClusterStateObserver(state, this.clusterService, request.waitForTimeout(), logger, this.threadPool.getThreadContext()).waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState newState) {
                    if (cancellableTask.notifyIfCancelled(listener)) {
                        return;
                    }
                    if (acceptableClusterStatePredicate.test(newState)) {
                        ActionListener.completeWith(listener, () -> TransportClusterStateAction.this.buildResponse(request, newState));
                    } else {
                        listener.onFailure(new NotMasterException("master stepped down waiting for metadata version " + request.waitForMetadataVersion()));
                    }
                }

                @Override
                public void onClusterServiceClose() {
                    listener.onFailure(new NodeClosedException(TransportClusterStateAction.this.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    try {
                        if (!cancellableTask.notifyIfCancelled(listener)) {
                            listener.onResponse(new ClusterStateResponse(state.getClusterName(), null, true));
                        }
                    }
                    catch (Exception e) {
                        listener.onFailure(e);
                    }
                }
            }, clusterState -> cancellableTask.isCancelled() || acceptableClusterStateOrFailedPredicate.test((ClusterState)clusterState));
        }
    }

    private ClusterStateResponse buildResponse(ClusterStateRequest request, ClusterState currentState) {
        String[] indices;
        logger.trace("Serving cluster state request using version {}", (Object)currentState.version());
        ClusterState.Builder builder = ClusterState.builder(currentState.getClusterName());
        builder.version(currentState.version());
        builder.stateUUID(currentState.stateUUID());
        builder.minimumMasterNodesOnPublishingMaster(currentState.getMinimumMasterNodesOnPublishingMaster());
        if (request.nodes()) {
            builder.nodes(currentState.nodes());
        }
        if (request.routingTable()) {
            if (request.indices().length > 0) {
                RoutingTable.Builder routingTableBuilder = RoutingTable.builder();
                for (String filteredIndex : indices = this.indexNameExpressionResolver.concreteIndexNames(currentState, request)) {
                    if (!currentState.routingTable().getIndicesRouting().containsKey(filteredIndex)) continue;
                    routingTableBuilder.add(currentState.routingTable().getIndicesRouting().get(filteredIndex));
                }
                builder.routingTable(routingTableBuilder.build());
            } else {
                builder.routingTable(currentState.routingTable());
            }
        }
        if (request.blocks()) {
            builder.blocks(currentState.blocks());
        }
        Metadata.Builder mdBuilder = Metadata.builder();
        mdBuilder.clusterUUID(currentState.metadata().clusterUUID());
        mdBuilder.coordinationMetadata(currentState.coordinationMetadata());
        if (request.metadata()) {
            if (request.indices().length > 0) {
                mdBuilder.version(currentState.metadata().version());
                for (String filteredIndex : indices = this.indexNameExpressionResolver.concreteIndexNames(currentState, request)) {
                    IndexAbstraction indexAbstraction = (IndexAbstraction)currentState.metadata().getIndicesLookup().get(filteredIndex);
                    if (indexAbstraction.getParentDataStream() != null) {
                        DataStream dataStream = indexAbstraction.getParentDataStream().getDataStream();
                        mdBuilder.put(dataStream);
                        for (Index backingIndex : dataStream.getIndices()) {
                            mdBuilder.put(currentState.metadata().index(backingIndex), false);
                        }
                        continue;
                    }
                    IndexMetadata indexMetadata = currentState.metadata().index(filteredIndex);
                    if (indexMetadata == null) continue;
                    mdBuilder.put(indexMetadata, false);
                }
            } else {
                mdBuilder = Metadata.builder(currentState.metadata());
            }
            for (ObjectObjectCursor objectObjectCursor : currentState.metadata().customs()) {
                if (((Metadata.Custom)objectObjectCursor.value).context().contains((Object)Metadata.XContentContext.API)) continue;
                mdBuilder.removeCustom((String)objectObjectCursor.key);
            }
        }
        builder.metadata(mdBuilder);
        if (request.customs()) {
            for (ObjectObjectCursor objectObjectCursor : currentState.customs()) {
                if (((ClusterState.Custom)objectObjectCursor.value).isPrivate()) continue;
                builder.putCustom((String)objectObjectCursor.key, (ClusterState.Custom)objectObjectCursor.value);
            }
        }
        return new ClusterStateResponse(currentState.getClusterName(), builder.build(), false);
    }

    static {
        String property = System.getProperty("es.cluster_state.size");
        if (property != null) {
            throw new IllegalArgumentException("es.cluster_state.size is no longer respected but was [" + property + "]");
        }
    }
}

